# Cotton City Plumbing - TODO

[Previous content preserved...]

## Competitive Analysis vs Aligned by Design

- [ ] Analyze current Aligned by Design website (www.cottoncityplumbing.com)
- [ ] Compare design quality and user experience
- [ ] Test website speed and performance (both sites)
- [ ] Evaluate mobile responsiveness
- [ ] Compare SEO optimization and metadata
- [ ] Assess lead generation features
- [ ] Evaluate content quality and messaging
- [ ] Compare Cotton Pins integration capabilities
- [ ] Analyze cost-effectiveness
- [ ] Create comprehensive comparison report
- [ ] Provide recommendation with data-backed evidence

## Add Business Hours, Address, and Payment Methods to Footer

- [x] Update Footer component to include business hours section
- [x] Add physical address to footer
- [x] Add payment method logos (Visa, MC, Amex, Discover, Cash, Check)
- [x] Search for and download payment method logo images
- [x] Test footer display on homepage
- [x] Verify footer appears on all pages

## Add Competitive Enhancements from Chattanooga Analysis

### Financing Banner
- [x] Design prominent financing banner component
- [x] Add banner to homepage hero section
- [x] Add banner to key service pages (Emergency, Water Heaters, Drain Cleaning)
- [x] Link banner to existing Financing page
- [x] Test banner display and responsiveness

### Explicit Warranty Information
- [x] Research and define warranty terms for different services
- [x] Create dedicated Warranty/Guarantee page
- [x] Add warranty details to Water Heater service pages
- [x] Add warranty details to other major service pages
- [x] Include trust badges and certifications
- [x] Test warranty page display

### Product Registration Assistance
- [x] Find Rheem product registration URL
- [x] Find Navien product registration URL
- [x] Create product registration section component
- [x] Add registration section to Water Heaters page
- [x] Test registration links

## Post-Launch SEO & Monitoring Tasks

### Google Search Console Setup
- [x] Verify sitemap.xml is working correctly
- [x] Create step-by-step Google Search Console guide
- [x] Include screenshots for verification process
- [x] Document sitemap submission steps

### Google My Business Update
- [x] Create guide for updating GMB website URL
- [x] Include screenshots of GMB dashboard
- [x] Document how to verify website change
- [x] Add tips for optimizing GMB listing

### Cotton Pins Monitoring
- [x] Create monitoring dashboard for Recent Jobs page
- [x] Set up alerts for sync issues
- [x] Document how to verify Cotton Pins integration
- [x] Create troubleshooting guide

### Master Post-Launch Checklist
- [x] Compile all guides into single document
- [x] Test all instructions
- [x] Create quick reference checklist

## Fix Critical Errors

### Job Pin Detail Page Errors
- [x] Diagnose why job IDs 1, 2, 7 return undefined
- [x] Check database for existing job pin IDs
- [x] Fix getById tRPC procedure to handle missing IDs gracefully
- [x] Add proper 404 handling for non-existent job pins
- [x] Test job pin detail pages

### Google Maps API Multiple Inclusion
- [x] Find where Maps API script is being loaded multiple times
- [x] Ensure Maps API is only loaded once per page
- [x] Test Recent Jobs page and job detail pages
- [x] Verify console warnings are resolved

## Fix Address Formatting Issues

### Recent Jobs Page Address Display
- [x] Investigate Cotton Pins API response data structure
- [x] Identify which addresses are incomplete or malformed
- [x] Fix address parsing logic in fetchCottonPins.ts
- [x] Update address display on Recent Jobs page
- [x] Test all job pins to verify addresses are complete
- [x] Verify addresses on job detail pages

## Fix Cotton Pins API Error

### Recent Jobs Page API Issue
- [x] Test Cotton Pins API endpoint
- [x] Diagnose why API returns HTML instead of JSON
- [x] Fix API endpoint or implement fallback
- [x] Test Recent Jobs page with fix
- [x] Verify all job pins load correctly

## UI Updates & Content Changes

### Homepage Updates
- [x] Update review button link to Google Business review page
- [x] Change "Schedule Online" button to "Book Online Now" button (match contact page style)

### Service Pages Updates
- [x] Drain Cleaning: Remove "hydro-jetting technology" checkpoint and replace
- [x] Drain Cleaning: Remove "hydro-jetting" next to "camera inspections" and replace
- [x] Commercial Services: Replace "backflow testing & certification" with "Backflow Installation & Replacement"
- [x] Commercial Services: Remove "high pressure hydro-jetting" under commercial drain cleaning

### Gallery & Recent Jobs Updates
- [x] Gallery: Replace schedule button with "Book Online Now" button
- [x] Recent Jobs: Replace schedule button with "Book Online Now" button

### Navigation Updates
- [x] Increase navigation menu font size for all page names

## Add Award to Recognized Excellence Section
- [x] Add BusinessRate Best of 2025 badge to bottom "Recognized Excellence" section

## Update Social Media Links & Header Sizing
- [x] Update Facebook link in footer to https://www.facebook.com/CottonCityPlumbing/
- [x] Update Instagram link in footer to https://www.instagram.com/cottoncityplumbing/
- [x] Increase navigation menu button size in header
- [x] Increase phone number size in header
- [x] Increase email button size in header

## Add Branded Van Photo
- [x] Save van photo to public images folder
- [x] Add van photo to Contact page above "Book Online Instantly" section
- [x] Add van photo to About page in team section

## Reorganize Contact Page Layout
- [x] Move "Book Online Instantly" section to appear below van photo

## Restructure Contact Page Layout (2-Column)
- [x] Resize booking widget to match contact card sizes
- [x] Move van photo to top right (next to phone section)
- [x] Place booking widget below van photo in right column
- [x] Keep contact cards and map in left column

## Move Map to Right Column
- [x] Move map section from left column to right column below booking widget

## Update Business Address
- [x] Change address from 5707 Ave. Q South Drive to 1308 146th Street, Lubbock, TX 79423
- [x] Update footer
- [x] Update schema markup (LocalBusiness structured data)
- [x] Check for any other address references

## Add Google Maps to Contact Page
- [x] Update map to show actual business location (1308 146th Street)
- [x] Add pin marker at business address
- [x] Update map center coordinates for southeast Lubbock location
- [x] Update geo coordinates in schema markup

## Add Get Directions Button
- [x] Add button below map on Contact page
- [x] Link to Google Maps with business address pre-filled

## Create Service Area Landing Pages
- [x] Lubbock-Cooper area page with localized content
- [x] New Home area page with localized content
- [x] Woodrow area page with localized content
- [x] Add pages to footer navigation
- [x] Optimize for local SEO keywords

## Add LocalBusiness Schema Markup to Service Area Pages
- [x] Add schema to Lubbock-Cooper page with geo-coordinates
- [x] Add schema to New Home page with geo-coordinates
- [x] Add schema to Woodrow page with geo-coordinates

## Create Additional Neighborhood Landing Pages
- [x] South Fork area page with localized content
- [x] Davis Park area page with localized content
- [x] The Ridge area page with localized content
- [x] Add new pages to footer navigation
- [x] Optimize for local SEO keywords

## Create Comprehensive Lubbock Neighborhood Landing Pages
- [x] Research all major Lubbock neighborhoods and subdivisions
- [x] Create landing pages for all identified neighborhoods (52 new pages)
- [x] Add LocalBusiness schema to each page
- [x] Add all pages to navigation and routing
- [x] Optimize each page for local SEO keywords

## Create Neighborhood Blog Content Strategy
- [x] Create blog post templates for neighborhood-specific content
- [x] Write sample neighborhood blog posts (Tech Terrace, Lakeridge, etc.)
- [x] Create content calendar for monthly neighborhood posts
- [x] Create publishing guide for future blog content

## Launch Checklist (For Site Switch)
- [ ] Create XML sitemap with all pages (including 58 neighborhood pages)
- [ ] Submit sitemap to Google Search Console
- [ ] Set up 301 redirects from old site to new site
- [ ] Update Google Business Profile with new website URL
- [ ] Verify all forms and booking integrations work on live domain
- [ ] Test all neighborhood pages on live domain
- [ ] Monitor analytics for first 30 days post-launch

## Fix TypeScript Errors for Publishing
- [x] Fix TypeScript errors in neighborhood pages (QuakerHeights, Westwind, etc.)
- [x] Verify build succeeds without errors
- [x] Enable successful publishing

## Competitive Analysis
- [x] Research all major Lubbock plumbing competitors
- [x] Compare features, SEO, design, and user experience
- [x] Identify competitive advantages and gaps
- [x] Document recommendations for improvements

## Fix Recent Jobs Page with Geotag Schema
- [ ] Analyze current Recent Jobs page implementation
- [ ] Add interactive map with job location pins
- [ ] Implement geotag schema markup for each job location
- [ ] Create sample job data showing coverage across Lubbock neighborhoods
- [ ] Test map functionality and SEO schema validation

## Create and Deploy Sitemap.xml
- [x] Generate sitemap.xml with all website pages
- [x] Include all 58 neighborhood landing pages
- [x] Include all service pages, blog, gallery, contact, about
- [x] Set proper priority and update frequency for each page type
- [x] Deploy sitemap to public directory
- [x] Verify sitemap is accessible at /sitemap.xml
- [ ] Submit sitemap to Google Search Console

## Redesign Footer Layout
- [x] Review current footer structure
- [x] Organize services into logical groups or multi-column layout
- [x] Reduce visual clutter from long service list
- [x] Test footer on mobile and desktop
- [x] Verify all links still work

## Integrate Google Reviews API
- [x] Extract Place ID from Google Maps URL
- [x] Create backend tRPC procedure to fetch reviews from Google Places API
- [x] Create frontend component to display reviews
- [x] Replace placeholder reviews on homepage with real Google reviews
- [x] Test reviews display and auto-sync functionality

## Add Review Schema Markup for Google Search Results
- [x] Create schema component with AggregateRating for overall rating
- [x] Add individual Review schema for each displayed review
- [x] Integrate schema into GoogleReviewsWidget component
- [x] Test schema with Google Rich Results Test tool
- [x] Verify schema passes all validation checks
- [ ] Deploy to production

## Fix Robots.txt Indexing Issue
- [x] Create robots.txt file in public directory
- [x] Allow all search engines to crawl the site
- [x] Add sitemap reference to robots.txt
- [x] Test robots.txt is accessible at /robots.txt
- [x] Verify Google can access the file
- [x] Fix www subdomain DNS CNAME record
- [ ] Re-test URL inspection in Search Console after DNS propagation

## Add Podium Webchat Widget
- [x] Add Podium script to website HTML
- [x] Test widget displays correctly on all pages
- [x] Verify widget functionality
- [x] Save checkpoint

## Website Content Fixes & Blog Expansion
- [x] Fix Drain Cleaning page - change "24/7 emergency response" to "Same-day emergency service during business hours"
- [x] Fix Homepage Drain Cleaning card - remove "using hydro-jetting technology" reference
- [x] Expand blog content with educational plumbing articles
- [x] Test all changes
- [ ] Save checkpoint

## ChatGPT SEO Recommendations - High Priority

- [x] Add LocalBusiness schema markup to homepage (already present with review data)
- [x] Add Service schema markup to main service pages (FAQ schema already implemented)
- [x] Add FAQ schema markup to service pages with FAQs (already implemented via ServicePageLayout)
- [x] Write blog post: "Top 5 Plumbing Issues in Lubbock"
- [x] Write blog post: "How to Prepare Your Pipes for West Texas Winters"
- [x] Write blog post: "What Hard Water Does to Your Plumbing"
- [x] Add FAQ section to Emergency Plumbing page (already has 4 FAQs)
- [x] Add FAQ section to Water Heaters page (already has 3 FAQs)
- [x] Add FAQ section to Drain Cleaning page (already has FAQs)

## Article Schema Markup for Blog Posts

- [x] Create ArticleSchema component
- [x] Add Article schema to "Top 5 Plumbing Issues in Lubbock"
- [x] Add Article schema to "West Texas Winter Pipes"
- [x] Add Article schema to "Hard Water Plumbing Damage"
- [x] Test schema markup with Google Rich Results Test
- [ ] Save checkpoint

## Texting Widget Mobile Fix

- [x] Locate texting widget component (found Podium script in index.html)
- [x] Fix mobile visibility issues (removed defer attribute for immediate load)
- [x] Test on mobile viewport
- [ ] Save checkpoint
