import { load } from 'cheerio';

const response = await fetch('https://cottonpins-3rqvafpp.manus.space/jobs');
const html = await response.text();
const $ = load(html);

console.log('Fetched HTML length:', html.length);

let count = 0;
$('a[href^="/jobs/"]').each((_, element) => {
  const href = $(element).attr('href');
  if (href && href !== '/jobs') {
    count++;
    const title = $(element).find('h3').first().text().trim();
    console.log(`${count}. ${title} - ${href}`);
  }
});

console.log(`\nTotal jobs found: ${count}`);
