# Squarespace Hero Section Analysis

## Current Design
The existing Squarespace website has a hero section with:
- **Black background** (solid color, not an image)
- **Large Cotton City Plumbing logo** in the center
- **White banner with red text**: "WE MAKE SURE EVERYTHING RUNS THROUGH LUBBOCK"
- **Subheading**: "YOUR LOCAL EXPERTS FOR RESIDENTIAL & COMMERCIAL PLUMBING SERVICES"
- **Call to action button**: "CALL US TODAY!"

## User Request
The user wants to replace the current hero background image (`hero-team.png` showing the team photo) with this Squarespace hero design, but **offset to the right** so the full image is visible.

## Implementation Plan
Since the Squarespace hero is primarily a **graphic design layout** (logo + text banner on black background) rather than a photo, I should:

1. **Option A**: Use the screenshot I just saved as the background, positioned to the right
2. **Option B**: Recreate the design with the large logo centered on a black background (more flexible)

The user specifically mentioned it "looks like a video" and wants to see it "in full" offset to the right, so they likely want the **entire graphic composition** (logo + banner) as the background.

## Next Steps
- Use the saved screenshot as the hero background
- Position it `background-position: right center` to offset it to the right
- Keep the overlay gradient on the left for text readability
