import { describe, it, expect } from "vitest";
import { generateAltText } from "./altTextGenerator";

describe("Alt Text Generation", () => {
  it("should generate alt text with AI when API is available", async () => {
    const altText = await generateAltText(
      "https://example.com/photo.jpg",
      "Water Heater Replacement - Tech Terrace",
      "Water Heaters",
      "3421 22nd Street, Lubbock, TX 79410"
    );

    expect(altText).toBeTruthy();
    expect(altText.length).toBeGreaterThan(0);
    expect(altText.length).toBeLessThanOrEqual(125); // Google's recommendation
    console.log("Generated alt text:", altText);
  }, 30000); // 30 second timeout for API call

  it("should use fallback alt text when API fails", async () => {
    // Test with invalid image URL to trigger fallback
    const altText = await generateAltText(
      "invalid-url",
      "Drain Cleaning - Downtown",
      "Drain Cleaning",
      "123 Main St, Lubbock, TX 79401"
    );

    expect(altText).toBeTruthy();
    expect(altText).toContain("Drain Cleaning");
    expect(altText).toContain("Lubbock");
    expect(altText.length).toBeLessThanOrEqual(125);
    console.log("Fallback alt text:", altText);
  });

  it("should handle long titles gracefully", async () => {
    const longTitle =
      "Emergency Tankless Water Heater Installation and Repair Service with Complete System Upgrade";
    const altText = await generateAltText(
      "invalid-url",
      longTitle,
      "Water Heaters",
      "456 University Ave, Lubbock, TX 79401"
    );

    expect(altText.length).toBeLessThanOrEqual(125);
    console.log("Truncated alt text:", altText);
  });

  it("should extract city from address correctly", async () => {
    const altText = await generateAltText(
      "invalid-url",
      "Gas Line Repair",
      "Gas Lines",
      "789 Broadway, Wolfforth, TX 79382"
    );

    expect(altText).toContain("Wolfforth");
    console.log("Alt text with city:", altText);
  });
});
