# Google Reviews API Integration Notes

## Key Findings

### API: Google Places API (JavaScript)
- **Endpoint**: Maps JavaScript API with Places library
- **Method**: `Place.fetchFields()` with `reviews` field
- **Limitation**: Returns up to 5 most relevant reviews per place (cannot get all reviews)
- **Authentication**: Requires Google Maps API key

### What's Available
1. **Review Data**:
   - Author name, profile URI, photo URI
   - Rating (1-5 stars)
   - Review text
   - Publish time and relative time description
   - Text language code

2. **Place Overall Rating**: Available via `Place.rating` field

### Implementation Approach
Since we already have the Manus-proxied Google Maps integration in the Map component, we can:
1. Use the existing proxy authentication (no API key needed from user)
2. Fetch reviews using the Place Details API
3. Need the Google Place ID for Cotton City Plumbing

### Limitation
- Google Places API only returns **5 reviews maximum** per request
- Cannot access all reviews programmatically
- This is a Google API limitation, not a technical issue

### Alternative Approach
Since the API is limited to 5 reviews, we could:
1. Keep the current static testimonials (which we control)
2. Add a "Read more reviews on Google" link (already implemented)
3. Or: Fetch 5 latest reviews and display them alongside curated testimonials
