# Competitive Analysis: Aligned by Design vs. New Manus Website

## Current Website (Aligned by Design) - www.cottoncityplumbing.com

### Initial Observations:

**Design & Branding:**
- Same Cotton City Plumbing logo and mascot (good brand consistency)
- Black background with red/white text
- Hero section: "WE MAKE SURE EVERYTHING RUNS THROUGH LUBBOCK"
- Clean, professional layout
- Social media links (Facebook, Instagram, URL)

**Navigation:**
- ABOUT
- PLUMBING (dropdown)
- WATER HEATERS (dropdown)
- DRAIN & SEWER (dropdown)
- COMMERCIAL (dropdown)
- JOBS (dropdown)
- FINANCING
- CALL (806) 441-4110
- BOOK ONLINE button (prominent red)

**Homepage Content:**
- Tagline: "Your Local Experts for Residential & Commercial Plumbing Services"
- Detailed intro paragraph about services
- Two main service highlights: Water Heater Services, Sewer & Gas Line Services
- "Why Choose" section with 4 key points:
  * Over 30 Years of Experience
  * Same Day & Next Day Service Available
  * Licensed, Insured & Bonded
  * Free Estimates
- Customer testimonials section (5 reviews from Rob W., Jera L., Julia U., Dom M., Fabian M.)
- Call-to-action at bottom

**Features Noted:**
- Dropdown menus for service categories
- Prominent phone number and booking button
- Customer reviews prominently displayed
- Professional copywriting

### To Analyze Further:
- Page speed
- Mobile responsiveness
- SEO optimization
- Additional pages (services, about, etc.)
- Blog/content marketing
- Job pins integration
- Lead capture forms


**Footer Section:**
- Contact Information:
  * Phone: (806) 441-4110 (clickable)
  * Address: 5707 Ave. Q South Drive, Lubbock, TX 79412
  * Plumber's License M-44446
- Business Hours:
  * Mon-Fri: 7:00 am - 7:00 pm
  * Saturday: 8:00 am - 12:00 pm
  * Sunday: Closed
- Payment Options shown with logos:
  * Visa, Mastercard, American Express, Discover
  * Cash, Check, QAC
- Awards/Recognition:
  * 2025 Official Choice Awards - Best of Lubbock
  * Best Plumbing Company award badge
- Social media icons (Facebook, Instagram, URL)
- "COTTON CITY BLOG" link
- Legal: Terms of Use, Privacy Policy
- Copyright notice

**Additional Content:**
- Photo gallery showing completed work (bathroom, tile, water heaters)
- Strong final CTA: "DON'T LET PLUMBING PROBLEMS DISRUPT YOUR DAY. CALL COTTON CITY PLUMBING AT (806) 441-4110 FOR FAST AND RELIABLE SERVICE."

---

## Now analyzing NEW Manus Website for comparison...


## New Manus Website - Initial Observations

**Design & Branding:**
- Same Cotton City Plumbing logo and mascot (brand consistency maintained)
- Black background with red/white text (similar color scheme to Aligned)
- Hero section: "WE MAKE SURE EVERYTHING RUNS THROUGH LUBBOCK" (same tagline)
- Awards badges displayed prominently (2025 Choice Awards, Neighborhood Fave)
- "LICENSED & INSURED M-44446" badge

**Navigation:**
- HOME
- ABOUT
- SERVICES
- GALLERY
- RECENT JOBS
- BLOG
- FINANCING
- CONTACT
- Phone: (806) 441-4110
- Email: services@cottoncityplumbing.com
- BOOK ONLINE button (prominent red)

**Homepage Content:**
- Tagline: "Lubbock's trusted, faith-based plumbing experts. From emergency repairs to new installations, we serve our neighbors with honesty, integrity, and excellence."
- "Meet Your Cotton City Team" section with detailed story about faith-based values, 30+ years experience, camera inspection technology
- Four value props with icons:
  * Faith-Based Values
  * Transparent Pricing
  * Advanced Technology
  * Respect For Your Home
- "Read Our Story" CTA button
- "Licensed, Uniformed & Professional - Ready to serve your home today"

**Comprehensive Plumbing Solutions section**

**"See Our Quality Work" Gallery:**
- Kitchen Faucet Installation (Lubbock, TX)
- Bathroom Faucet Installation (Wolfforth, TX)
- Tub/Shower Faucet Installation (Tech Terrace, Lubbock)
- "View Full Gallery" link

**"Why Lubbock Chooses Cotton City" - 7 reasons:**
1. Faith-Based Integrity
2. Upfront Pricing
3. Respect For Your Home
4. Advanced Technology
5. Locally Owned
6. Community Focused (ForEverly Changed sponsor)
7. Satisfaction Guaranteed

**Customer Reviews Section:**
- 4.9 star rating
- "Trusted by 300+ Lubbock Families"
- Three featured reviews (Sarah M., Mike T., Jennifer R.)
- "Leave Us a Google Review" CTA button

**Final CTA:**
- "Don't Let Plumbing Problems Disrupt Your Day"

---

## Key Differences Noted So Far:

### Manus Website ADVANTAGES:
1. **More detailed storytelling** - "Meet Your Cotton City Team" section
2. **Stronger value proposition** - 7 detailed reasons vs. 4 bullet points
3. **Email address displayed** - services@cottoncityplumbing.com
4. **Gallery with location details** - shows specific neighborhoods
5. **Star rating displayed** - 4.9 stars prominently shown
6. **Community involvement** - ForEverly Changed sponsorship mentioned
7. **More comprehensive content** - longer, more detailed copy

### Aligned Website ADVANTAGES:
1. **Dropdown menus** - organized service categories
2. **Payment options displayed** - shows accepted payment methods
3. **Business hours** - clearly displayed in footer
4. **Physical address** - 5707 Ave. Q South Drive shown
5. **More testimonials** - 5 reviews vs. 3
6. **Photo gallery** - actual project photos shown

### Need to analyze further:
- Page speed comparison
- Mobile responsiveness
- SEO/metadata
- Service pages depth
- Blog content
- Recent Jobs integration
- Lead capture forms


## CRITICAL FINDING: Job Pins Feature

**Aligned by Design Website:**
- JOBS page returns 404 error - "We couldn't find the page you were looking for"
- **NO job pins feature exists**
- **NO recent jobs showcase**
- **NO integration with Cotton Pins app**
- This means all the work your technicians are uploading to Cotton Pins is NOT visible to customers on the Aligned website

**New Manus Website:**
- ✅ Full "Recent Jobs" page with interactive map
- ✅ Automatically syncs with Cotton Pins app in real-time
- ✅ Shows 26+ job pins with photos, descriptions, locations
- ✅ Interactive Google Maps showing all job locations
- ✅ Automatic updates when technicians upload new pins
- ✅ Gallery page also displays job photos

**This is a MASSIVE advantage** - you're already paying technicians to take photos and upload job data to Cotton Pins, but that investment is completely wasted with the Aligned website because customers never see it.

---

## Now checking page speed and performance...
