import ServicePageLayout from "@/components/ServicePageLayout";

export default function SlabLeaks() {
  return (
    <ServicePageLayout
      title="Slab Leak Repair"
      subtitle="Expert Detection & Repair for Foundation Leaks"
      heroImage="https://images.unsplash.com/photo-1581244277943-fe4a9c777189?q=80&w=2070&auto=format&fit=crop"
      introText={`A slab leak occurs when a water pipe beneath your home's concrete foundation breaks or cracks. Because these leaks are hidden underground, they can cause significant structural damage before you even realize they exist. Shifting soil, poor installation, or aging copper pipes are common causes in the Lubbock area.

      Cotton City Plumbing specializes in the detection and repair of slab leaks. We use advanced listening equipment to locate the leak without destroying your floors, and we offer multiple repair options—from direct access repairs to re-routing pipes—to suit your budget and home layout.`}
      benefits={[
        "Advanced acoustic detection",
        "Minimally invasive options",
        "Prevents foundation damage",
        "Multiple repair strategies",
        "Insurance claim assistance",
        "Licensed & experienced crew"
      ]}
      subServices={[
        {
          title: "Electronic Leak Location",
          desc: "Pinpointing the exact location of the leak under the slab to minimize excavation."
        },
        {
          title: "Direct Access Repair",
          desc: "Opening a small section of the slab to repair the specific damaged section of pipe."
        },
        {
          title: "Pipe Re-Routing",
          desc: "Abandoning the failed underground line and running a new, durable PEX line through the walls or attic."
        },
        {
          title: "Tunneling Services",
          desc: "Excavating under the foundation from the exterior to access the leak without damaging interior floors."
        }
      ]}
      processSteps={[
        {
          title: "Detection & Isolation",
          desc: "We confirm the leak exists and use acoustic tools to mark its precise location on your floor."
        },
        {
          title: "Options Consultation",
          desc: "We explain the pros and cons of repairing the pipe vs. rerouting it, helping you make the best choice."
        },
        {
          title: "Access & Repair",
          desc: "We carefully access the pipe (through the slab or by rerouting) and perform the necessary repair."
        },
        {
          title: "Restoration",
          desc: "We backfill any excavation and patch the concrete, leaving your home ready for flooring repairs."
        }
      ]}
      faqs={[
        {
          question: "What causes slab leaks?",
          answer: "Common causes include shifting soil (which puts pressure on pipes), chemical reactions between the pipe and concrete, or simple wear and tear on older copper lines."
        },
        {
          question: "Is a reroute better than a direct repair?",
          answer: "Often, yes. Rerouting eliminates the old, failing pipe under the slab entirely, removing the risk of future leaks in that same line. It also avoids breaking through your tile or wood flooring."
        },
        {
          question: "How long does a slab leak repair take?",
          answer: "Most repairs can be completed in 1-2 days. Reroutes are often faster and cleaner than jackhammering through the foundation."
        },
        {
          question: "Will my insurance cover this?",
          answer: "Most policies cover the cost of accessing the leak (tear-out and backfill) and the resulting water damage, but usually not the plumbing repair itself. We can help you understand your coverage."
        }
      ]}
    />
  );
}
