import ServicePageLayout from "@/components/ServicePageLayout";

export default function Fixtures() {
  return (
    <ServicePageLayout
      title="Plumbing Fixtures"
      subtitle="Expert Installation & Repair for Kitchens and Bathrooms"
      heroImage="/images/hero-truck.png"
      introText={`Upgrading your plumbing fixtures is one of the most effective ways to improve the look, functionality, and water efficiency of your home. Whether you're remodeling your kitchen, updating a bathroom, or simply need to replace a leaking faucet, Cotton City Plumbing has you covered.
      
      We install and repair a wide range of high-quality fixtures from top brands. Our licensed plumbers ensure every installation is done correctly to prevent leaks and ensure long-lasting performance. From modern touchless faucets to luxurious rainfall showerheads, we help you bring your vision to life.`}
      benefits={[
        "Expert Installation & Repair",
        "Top Brands Available",
        "Water-Efficient Options",
        "Leak Prevention",
        "Kitchen & Bathroom Upgrades",
        "ADA Compliant Fixtures"
      ]}
      subServices={[
        {
          title: "Faucets & Sinks",
          desc: "Installation and repair of kitchen and bathroom faucets, including pull-down, touchless, and widespread models."
        },
        {
          title: "Toilets & Bidets",
          desc: "Repairing running toilets and installing new high-efficiency models, bidets, and washlets."
        },
        {
          title: "Showers & Bathtubs",
          desc: "Installation of showerheads, tub faucets, and complete shower systems for a spa-like experience."
        },
        {
          title: "Garbage Disposals",
          desc: "Replacement and installation of powerful, quiet garbage disposals to keep your kitchen sink running smoothly."
        }
      ]}
      processSteps={[
        {
          title: "Selection",
          desc: "We help you choose the right fixtures that match your style, budget, and existing plumbing setup."
        },
        {
          title: "Removal",
          desc: "Our team carefully removes your old fixtures, ensuring no damage to your countertops or surrounding areas."
        },
        {
          title: "Installation",
          desc: "We professionally install your new fixtures, ensuring all connections are watertight and secure."
        },
        {
          title: "Testing",
          desc: "We thoroughly test the new fixtures for proper flow, temperature control, and drainage before leaving."
        }
      ]}
      faqs={[
        {
          question: "Can I supply my own fixtures?",
          answer: "Yes, we are happy to install fixtures you have purchased yourself. However, we can also supply high-quality professional-grade fixtures that often come with better warranties."
        },
        {
          question: "Do you repair dripping faucets?",
          answer: "Absolutely. A dripping faucet can waste hundreds of gallons of water a year. We can often repair it by replacing the cartridge or washers, or recommend a replacement if it's beyond repair."
        },
        {
          question: "What brands do you install?",
          answer: "We install all major brands, including Moen, Delta, Kohler, American Standard, and more. We can recommend the best brand for your specific needs."
        },
        {
          question: "Do you install ADA compliant fixtures?",
          answer: "Yes, we install ADA compliant toilets, grab bars, and faucets to make your bathroom safer and more accessible."
        }
      ]}
    />
  );
}
