import ServicePageLayout from "@/components/ServicePageLayout";

export default function EmergencyPlumbing() {
  return (
    <ServicePageLayout
      title="Same-Day Emergency Plumbing"
      subtitle="Fast, Reliable Emergency Service When You Need It Most"
      heroImage="https://images.unsplash.com/photo-1621905251189-08b45d6a269e?q=80&w=2070&auto=format&fit=crop"
      introText={`Plumbing disasters can cause thousands of dollars in damage in minutes. A burst pipe, overflowing toilet, or major leak requires immediate attention. That's why Cotton City Plumbing offers same-day emergency service to Lubbock and the surrounding areas during our business hours (Mon-Fri 7am-7pm, Sat 8am-12pm).

      When you call during business hours, you'll get a local expert ready to dispatch a fully stocked truck to your home immediately. We prioritize emergency calls to stop the damage fast and restore your peace of mind.`}
      benefits={[
        "Same-day emergency service during business hours",
        "Rapid response times",
        "Fully stocked trucks for immediate repairs",
        "Licensed & insured professionals",
        "No hidden overtime fees",
        "Serving Lubbock & surrounding communities"
      ]}
      subServices={[
        {
          title: "Burst Pipe Repair",
          desc: "Immediate isolation and repair of frozen or burst pipes to prevent catastrophic water damage."
        },
        {
          title: "Severe Clogs & Backups",
          desc: "Clearing main line stoppages that cause sewage to back up into your home."
        },
        {
          title: "Water Heater Failure",
          desc: "Emergency repair or replacement when your water heater leaks or stops working."
        },
        {
          title: "Gas Leaks",
          desc: "Urgent detection and repair of dangerous gas leaks to keep your family safe."
        }
      ]}
      processSteps={[
        {
          title: "Immediate Dispatch",
          desc: "We take your call during business hours and dispatch the nearest available technician to your location immediately."
        },
        {
          title: "Damage Control",
          desc: "Our first priority is to stop the water or gas flow to prevent further damage to your property."
        },
        {
          title: "Diagnosis & Repair",
          desc: "We quickly identify the root cause and perform the necessary repairs to restore your plumbing system."
        },
        {
          title: "Restoration Advice",
          desc: "After the repair, we can advise you on next steps for cleanup or restoration if water damage occurred."
        }
      ]}
      faqs={[
        {
          question: "What counts as a plumbing emergency?",
          answer: "Any issue that causes immediate property damage (like a burst pipe), poses a health risk (sewage backup), or leaves you without essential services (no water/gas) is an emergency."
        },
        {
          question: "Do you charge extra for nights and weekends?",
          answer: "We believe in fair, transparent pricing. While emergency service rates may apply for after-hours calls, we will always provide a clear quote before starting any work."
        },
        {
          question: "What should I do while waiting for the plumber?",
          answer: "If possible, locate your main water shut-off valve and turn it off to stop the flow of water. If it's a gas leak, evacuate the home immediately and call from a safe distance."
        },
        {
          question: "How fast can you get here?",
          answer: "We pride ourselves on rapid response times. For emergencies in Lubbock, we typically arrive within the hour."
        }
      ]}
    />
  );
}
