import ServicePageLayout from "@/components/ServicePageLayout";

export default function DrainCleaning() {
  return (
    <ServicePageLayout
      title="Drain Cleaning Services"
      subtitle="Fast, Effective Clog Removal & Sewer Line Cleaning"
      heroImage="/images/service-drain.png"
      introText={`A clogged drain is more than just an annoyance—it can lead to backups, bad odors, and even water damage if left untreated. Cotton City Plumbing provides professional drain cleaning services to keep your plumbing flowing smoothly.
      
      Unlike chemical drain cleaners that can damage your pipes, we use safe, mechanical methods like professional cabling (snaking) and advanced cleaning techniques to completely remove blockages. From slow-draining sinks to major sewer line backups, our team has the tools and technology to solve the problem for good.`}
      benefits={[
        "Advanced camera inspections",
        "Safe for all pipe types",
        "Emergency drain service",
        "Root removal experts",
        "Preventative maintenance",
        "Clean & sanitary service"
      ]}
      subServices={[
        {
          title: "Clogged Drain Cleaning",
          desc: "Expert removal of hair, grease, soap scum, and food debris from kitchen, bathroom, and utility drains."
        },
        {
          title: "Sewer Line Cleaning",
          desc: "Clearing main sewer line blockages caused by tree roots, debris, or structural issues."
        },
        {
          title: "Emergency Drain Service",
          desc: "Same-day emergency service for urgent drain backups and blockages."
        },
        {
          title: "Camera Inspections",
          desc: "Visual inspection of your pipes to locate the exact cause and location of the problem without guessing."
        }
      ]}
      processSteps={[
        {
          title: "Video Inspection",
          desc: "We start by sending a specialized camera down the line to identify the blockage type and location."
        },
        {
          title: "Targeted Cleaning",
          desc: "Based on the inspection, we choose the best method—professional snaking for simple clogs or advanced mechanical cleaning for heavy buildup."
        },
        {
          title: "Verification",
          desc: "We run the camera again to verify the pipe is completely clear and check for any underlying structural damage."
        },
        {
          title: "Prevention Advice",
          desc: "We provide tips on how to prevent future clogs based on what we found in your specific system."
        }
      ]}
      faqs={[
        {
          question: "Why shouldn't I just use chemical drain cleaners?",
          answer: "Chemical cleaners are harsh and can corrode your pipes over time, leading to leaks. They also often push the clog further down rather than removing it completely."
        },
        {
          question: "What are the signs of a main sewer line clog?",
          answer: "Multiple drains backing up at once, water coming up in the shower when you flush the toilet, or gurgling sounds from your drains are common signs of a main line issue."
        },
        {
          question: "How long does drain cleaning typically take?",
          answer: "Most drain cleaning jobs take 1-2 hours depending on the severity and location of the clog. Simple sink or tub clogs can often be cleared in under an hour."
        },
        {
          question: "Can tree roots really get into my pipes?",
          answer: "Yes, tree roots seek out moisture and can enter pipes through tiny cracks. Once inside, they grow and catch debris, causing major blockages. We specialize in root removal."
        }
      ]}
    />
  );
}
