import ServicePageLayout from "@/components/ServicePageLayout";

export default function Commercial() {
  return (
    <ServicePageLayout
      title="Commercial Plumbing Services"
      subtitle="Reliable Plumbing Solutions for Lubbock Businesses"
      heroImage="https://images.unsplash.com/photo-1584622650111-993a426fbf0a?q=80&w=2070&auto=format&fit=crop"
      introText={`Plumbing issues can bring your business to a halt, costing you revenue and frustrating customers. Whether it's a restaurant grease trap, a hotel water heater, or an office building restroom, you need a partner who understands the urgency of commercial plumbing. Cotton City Plumbing provides fast, professional service to keep your business running smoothly.

      We work with property managers, business owners, and contractors across Lubbock to deliver reliable maintenance, emergency repairs, and new construction plumbing. Our team is experienced with the unique codes and demands of commercial systems.`}
      benefits={[
        "Priority commercial scheduling",
        "Licensed for commercial work",
        "Preventative maintenance plans",
        "Backflow testing & certification",
        "Grease trap services",
        "New construction & build-outs"
      ]}
      subServices={[
        {
          title: "Commercial Water Heaters",
          desc: "Installation and repair of high-capacity water heating systems for hotels, gyms, and restaurants."
        },
        {
          title: "Drain & Sewer Services",
          desc: "Hydro-jetting and augering to keep high-traffic commercial drains flowing freely."
        },
        {
          title: "Restroom Maintenance",
          desc: "Repair and replacement of commercial toilets, urinals, and sensor faucets."
        },
        {
          title: "Backflow Prevention",
          desc: "Annual testing, repair, and installation of backflow preventers to protect the city water supply."
        }
      ]}
      processSteps={[
        {
          title: "Consultation",
          desc: "We discuss your business's specific needs and plumbing challenges to tailor our service."
        },
        {
          title: "Scheduled Maintenance",
          desc: "We can set up a recurring schedule for tasks like drain cleaning to prevent emergencies."
        },
        {
          title: "Rapid Response",
          desc: "When an emergency strikes, we prioritize your business to minimize downtime."
        },
        {
          title: "Documentation",
          desc: "We provide detailed invoices and reports for your records and compliance requirements."
        }
      ]}
      faqs={[
        {
          question: "Do you offer after-hours service for businesses?",
          answer: "Yes. We understand that some work needs to be done outside of operating hours to avoid disrupting your customers. We can schedule repairs for evenings or weekends."
        },
        {
          question: "Can you handle grease trap issues?",
          answer: "Absolutely. We install and repair grease traps and can help ensure your kitchen lines remain clear of grease buildup."
        },
        {
          question: "Do you work with property management companies?",
          answer: "Yes, we partner with many local property managers to handle tenant plumbing requests efficiently and professionally."
        },
        {
          question: "Are you insured for commercial work?",
          answer: "Yes, we carry full liability insurance and workers' compensation coverage to protect your business and our team during every project."
        }
      ]}
    />
  );
}
