import ServicePageLayout from "@/components/ServicePageLayout";

export default function Appliances() {
  return (
    <ServicePageLayout
      title="Appliance Installation"
      subtitle="Professional Hookups for Dishwashers, Washing Machines & More"
      heroImage="/images/hero-truck.png"
      introText={`Buying a new appliance is exciting, but installing it correctly is crucial for its performance and longevity. Improper installation can lead to water leaks, electrical issues, and voided warranties. Cotton City Plumbing offers professional appliance installation services in Lubbock to ensure your new investment is set up safely and correctly.
      
      We handle the water and gas connections for a variety of household appliances. Our technicians ensure that all lines are secure, leak-free, and code-compliant, giving you peace of mind and protecting your home from potential water damage.`}
      benefits={[
        "Professional Installation",
        "Leak-Free Guarantee",
        "Code Compliance",
        "Gas & Water Connections",
        "Old Appliance Disconnection",
        "Same-Day Service Available"
      ]}
      subServices={[
        {
          title: "Dishwashers",
          desc: "Secure water supply and drain connections for all dishwasher brands."
        },
        {
          title: "Washing Machines",
          desc: "Installation of hot and cold water hoses and drain lines for washers."
        },
        {
          title: "Ice Makers",
          desc: "Running water lines to refrigerators for ice makers and water dispensers."
        },
        {
          title: "Gas Dryers & Ranges",
          desc: "Safe gas line connections for dryers, ovens, and cooktops."
        }
      ]}
      processSteps={[
        {
          title: "Assessment",
          desc: "We check your existing connections to ensure they are compatible with your new appliance."
        },
        {
          title: "Preparation",
          desc: "We safely disconnect and move your old unit if needed (disposal services may vary)."
        },
        {
          title: "Connection",
          desc: "We connect water, drain, and gas lines using high-quality materials."
        },
        {
          title: "Testing",
          desc: "We run the appliance through a cycle to verify proper operation and check for leaks."
        }
      ]}
      faqs={[
        {
          question: "Do you install gas appliances?",
          answer: "Yes, we are licensed to install gas lines and connect gas appliances like dryers, ranges, and cooktops."
        },
        {
          question: "Can you install a water line for my new fridge?",
          answer: "Yes, if your refrigerator location doesn't have an existing water line, we can run a new line to supply your ice maker and water dispenser."
        },
        {
          question: "Do you haul away old appliances?",
          answer: "We can disconnect your old appliance. Please check with us at the time of booking regarding disposal services, as this may vary."
        },
        {
          question: "Why should I hire a plumber for appliance installation?",
          answer: "Plumbers ensure that water and gas connections are secure and meet local codes. This prevents leaks, water damage, and dangerous gas leaks that can occur with improper DIY installation."
        }
      ]}
    />
  );
}
