import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Link } from "wouter";
import { ArrowLeft, Phone, Calendar } from "lucide-react";
import SocialShareButtons from "@/components/SocialShareButtons";

export default function TankVsTanklessBlog() {
  return (
    <Layout>
      <SEO
        title="Tank vs. Tankless Water Heaters: Complete Guide for Lubbock Homeowners | Cotton City Plumbing"
        description="Comparing tank and tankless water heaters for Lubbock homes. Learn about costs ($1,600 vs $4,900), hard water considerations, energy efficiency, and which system is right for your family."
        canonical="/blog/tank-vs-tankless-water-heaters"
      />

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white py-16">
        <div className="container">
          <Link href="/blog">
            <Button variant="ghost" className="text-white hover:bg-white/10 mb-6">
              <ArrowLeft className="mr-2 h-4 w-4" />
              Back to Blog
            </Button>
          </Link>
          
          <div className="max-w-4xl">
            <div className="flex items-center gap-4 text-sm mb-4 text-white/80">
              <span className="flex items-center gap-2">
                <Calendar className="h-4 w-4" />
                December 2025
              </span>
              <span>•</span>
              <span>15 min read</span>
            </div>
            
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              Tank vs. Tankless Water Heaters: The Complete Guide for Lubbock Homeowners
            </h1>
            
            <p className="text-xl text-white/90 leading-relaxed">
              Choosing the right water heater for your Lubbock home? This comprehensive guide breaks down costs, performance, and Lubbock-specific considerations to help you make an informed decision.
            </p>
          </div>
        </div>
      </section>

      {/* Article Content */}
      <article className="py-16 bg-white">
        <div className="container max-w-4xl">
          
          {/* Introduction */}
          <div className="prose prose-lg max-w-none mb-12">
            <p className="text-xl leading-relaxed text-gray-700">
              Choosing the right water heater is one of the most important decisions you'll make for your Lubbock home. With West Texas's unique challenges—hard water, temperature extremes, and rising energy costs—the choice between a traditional tank water heater and a modern tankless system can significantly impact your comfort, utility bills, and long-term maintenance costs.
            </p>
            <p className="text-lg leading-relaxed text-gray-700">
              At Cotton City Plumbing, we've installed hundreds of water heaters across Lubbock and the South Plains. We've seen firsthand what works in our climate and what doesn't. This comprehensive guide will help you make an informed decision based on your specific needs, budget, and home conditions.
            </p>
          </div>

          {/* Cost Comparison Card */}
          <Card className="mb-12 border-2 border-primary/20 bg-white">
            <CardContent className="p-8">
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Cost Comparison at a Glance</h2>
              <div className="grid md:grid-cols-2 gap-6">
                <div className="bg-white p-6 rounded-lg border-2 border-gray-200">
                  <h3 className="font-bold text-xl mb-3">Standard Tank</h3>
                  <div className="text-4xl font-bold text-primary mb-4">$1,600</div>
                  <ul className="space-y-2 text-gray-700">
                    <li>✓ Professional Rheem tank</li>
                    <li>✓ Full installation</li>
                    <li>✓ Code compliance</li>
                    <li>✓ Old unit removal</li>
                    <li>✓ 8-12 year lifespan</li>
                  </ul>
                </div>
                <div className="bg-white p-6 rounded-lg border-2 border-primary">
                  <h3 className="font-bold text-xl mb-3">Tankless</h3>
                  <div className="text-4xl font-bold text-primary mb-4">$4,900</div>
                  <ul className="space-y-2 text-gray-700">
                    <li>✓ Premium Navien tankless</li>
                    <li>✓ PeakFlow S inline filter</li>
                    <li>✓ Venting upgrades</li>
                    <li>✓ Old unit removal</li>
                    <li>✓ 15-20+ year lifespan</li>
                  </ul>
                </div>
              </div>
            </CardContent>
          </Card>

          {/* Main Content Sections */}
          <div className="space-y-12">
            
            {/* Understanding the Basics */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Understanding the Basics</h2>
              
              <h3 className="font-bold text-2xl mb-4 mt-8">Traditional Tank Water Heaters</h3>
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                Traditional tank water heaters store and continuously heat 40-80 gallons of water in an insulated tank. When you turn on a hot water tap, heated water flows from the top of the tank while cold water enters the bottom to be heated. These systems have been the standard in American homes for decades and remain the most common choice in Lubbock.
              </p>
              <p className="text-lg leading-relaxed mb-6 text-gray-700">
                <strong>How They Work:</strong> A gas burner or electric heating element maintains water temperature at your set point (typically 120-140°F), cycling on and off throughout the day to keep the stored water hot and ready for use.
              </p>

              <h3 className="font-bold text-2xl mb-4 mt-8">Tankless Water Heaters</h3>
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                Tankless water heaters, also called on-demand or instantaneous water heaters, heat water only when you need it. Cold water travels through a pipe into the unit, where either a gas burner or electric element heats it instantly as it passes through a heat exchanger.
              </p>
              <p className="text-lg leading-relaxed text-gray-700">
                <strong>How They Work:</strong> When you open a hot water tap, cold water flows into the unit, triggering powerful burners or heating elements that rapidly heat the water to your desired temperature before it reaches your faucet. When you close the tap, the system shuts off completely.
              </p>
            </section>

            {/* Lubbock Hard Water Section */}
            <section className="bg-yellow-50 p-8 rounded-xl border-2 border-yellow-200 text-primary">
              <h2 className="font-heading font-bold text-3xl mb-6 text-gray-900">Lubbock's Hard Water: What You Need to Know</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                Lubbock's water supply is notoriously hard, with mineral content ranging from 180-300 parts per million (classified as "hard" to "very hard"). This creates unique challenges for tankless water heaters.
              </p>

              <h3 className="font-bold text-2xl mb-4 mt-6 text-gray-900">Included Protection: PeakFlow S Inline Filter</h3>
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                At Cotton City Plumbing, we've learned from years of experience that tankless systems in Lubbock's hard water environment need proper protection. That's why <strong>every tankless installation includes a PeakFlow S inline filter at no additional cost</strong>. This specialized filter is designed specifically for tankless water heaters and provides essential protection against scale buildup.
              </p>

              <div className="bg-white p-6 rounded-lg mb-4">
                <h4 className="font-bold text-xl mb-3 text-gray-900">The PeakFlow S Filter:</h4>
                <ul className="space-y-2 text-gray-700">
                  <li>✓ Protects your tankless heat exchanger from mineral buildup</li>
                  <li>✓ Extends system lifespan in hard water environments</li>
                  <li>✓ Reduces maintenance frequency</li>
                  <li>✓ Included in your $4,900 installation price</li>
                  <li>✓ Filter cartridge replacement every 6-12 months ($40-60)</li>
                </ul>
              </div>

              <p className="text-lg leading-relaxed text-gray-700">
                <strong>Optional: Whole-Home Water Softener</strong><br />
                If your home already has a whole-home water softener system, we'll bypass the inline filter since your water is already conditioned. Many Lubbock homeowners choose to add whole-home softening for benefits throughout the house—softer skin and hair, longer-lasting appliances, reduced soap usage—but it's not required to protect your tankless system. The included PeakFlow S filter handles that.
              </p>
            </section>

            {/* Performance Comparison */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Performance Comparison</h2>
              
              <div className="overflow-x-auto bg-white p-6 rounded-lg">
                <table className="w-full border-collapse">
                  <thead>
                    <tr className="bg-primary text-white">
                      <th className="border border-primary p-4 text-left font-bold">Factor</th>
                      <th className="border border-primary p-4 text-left font-bold">Tank Water Heater</th>
                      <th className="border border-primary p-4 text-left font-bold">Tankless Water Heater</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr className="bg-white">
                      <td className="border border-gray-300 p-4 font-semibold text-gray-900">Hot Water Capacity</td>
                      <td className="border border-gray-300 p-4 text-gray-700">40-80 gallons stored; "cold shower" after depletion</td>
                      <td className="border border-gray-300 p-4 text-gray-700">Endless hot water (within flow rate limits)</td>
                    </tr>
                    <tr className="bg-gray-50">
                      <td className="border border-gray-300 p-4 font-semibold text-gray-900">Recovery Time</td>
                      <td className="border border-gray-300 p-4 text-gray-700">30-90 minutes to reheat full tank</td>
                      <td className="border border-gray-300 p-4 text-gray-700">No recovery time needed</td>
                    </tr>
                    <tr className="bg-white">
                      <td className="border border-gray-300 p-4 font-semibold text-gray-900">Space Requirements</td>
                      <td className="border border-gray-300 p-4 text-gray-700">16-24 sq ft floor space</td>
                      <td className="border border-gray-300 p-4 text-gray-700">Wall-mounted, suitcase-sized</td>
                    </tr>
                    <tr className="bg-gray-50">
                      <td className="border border-gray-300 p-4 font-semibold text-gray-900">Energy Efficiency</td>
                      <td className="border border-gray-300 p-4 text-gray-700">0.60-0.70 UEF</td>
                      <td className="border border-gray-300 p-4 text-gray-700">0.82-0.96 UEF (24-34% more efficient)</td>
                    </tr>
                    <tr className="bg-white">
                      <td className="border border-gray-300 p-4 font-semibold text-gray-900">Lifespan</td>
                      <td className="border border-gray-300 p-4 text-gray-700">8-12 years</td>
                      <td className="border border-gray-300 p-4 text-gray-700">15-20+ years</td>
                    </tr>
                    <tr className="bg-gray-50">
                      <td className="border border-gray-300 p-4 font-semibold text-gray-900">Annual Maintenance</td>
                      <td className="border border-gray-300 p-4 text-gray-700">$255 (flushing, anode rod check)</td>
                      <td className="border border-gray-300 p-4 text-gray-700">$285 (descaling, filter replacement)</td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </section>

            {/* Which System is Right for You */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Which System is Right for Your Lubbock Home?</h2>
              
              <div className="grid md:grid-cols-2 gap-6">
                <Card className="bg-white">
                  <CardContent className="p-6">
                    <h3 className="font-bold text-2xl mb-4 text-primary">Choose a Tank If:</h3>
                    <ul className="space-y-3 text-gray-700">
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>Budget is your primary concern ($1,600 vs $4,900)</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>You want minimal maintenance complexity</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>You need reliability during power outages</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>Your hot water usage is moderate</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>You're planning to sell soon</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>

                <Card className="border-2 border-primary bg-white">
                  <CardContent className="p-6">
                    <h3 className="font-bold text-2xl mb-4 text-primary">Choose Tankless If:</h3>
                    <ul className="space-y-3 text-gray-700">
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>You're okay with filter maintenance (every 6-12 months)</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>You have high hot water demand (large family)</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>Space is limited in your home</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>You're staying long-term (10+ years)</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>Energy efficiency matters to you</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="text-green-600 font-bold mt-1">✓</span>
                        <span>You never want to run out of hot water</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>
              </div>

              <Card className="mt-8 bg-yellow-50 border-2 border-primary">
                <CardContent className="p-8">
                  <h3 className="font-heading font-bold text-2xl mb-4 text-gray-900">The Lubbock Reality Check</h3>
                  <p className="text-lg leading-relaxed text-primary">
                    After installing hundreds of water heaters across Lubbock, here's our honest professional assessment: <strong>For most Lubbock homeowners, a quality tank water heater is the better choice.</strong> The combination of lower upfront cost, simpler maintenance, and proven reliability in our hard water environment makes tanks the practical option for most families.
                  </p>
                  <p className="text-lg leading-relaxed text-primary mt-4">
                    However, if you have high hot water demand, value endless hot water, plan to stay in your home for 10+ years, and don't mind the filter maintenance, tankless becomes much more attractive—especially with the included PeakFlow S filter providing essential protection.
                  </p>
                </CardContent>
              </Card>
            </section>

          </div>

          {/* Social Share Buttons */}
          <div className="mt-16 p-8 bg-gray-50 rounded-xl">
            <SocialShareButtons
              url="/blog/tank-vs-tankless-water-heaters"
              title="Tank vs. Tankless Water Heaters: The Complete Guide for Lubbock Homeowners"
              description="Choosing the right water heater for your Lubbock home? This comprehensive guide breaks down costs, performance, and which system is right for your family."
            />
          </div>

          {/* CTA Section */}
          <Card className="mt-12 bg-gradient-to-br from-primary to-primary/90 text-white border-none">
            <CardContent className="p-8 md:p-12 text-center">
              <h2 className="font-heading font-bold text-3xl md:text-4xl mb-4">
                Ready to Replace Your Water Heater?
              </h2>
              <p className="text-xl mb-8 text-white/90 max-w-2xl mx-auto">
                Get a free in-home estimate from Lubbock's trusted plumbing experts. We'll assess your needs, water quality, and usage patterns to recommend the perfect system for your home.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button
                  size="lg"
                  variant="secondary"
                  className="font-bold text-lg"
                  onClick={() => window.location.href = 'tel:8064414110'}
                >
                  <Phone className="mr-2 h-5 w-5" />
                  Call (806) 441-4110
                </Button>
                <Link href="/contact">
                  <Button
                    size="lg"
                    variant="outline"
                    className="font-bold text-lg bg-white text-primary hover:bg-white/90 border-white w-full sm:w-auto"
                  >
                    Book Online
                  </Button>
                </Link>
              </div>
              <p className="text-sm mt-6 text-white/80">
                Licensed & Insured M-44446 | Serving Lubbock & the South Plains
              </p>
            </CardContent>
          </Card>

        </div>
      </article>
    </Layout>
  );
}
