import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Link } from "wouter";
import { ArrowLeft, Phone, Calendar } from "lucide-react";
import SocialShareButtons from "@/components/SocialShareButtons";

export default function PreventCloggedDrainsBlog() {
  return (
    <Layout>
      <SEO
        title="Simple Tips to Prevent Clogged Drains in Your Kitchen and Bathroom | Cotton City Plumbing"
        description="Clogged drains are a major inconvenience. Learn simple, proactive steps you can take to keep your pipes flowing freely and avoid costly plumbing visits."
        canonical="/blog/prevent-clogged-drains"
      />

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white py-16">
        <div className="container">
          <Link href="/blog">
            <Button variant="ghost" className="text-white hover:bg-white/10 mb-6">
              <ArrowLeft className="mr-2 h-4 w-4" />
              Back to Blog
            </Button>
          </Link>
          
          <div className="max-w-4xl">
            <div className="flex items-center gap-4 text-sm mb-4 text-white/80">
              <span className="flex items-center gap-2">
                <Calendar className="h-4 w-4" />
                February 2025
              </span>
              <span>•</span>
              <span>7 min read</span>
            </div>
            
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              Simple Tips to Prevent Clogged Drains in Your Kitchen and Bathroom
            </h1>
            
            <p className="text-xl text-white/90 leading-relaxed">
              Clogged drains are a major inconvenience. Learn simple, proactive steps you can take to keep your pipes flowing freely and avoid costly plumbing visits.
            </p>
          </div>
        </div>
      </section>

      {/* Article Content */}
      <article className="py-16 bg-white">
        <div className="container max-w-4xl">
          
          {/* Introduction */}
          <div className="prose prose-lg max-w-none mb-12">
            <p className="text-xl leading-relaxed text-gray-700">
              A clogged drain can disrupt your entire day, leading to slow drainage, foul odors, and even sewage backups. While some clogs are inevitable, many can be prevented with a few simple changes to your daily habits.
            </p>
          </div>

          {/* Main Content Sections */}
          <div className="space-y-12">
            
            {/* Kitchen */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">In the Kitchen</h2>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <h3 className="font-bold text-2xl mb-3 text-gray-900">Grease is the Enemy</h3>
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    Never pour cooking oil, bacon grease, or fat down the drain. As it cools, it solidifies and traps other debris, creating stubborn blockages. Instead, pour grease into a container and throw it in the trash.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700">
                    <strong>Pro tip:</strong> Keep an empty coffee can or jar under the sink specifically for grease disposal. Once full, seal it and toss it in the garbage.
                  </p>
                </CardContent>
              </Card>

              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <h3 className="font-bold text-2xl mb-3 text-gray-900">Watch What Your Garbage Disposal Eats</h3>
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    Avoid putting fibrous foods (celery, corn husks), starchy foods (pasta, rice, potato peels), or coffee grounds down the disposal. These can tangle blades or expand in pipes to cause clogs.
                  </p>
                  <ul className="space-y-2 text-lg text-gray-700 ml-6">
                    <li>• Run cold water before, during, and after using the disposal</li>
                    <li>• Cut large items into smaller pieces before disposal</li>
                    <li>• Never put eggshells, bones, or fruit pits down the disposal</li>
                  </ul>
                </CardContent>
              </Card>
            </section>

            {/* Bathroom */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">In the Bathroom</h2>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <h3 className="font-bold text-2xl mb-3 text-gray-900">Catch the Hair</h3>
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    Hair is the #1 cause of bathroom drain clogs. Install a simple hair catcher or mesh screen over your shower and tub drains, and clean it out regularly.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700">
                    <strong>Cost-effective solution:</strong> Hair catchers cost $3-10 at any hardware store and can save you hundreds in drain cleaning costs.
                  </p>
                </CardContent>
              </Card>

              <Card className="mb-6 bg-white border-2 border-red-200">
                <CardContent className="p-6">
                  <h3 className="font-bold text-2xl mb-3 text-red-900">Flush Only Toilet Paper</h3>
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    "Flushable" wipes are a marketing myth. They do not break down like toilet paper and are a leading cause of major sewer line blockages. Stick to the 3 Ps: Pee, Poo, and (Toilet) Paper.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700 font-semibold">
                    Never flush: Cotton swabs, dental floss, feminine hygiene products, paper towels, or any type of wipes—even those labeled "flushable."
                  </p>
                </CardContent>
              </Card>
            </section>

            {/* Routine Maintenance */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Routine Maintenance</h2>
              
              <Card className="mb-6 bg-blue-50 border-blue-200">
                <CardContent className="p-6">
                  <h3 className="font-bold text-2xl mb-3 text-gray-900">Monthly Drain Cleaning</h3>
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    Once a month, pour a kettle of boiling water down your drains to melt away soap scum and minor grease buildup. You can also use a mixture of baking soda and vinegar followed by hot water for a natural, fizzy cleaner that helps keep pipes fresh.
                  </p>
                  <div className="bg-white p-4 rounded-lg mt-4">
                    <p className="font-bold text-lg mb-2 text-primary">Natural Drain Cleaner Recipe:</p>
                    <ol className="space-y-2 text-gray-700 list-decimal list-inside">
                      <li>Pour 1/2 cup baking soda down the drain</li>
                      <li>Follow with 1/2 cup white vinegar</li>
                      <li>Cover the drain and let it fizz for 15 minutes</li>
                      <li>Flush with a kettle of boiling water</li>
                    </ol>
                  </div>
                </CardContent>
              </Card>

              <Card className="mb-6 bg-yellow-50 border-yellow-200">
                <CardContent className="p-6">
                  <h3 className="font-bold text-2xl mb-3 text-gray-900">Avoid Chemical Drain Cleaners</h3>
                  <p className="text-lg leading-relaxed text-primary">
                    If you've tried these tips and still have a slow drain, don't reach for harsh chemical drain cleaners—they can damage your pipes and are harmful to the environment. Call the pros at Cotton City Plumbing for safe, effective drain cleaning services.
                  </p>
                </CardContent>
              </Card>
            </section>

          </div>

          {/* Social Share */}
          <div className="mt-16 pt-8 border-t">
            <SocialShareButtons 
              url={`${window.location.origin}/blog/prevent-clogged-drains`}
              title="Simple Tips to Prevent Clogged Drains in Your Kitchen and Bathroom"
            />
          </div>

          {/* CTA Section */}
          <Card className="mt-12 bg-gradient-to-br from-primary to-primary/90 text-white border-none">
            <CardContent className="p-8 md:p-12 text-center">
              <h2 className="font-heading font-bold text-3xl md:text-4xl mb-4">
                Need Professional Drain Cleaning?
              </h2>
              <p className="text-xl mb-8 text-white/90">
                If you've tried these tips and still have a slow drain, call Cotton City Plumbing for safe, effective drain cleaning services.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button size="lg" variant="secondary" className="text-lg">
                  <Phone className="mr-2 h-5 w-5" />
                  Call (806) 441-4110
                </Button>
                <Button size="lg" variant="outline" className="text-lg bg-white text-primary hover:bg-white/90">
                  Book Online
                </Button>
              </div>
            </CardContent>
          </Card>

        </div>
      </article>
    </Layout>
  );
}
