import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Link } from "wouter";
import { ArrowLeft, Phone, Calendar, Droplets } from "lucide-react";
import SocialShareButtons from "@/components/SocialShareButtons";

export default function HardWaterSolutionsBlog() {
  return (
    <Layout>
      <SEO
        title="Dealing with Hard Water in Lubbock: Why You Need a Water Softener | Cotton City Plumbing"
        description="Lubbock is known for its hard water, which can damage your pipes, appliances, and skin. Discover how a water softener can protect your home and improve your quality of life."
        canonical="/blog/hard-water-solutions-lubbock"
      />

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white py-16">
        <div className="container">
          <Link href="/blog">
            <Button variant="ghost" className="text-white hover:bg-white/10 mb-6">
              <ArrowLeft className="mr-2 h-4 w-4" />
              Back to Blog
            </Button>
          </Link>
          
          <div className="max-w-4xl">
            <div className="flex items-center gap-4 text-sm mb-4 text-white/80">
              <span className="flex items-center gap-2">
                <Calendar className="h-4 w-4" />
                February 2025
              </span>
              <span>•</span>
              <span>10 min read</span>
            </div>
            
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              Dealing with Hard Water in Lubbock: Why You Need a Water Softener
            </h1>
            
            <p className="text-xl text-white/90 leading-relaxed">
              Lubbock is known for its hard water, which can damage your pipes, appliances, and skin. Discover how a water softener can protect your home and improve your quality of life.
            </p>
          </div>
        </div>
      </section>

      {/* Article Content */}
      <article className="py-16 bg-white">
        <div className="container max-w-4xl">
          
          {/* Introduction */}
          <div className="prose prose-lg max-w-none mb-12">
            <p className="text-xl leading-relaxed text-gray-700">
              If you live in Lubbock, you're likely familiar with the effects of hard water. From crusty white buildup on your faucets to dry, itchy skin after a shower, hard water is a common nuisance in West Texas. But did you know it can also cause serious damage to your home's plumbing?
            </p>
          </div>

          {/* Main Content Sections */}
          <div className="space-y-12">
            
            {/* What is Hard Water */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">What is Hard Water?</h2>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <Droplets className="h-8 w-8 text-blue-600 flex-shrink-0 mt-1" />
                    <div>
                      <p className="text-lg leading-relaxed text-gray-700">
                        Hard water contains high levels of dissolved minerals, primarily calcium and magnesium. While not harmful to drink, these minerals wreak havoc on your plumbing system over time.
                      </p>
                      <p className="text-lg leading-relaxed text-gray-700 mt-4">
                        <strong>Lubbock's water hardness:</strong> Ranges from 180-300 parts per million (classified as "hard" to "very hard"), making it some of the hardest water in Texas.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </section>

            {/* Hidden Costs */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">The Hidden Costs of Hard Water</h2>
              
              <div className="space-y-6">
                <Card className="bg-white">
                  <CardContent className="p-6">
                    <h3 className="font-bold text-2xl mb-3 text-gray-900">Scale Buildup</h3>
                    <p className="text-lg leading-relaxed text-gray-700">
                      Minerals accumulate inside your pipes, reducing water flow and increasing pressure, which can lead to leaks. Over time, this buildup can completely clog pipes, requiring costly replacement.
                    </p>
                  </CardContent>
                </Card>

                <Card className="bg-white">
                  <CardContent className="p-6">
                    <h3 className="font-bold text-2xl mb-3 text-gray-900">Appliance Damage</h3>
                    <p className="text-lg leading-relaxed text-gray-700">
                      Water heaters, dishwashers, and washing machines have to work harder to heat and process hard water, shortening their lifespan and increasing energy bills. A water heater with heavy scale buildup can use 25-30% more energy.
                    </p>
                  </CardContent>
                </Card>

                <Card className="bg-white">
                  <CardContent className="p-6">
                    <h3 className="font-bold text-2xl mb-3 text-gray-900">Faded Laundry</h3>
                    <p className="text-lg leading-relaxed text-gray-700">
                      Hard water traps detergent in fabric fibers, leaving clothes stiff, dingy, and wearing out faster. You'll also use more detergent trying to get clothes clean.
                    </p>
                  </CardContent>
                </Card>
              </div>
            </section>

            {/* The Solution */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">The Solution: Whole-Home Water Softeners</h2>
              
              <Card className="mb-6 bg-blue-50 border-blue-200">
                <CardContent className="p-6">
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    A water softener removes the calcium and magnesium ions from your water supply, replacing them with sodium ions. The result is "soft" water that is gentle on your pipes, appliances, and body.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700">
                    <strong>How it works:</strong> Water flows through a tank filled with resin beads that attract and trap hard minerals. The system periodically regenerates by flushing the beads with a salt solution, washing away the accumulated minerals.
                  </p>
                </CardContent>
              </Card>
            </section>

            {/* Benefits */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Benefits of Installing a Water Softener</h2>
              
              <Card className="bg-white">
                <CardContent className="p-6">
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    With a high-quality water softener installed by Cotton City Plumbing, you'll enjoy:
                  </p>
                  <ul className="space-y-3 text-lg text-gray-700">
                    <li className="flex items-start gap-3">
                      <span className="text-primary font-bold mt-1">✓</span>
                      <span>Cleaner, spot-free dishes and glassware</span>
                    </li>
                    <li className="flex items-start gap-3">
                      <span className="text-primary font-bold mt-1">✓</span>
                      <span>Softer, healthier skin and hair</span>
                    </li>
                    <li className="flex items-start gap-3">
                      <span className="text-primary font-bold mt-1">✓</span>
                      <span>Brighter, softer laundry that lasts longer</span>
                    </li>
                    <li className="flex items-start gap-3">
                      <span className="text-primary font-bold mt-1">✓</span>
                      <span>Longer-lasting appliances and plumbing fixtures</span>
                    </li>
                    <li className="flex items-start gap-3">
                      <span className="text-primary font-bold mt-1">✓</span>
                      <span>Lower energy bills due to improved water heater efficiency</span>
                    </li>
                    <li className="flex items-start gap-3">
                      <span className="text-primary font-bold mt-1">✓</span>
                      <span>Reduced soap and detergent usage (up to 50% less)</span>
                    </li>
                  </ul>
                </CardContent>
              </Card>
            </section>

          </div>

          {/* Social Share */}
          <div className="mt-16 pt-8 border-t">
            <SocialShareButtons 
              url={`${window.location.origin}/blog/hard-water-solutions-lubbock`}
              title="Dealing with Hard Water in Lubbock: Why You Need a Water Softener"
            />
          </div>

          {/* CTA Section */}
          <Card className="mt-12 bg-gradient-to-br from-primary to-primary/90 text-white border-none">
            <CardContent className="p-8 md:p-12 text-center">
              <h2 className="font-heading font-bold text-3xl md:text-4xl mb-4">
                Ready to Banish Hard Water from Your Home?
              </h2>
              <p className="text-xl mb-8 text-white/90">
                Contact us today to discuss our water treatment options tailored for Lubbock's water quality.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button size="lg" variant="secondary" className="text-lg">
                  <Phone className="mr-2 h-5 w-5" />
                  Call (806) 441-4110
                </Button>
                <Button size="lg" variant="outline" className="text-lg bg-white text-primary hover:bg-white/90">
                  Book Online
                </Button>
              </div>
            </CardContent>
          </Card>

        </div>
      </article>
    </Layout>
  );
}
