import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Link } from "wouter";
import { ArrowLeft, Phone, Calendar, Snowflake } from "lucide-react";
import SocialShareButtons from "@/components/SocialShareButtons";

export default function FrozenPipesPreventionBlog() {
  return (
    <Layout>
      <SEO
        title="How to Prevent Frozen Pipes in West Texas Winters | Cotton City Plumbing"
        description="Protect your Lubbock home from costly frozen pipe damage. Learn proven prevention strategies for West Texas winters, what to do if pipes freeze, and when to call for help."
        canonical="/blog/frozen-pipes-prevention"
      />

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white py-16">
        <div className="container">
          <Link href="/blog">
            <Button variant="ghost" className="text-white hover:bg-white/10 mb-6">
              <ArrowLeft className="mr-2 h-4 w-4" />
              Back to Blog
            </Button>
          </Link>
          
          <div className="max-w-4xl">
            <div className="flex items-center gap-4 text-sm mb-4 text-white/80">
              <span className="flex items-center gap-2">
                <Calendar className="h-4 w-4" />
                December 2025
              </span>
              <span>•</span>
              <span>12 min read</span>
            </div>
            
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              How to Prevent Frozen Pipes in West Texas Winters
            </h1>
            
            <p className="text-xl text-white/90 leading-relaxed">
              When temperatures drop below freezing in Lubbock, your pipes are at risk. Learn the proven strategies to protect your home from costly frozen pipe damage and what to do if disaster strikes.
            </p>
          </div>
        </div>
      </section>

      {/* Article Content */}
      <article className="py-16 bg-white">
        <div className="container max-w-4xl">
          
          {/* Introduction */}
          <div className="prose prose-lg max-w-none mb-12">
            <p className="text-xl leading-relaxed text-gray-700">
              "It doesn't get that cold in Lubbock." That's what many new residents think—until the first hard freeze hits and their pipes burst at 3 AM, flooding their home with hundreds of gallons of water. The truth is, while Lubbock doesn't experience prolonged deep freezes like northern states, our sudden temperature drops and poorly insulated homes create perfect conditions for frozen pipe disasters.
            </p>
            <p className="text-lg leading-relaxed text-gray-700">
              At Cotton City Plumbing, we respond to dozens of frozen pipe emergencies every winter. The damage is often catastrophic: ruined floors, destroyed drywall, soaked furniture, and repair bills ranging from $5,000 to $50,000 or more. The heartbreaking part? Nearly all of it is preventable with simple, inexpensive precautions. This comprehensive guide will show you exactly how to protect your Lubbock home from frozen pipe damage.
            </p>
          </div>

          {/* Quick Stats Card */}
          <Card className="mb-12 border-2 border-blue-200 bg-blue-50">
            <CardContent className="p-8">
              <div className="flex items-start gap-4">
                <Snowflake className="h-8 w-8 text-blue-600 flex-shrink-0 mt-1" />
                <div>
                  <h3 className="font-heading font-bold text-2xl mb-3 text-blue-900">The Cost of Frozen Pipes</h3>
                  <div className="grid md:grid-cols-2 gap-4 text-gray-800">
                    <div>
                      <p className="font-bold text-3xl text-blue-600">$5,000+</p>
                      <p className="text-sm">Average insurance claim for burst pipe damage</p>
                    </div>
                    <div>
                      <p className="font-bold text-3xl text-blue-600">250 gallons/hour</p>
                      <p className="text-sm">Water discharge from a 1/8" crack in a pipe</p>
                    </div>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>

          {/* Main Content Sections */}
          <div className="space-y-12">
            
            {/* Understanding the Risk */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Why Lubbock Homes Are Vulnerable</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                Lubbock's climate creates a unique perfect storm for frozen pipe damage. Unlike northern states where homes are built with deep frost lines and heavy insulation, West Texas homes are designed for our scorching summers, not our occasional hard freezes. This leaves us especially vulnerable when temperatures drop.
              </p>

              <h3 className="font-bold text-2xl mb-4 mt-8">The Lubbock Freeze Pattern</h3>
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                Lubbock typically sees 10-20 nights per winter where temperatures drop below 32°F, with 3-5 nights dropping below 20°F. The danger zone is when temperatures stay below freezing for 6+ consecutive hours—usually overnight. Our coldest months are December through February, with January being the highest risk period.
              </p>

              <h3 className="font-bold text-2xl mb-4 mt-8">High-Risk Areas in Your Home</h3>
              <ul className="space-y-3 text-lg text-gray-700">
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Attics:</strong> Pipes running through unheated attics are extremely vulnerable, especially if insulation is inadequate</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Exterior walls:</strong> Pipes in walls facing north or exposed to wind are at high risk</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Crawl spaces:</strong> Unheated crawl spaces allow cold air direct access to pipes</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Garages:</strong> Water lines to garage sinks or water heaters are often unprotected</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Outdoor faucets:</strong> Hose bibs and sprinkler system lines are first to freeze</span>
                </li>
              </ul>
            </section>

            {/* Prevention Strategies */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">Proven Prevention Strategies</h2>
              
              <h3 className="font-bold text-2xl mb-4">Before Winter Arrives (September-November)</h3>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-gray-900">1. Insulate Vulnerable Pipes</h4>
                  <p className="text-gray-700 mb-3">
                    Pipe insulation is cheap insurance. Foam pipe sleeves cost $1-3 per foot and can prevent thousands in damage. Focus on:
                  </p>
                  <ul className="space-y-2 text-gray-700 ml-6">
                    <li>• All pipes in attics, crawl spaces, and garages</li>
                    <li>• Pipes in exterior walls (if accessible)</li>
                    <li>• The first 6 feet of pipe after it enters your home from outside</li>
                  </ul>
                  <p className="text-gray-700 mt-3">
                    <strong>Pro tip:</strong> Use foam sleeves rated for your climate zone. In Lubbock, R-3 to R-4 rated insulation is recommended.
                  </p>
                </CardContent>
              </Card>

              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-gray-900">2. Seal Air Leaks</h4>
                  <p className="text-gray-700 mb-3">
                    Cold air infiltration is a major cause of frozen pipes. Seal gaps and cracks where pipes enter your home:
                  </p>
                  <ul className="space-y-2 text-gray-700 ml-6">
                    <li>• Around pipes entering through exterior walls</li>
                    <li>• In crawl space vents (or install closeable vent covers)</li>
                    <li>• Around attic hatches and pull-down stairs</li>
                    <li>• In rim joists and sill plates</li>
                  </ul>
                  <p className="text-gray-700 mt-3">
                    Use expanding foam sealant for larger gaps and caulk for smaller cracks. This also improves energy efficiency year-round.
                  </p>
                </CardContent>
              </Card>

              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-gray-900">3. Disconnect and Drain Outdoor Hoses</h4>
                  <p className="text-gray-700 mb-3">
                    Water trapped in hoses and outdoor faucets will freeze and can crack the faucet or even burst pipes inside your wall. Before the first freeze:
                  </p>
                  <ul className="space-y-2 text-gray-700 ml-6">
                    <li>• Disconnect all garden hoses and drain them</li>
                    <li>• Shut off interior valves feeding outdoor faucets (if equipped)</li>
                    <li>• Open outdoor faucets to drain remaining water</li>
                    <li>• Install insulated faucet covers ($3-5 each at hardware stores)</li>
                  </ul>
                </CardContent>
              </Card>

              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-gray-900">4. Know Your Main Water Shutoff</h4>
                  <p className="text-gray-700">
                    In an emergency, you need to shut off water immediately. Locate your main water shutoff valve now (usually near the water meter or where the main line enters your home). Make sure everyone in your household knows where it is and how to operate it. If it's stuck or difficult to turn, call Cotton City Plumbing to replace it before you need it in an emergency.
                  </p>
                </CardContent>
              </Card>

              <h3 className="font-bold text-2xl mb-4 mt-8">When a Freeze Is Forecast (24-48 Hours Before)</h3>
              
              <Card className="mb-6 bg-yellow-50 border-yellow-200">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-gray-900">Critical Actions to Take Tonight</h4>
                  <p className="text-primary mb-4">
                    When Lubbock's forecast shows overnight lows below 28°F or sustained temps below 32°F for 6+ hours, take these steps before bed:
                  </p>
                  
                  <div className="space-y-4">
                    <div>
                      <p className="font-bold text-gray-900">1. Let Faucets Drip</p>
                      <p className="text-primary">
                        Open faucets fed by vulnerable pipes to a pencil-lead-thin stream (both hot and cold sides). Running water is much harder to freeze than standing water. Focus on:
                      </p>
                      <ul className="ml-6 mt-2 space-y-1 text-primary">
                        <li>• Faucets on exterior walls</li>
                        <li>• Faucets in unheated areas (garage, utility room)</li>
                        <li>• The faucet farthest from your water heater</li>
                      </ul>
                      <p className="text-primary mt-2 text-sm italic">
                        Yes, this wastes water, but it's far cheaper than repairing burst pipes. A dripping faucet uses about 1-2 gallons per day; a burst pipe can discharge 250 gallons per hour.
                      </p>
                    </div>

                    <div>
                      <p className="font-bold text-gray-900">2. Open Cabinet Doors</p>
                      <p className="text-primary">
                        Open cabinet doors under sinks on exterior walls to allow warm air circulation around pipes. Remove any stored chemicals if you have small children or pets.
                      </p>
                    </div>

                    <div>
                      <p className="font-bold text-gray-900">3. Maintain Indoor Heat</p>
                      <p className="text-primary">
                        Keep your thermostat at 55°F or higher, even if you're away from home. The cost of heating is nothing compared to burst pipe damage. If you're leaving town during winter, either maintain heat or have a plumber winterize your home (drain all pipes).
                      </p>
                    </div>

                    <div>
                      <p className="font-bold text-gray-900">4. Close Crawl Space Vents</p>
                      <p className="text-primary">
                        If your home has a crawl space with vents, close them when freezing weather is forecast to prevent cold air from reaching pipes.
                      </p>
                    </div>

                    <div>
                      <p className="font-bold text-gray-900">5. Add Heat to Problem Areas</p>
                      <p className="text-primary">
                        For known trouble spots (pipes that have frozen before), add supplemental heat:
                      </p>
                      <ul className="ml-6 mt-2 space-y-1 text-primary">
                        <li>• Use a space heater in the room (never leave unattended)</li>
                        <li>• Install heat tape or heat cable on pipes (follow manufacturer instructions carefully)</li>
                        <li>• Leave a light bulb on in cabinets under sinks (60W incandescent generates enough heat)</li>
                      </ul>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </section>

            {/* What to Do If Pipes Freeze */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">What to Do If Your Pipes Freeze</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                Despite your best efforts, pipes can still freeze. Here's how to respond safely:
              </p>

              <Card className="mb-6 border-2 border-red-200 bg-white">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-red-900">STOP: Do NOT Do These Things</h4>
                  <ul className="space-y-2 text-gray-800">
                    <li className="flex items-start gap-2">
                      <span className="text-red-600 font-bold">✗</span>
                      <span>Use open flames (blowtorch, propane heater) to thaw pipes—this causes fires and can burst pipes</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-red-600 font-bold">✗</span>
                      <span>Use high-heat devices like heat guns at maximum setting—pipes can burst from rapid temperature change</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-red-600 font-bold">✗</span>
                      <span>Leave the situation unattended—frozen pipes can burst as they thaw, causing flooding</span>
                    </li>
                  </ul>
                </CardContent>
              </Card>

              <h3 className="font-bold text-2xl mb-4">Safe Thawing Steps</h3>
              
              <ol className="space-y-4 text-lg text-gray-700">
                <li className="flex items-start gap-3">
                  <span className="font-bold text-primary">1.</span>
                  <div>
                    <p className="font-bold">Turn off the main water supply</p>
                    <p>If a pipe has burst, this prevents flooding. If you're not sure, turn it off anyway as a precaution.</p>
                  </div>
                </li>
                <li className="flex items-start gap-3">
                  <span className="font-bold text-primary">2.</span>
                  <div>
                    <p className="font-bold">Open the affected faucet</p>
                    <p>This relieves pressure and allows water to flow once the pipe thaws.</p>
                  </div>
                </li>
                <li className="flex items-start gap-3">
                  <span className="font-bold text-primary">3.</span>
                  <div>
                    <p className="font-bold">Apply gentle heat</p>
                    <p>If the frozen section is accessible, use:</p>
                    <ul className="ml-6 mt-2 space-y-1">
                      <li>• Hair dryer on low setting, moving constantly along the pipe</li>
                      <li>• Hot towels wrapped around the pipe (replace as they cool)</li>
                      <li>• Space heater warming the room (not directly on pipes)</li>
                    </ul>
                    <p className="mt-2">Start from the faucet end and work toward the frozen section.</p>
                  </div>
                </li>
                <li className="flex items-start gap-3">
                  <span className="font-bold text-primary">4.</span>
                  <div>
                    <p className="font-bold">Call Cotton City Plumbing</p>
                    <p>If you can't locate the frozen section, can't access it safely, or if pipes have burst, call us immediately at (806) 441-4110. We have professional thawing equipment and can assess for damage.</p>
                  </div>
                </li>
              </ol>
            </section>

            {/* When to Call a Professional */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">When to Call Cotton City Plumbing</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                Call us immediately if:
              </p>

              <ul className="space-y-3 text-lg text-gray-700 mb-6">
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">✓</span>
                  <span>You have no water throughout the house and suspect frozen pipes</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">✓</span>
                  <span>You hear water running but can't locate the source (possible burst pipe in a wall or ceiling)</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">✓</span>
                  <span>You see water stains, bulging drywall, or dripping from ceilings</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">✓</span>
                  <span>Frozen pipes are in walls, ceilings, or other inaccessible areas</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">✓</span>
                  <span>You're uncomfortable attempting to thaw pipes yourself</span>
                </li>
              </ul>

              <p className="text-lg leading-relaxed text-gray-700">
                We offer 24/7 emergency service because frozen pipes don't wait for business hours. Our licensed plumbers have professional-grade thawing equipment and can quickly restore your water while minimizing damage.
              </p>
            </section>

          </div>

          {/* Social Share Buttons */}
          <div className="mt-16 p-8 bg-gray-50 rounded-xl">
            <SocialShareButtons
              url="/blog/frozen-pipes-prevention"
              title="How to Prevent Frozen Pipes in West Texas Winters"
              description="Protect your Lubbock home from costly frozen pipe damage. Learn proven prevention strategies for West Texas winters and what to do if pipes freeze."
            />
          </div>

          {/* CTA Section */}
          <Card className="mt-12 bg-gradient-to-br from-primary to-primary/90 text-white border-none">
            <CardContent className="p-8 md:p-12 text-center">
              <h2 className="font-heading font-bold text-3xl md:text-4xl mb-4">
                Protect Your Home This Winter
              </h2>
              <p className="text-xl mb-8 text-white/90 max-w-2xl mx-auto">
                Don't wait for a freeze to discover your pipes are vulnerable. Call Cotton City Plumbing today for a winter plumbing inspection. We'll identify at-risk pipes and recommend affordable prevention measures.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button
                  size="lg"
                  variant="secondary"
                  className="font-bold text-lg"
                  onClick={() => window.location.href = 'tel:8064414110'}
                >
                  <Phone className="mr-2 h-5 w-5" />
                  Call (806) 441-4110
                </Button>
                <Link href="/contact">
                  <Button
                    size="lg"
                    variant="outline"
                    className="font-bold text-lg bg-white text-primary hover:bg-white/90 border-white w-full sm:w-auto"
                  >
                    Schedule Inspection
                  </Button>
                </Link>
              </div>
              <p className="text-sm mt-6 text-white/80">
                Licensed & Insured M-44446 | Serving Lubbock & the South Plains Since 2019
              </p>
            </CardContent>
          </Card>

        </div>
      </article>
    </Layout>
  );
}
