import React from 'react';
import { Helmet } from 'react-helmet-async';

const WheelockAndMonterey: React.FC = () => {
  const schemaMarkup = {
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "[Business Name] - Plumbing Services in Wheelock and Monterey, Lubbock, TX",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "[Street Address]", // Placeholder
      "addressLocality": "Lubbock",
      "addressRegion": "TX",
      "postalCode": "[Postal Code]" // Placeholder
    },
    "geo": {
      "@type": "GeoCoordinates",
      "latitude": 33.5779,
      "longitude": -101.8552
    },
    "url": "https://yourwebsite.com/neighborhoods/wheelock-and-monterey", // Placeholder
    "telephone": "(806) 441-4110",
    "openingHoursSpecification": [
      {
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday"
        ],
        "opens": "08:00",
        "closes": "17:00"
      }
    ],
    "hasMap": "https://www.google.com/maps/search/Wheelock+and+Monterey+Lubbock+TX", // Placeholder
    "description": "Expert plumbing services in the Wheelock and Monterey neighborhood of Lubbock, TX. Specializing in emergency plumbing, water heaters, and drain cleaning."
  };

  return (
    <div className="wheelock-monterey-page">
      <Helmet>
        <title>Wheelock and Monterey Plumbing Services | Expert Plumbers in Lubbock, TX</title>
        <meta name="description" content="Providing reliable emergency plumbing, water heater repair, and drain cleaning services in Wheelock and Monterey, Lubbock, TX. Local experts for your home's plumbing needs." />
        <meta name="keywords" content="Wheelock and Monterey plumbing, Lubbock plumbers, emergency plumbing Wheelock and Monterey, water heater repair Lubbock, drain cleaning Wheelock and Monterey, local plumber Lubbock, plumbing services Lubbock TX" />
        <script type="application/ld+json">
          {JSON.stringify(schemaMarkup)}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to Wheelock and Monterey, Lubbock, TX</h1>
        <p>Discover the charm and convenience of the Wheelock and Monterey neighborhood, a vibrant community nestled in the heart of Lubbock. Known for its diverse residential areas and local businesses, Wheelock and Monterey offers a peaceful and relaxed atmosphere with easy access to everything you need.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in Wheelock and Monterey?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Our team understands the unique plumbing needs of Wheelock and Monterey homes.</p>
          </div>
          <div className="card">
            <h3>Prompt Service</h3>
            <p>We're dedicated to providing quick and efficient service to our neighbors.</p>
          </div>
          <div className="card">
            <h3>Quality Workmanship</h3>
            <p>Expect top-notch plumbing solutions that last.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Proudly serving the Wheelock and Monterey community with integrity.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Wheelock and Monterey</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 rapid response for all your urgent plumbing issues.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance for all types of water heaters.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains and sewer lines.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About Wheelock and Monterey, Lubbock</h2>
        <p>The Wheelock and Monterey neighborhood is renowned for its excellent educational institutions, including the highly-rated Lubbock High School, Monterey High School, Slaton Middle School, and Wheelock Elementary School, named after Lubbock's founder. Residents enjoy convenient access to diverse shopping, dining, and entertainment options. With ample green spaces and quiet streets, it's an ideal place for families and retirees seeking a balanced urban and peaceful living experience.</p>
        <p>Key features include:</p>
        <ul>
          <li>**Top-Rated Schools:** Home to some of Lubbock's best schools.</li>
          <li>**Central Location:** Situated in the heart of Lubbock with easy access to amenities.</li>
          <li>**Green Spaces:** Public parks and quiet streets for outdoor enjoyment.</li>
          <li>**Diverse Community:** A blend of residential charm and local businesses.</li>
        </ul>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Services in Wheelock and Monterey?</h2>
        <p>Call us today for reliable and professional plumbing solutions!</p>
        <p className="phone-number">(806) 441-4110</p>
        <button className="booking-button">Book Now with Housecall Pro</button>
      </section>
    </div>
  );
};

export default WheelockAndMonterey;
