
import React from 'react';

const Westwind: React.FC = () => {
  const neighborhoodName = 'Westwind';
  const urlSlug = 'westwind';
  const componentName = 'Westwind';

  // Approximate Lubbock coordinates
  const geoCoordinates = {
    latitude: 33.5779,
    longitude: -101.8552,
  };

  return (
    <div className="neighborhood-page">
      {/* LocalBusiness Schema Markup */}
      <script type="application/ld+json">
        {
          `{
            "@context": "http://schema.org",
            "@type": "LocalBusiness",
            "name": "Plumbing Services in ${neighborhoodName}",
            "address": {
              "@type": "PostalAddress",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79414", // Using a common Lubbock zip code for example
              "streetAddress": ""
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": ${geoCoordinates.latitude},
              "longitude": ${geoCoordinates.longitude}
            },
            "url": "https://yourwebsite.com/neighborhoods/${urlSlug}",
            "telephone": "+18064414110",
            "openingHours": "Mo-Sa 08:00-17:00",
            "priceRange": "$$"
          }`
        }
      </script>

      {/* SEO Elements */}
      <title>{`Plumbing Services in ${neighborhoodName}, Lubbock, TX`}</title>
      <meta name="description" content={`Expert plumbing services for the ${neighborhoodName} neighborhood in Lubbock, TX. From emergency repairs to water heater installations, we've got you covered.`} />
      <meta name="keywords" content={`plumbing ${neighborhoodName}, plumber Lubbock ${neighborhoodName}, emergency plumbing ${neighborhoodName}, water heater ${neighborhoodName}, drain cleaning ${neighborhoodName}, Lubbock TX plumbing`}
      />

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to {neighborhoodName}</h1>
        <p>Discover reliable and professional plumbing services tailored for the {neighborhoodName} community in Lubbock, TX. We are dedicated to serving our neighbors with top-quality solutions.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in {neighborhoodName}?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of {neighborhoodName}'s unique plumbing needs and infrastructure.</p>
          </div>
          <div className="card">
            <h3>Rapid Response</h3>
            <p>Quick and efficient service for all your plumbing emergencies in {neighborhoodName}.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Certified and experienced plumbers committed to excellence in {neighborhoodName}.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Proudly serving the {neighborhoodName} community with integrity and quality workmanship.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in {neighborhoodName}</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 rapid response for burst pipes, severe leaks, and urgent plumbing issues in {neighborhoodName}.</p>
          </div>
          <div className="card">
            <h3>Water Heater Repair & Installation</h3>
            <p>Expert service for all types of water heaters, ensuring hot water for your {neighborhoodName} home.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Thorough and effective drain cleaning to keep your plumbing flowing smoothly in {neighborhoodName}.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About {neighborhoodName}</h2>
        <p>{neighborhoodName} is a vibrant and welcoming community located in Lubbock, TX. Known for its family-friendly atmosphere and convenient access to local amenities, it's a great place to live and work. Residents enjoy proximity to Westwind Elementary School, a highly-rated public school within the Frenship Independent School District, and easy access to local parks like West Wind Park. The neighborhood offers a blend of residential comfort with the convenience of city living, making it an ideal location for families and individuals alike.</p>
        <p>With its well-maintained homes and friendly neighbors, {neighborhoodName} provides a peaceful suburban feel while still being close to shopping, dining, and entertainment options that Lubbock has to offer. Our plumbing services are proud to be a part of this thriving community, ensuring that homes and businesses in {neighborhoodName} have access to reliable and efficient plumbing solutions.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Help in {neighborhoodName}?</h2>
        <p>Call us today for reliable service or book online!</p>
        <p className="phone-number">(806) 441-4110</p>
        <a href="https://www.housecallpro.com/book/your-company-name" target="_blank" rel="noopener noreferrer" className="hcp-button">
          Book Now with Housecall Pro
        </a>
      </section>

      {/* Basic Styling (to be moved to a CSS file or styled-components in a real app) */}
      <style>{`
        .neighborhood-page {
          font-family: Arial, sans-serif;
          color: #333;
          line-height: 1.6;
        }
        .hero-section {
          background-color: #000;
          color: #fff;
          padding: 60px 20px;
          text-align: center;
        }
        .hero-section h1 {
          font-size: 3em;
          margin-bottom: 10px;
        }
        .hero-section p {
          font-size: 1.2em;
          max-width: 800px;
          margin: 0 auto;
        }
        section {
          padding: 40px 20px;
          max-width: 1200px;
          margin: 0 auto;
        }
        h2 {
          text-align: center;
          font-size: 2.5em;
          margin-bottom: 30px;
          color: #cc0000; /* Red accent */
        }
        .cards-container {
          display: flex;
          flex-wrap: wrap;
          justify-content: center;
          gap: 20px;
        }
        .card {
          background-color: #f4f4f4;
          border: 1px solid #ddd;
          border-radius: 8px;
          padding: 20px;
          width: 280px;
          text-align: center;
          box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .card h3 {
          color: #000;
          margin-bottom: 10px;
        }
        .cta-section {
          background-color: #cc0000; /* Red accent */
          color: #fff;
          text-align: center;
          padding: 50px 20px;
        }
        .cta-section .phone-number {
          font-size: 2em;
          margin: 20px 0;
        }
        .hcp-button {
          background-color: #000;
          color: #fff;
          padding: 15px 30px;
          text-decoration: none;
          border-radius: 5px;
          font-size: 1.1em;
          transition: background-color 0.3s ease;
        }
        .hcp-button:hover {
          background-color: #333;
        }
      `}</style>
    </div>
  );
};

export default Westwind;
