
import React from 'react';

const WestLubbock: React.FC = () => {
  return (
    <div className="west-lubbock-landing-page">
      {/* Schema Markup */}
      <script type="application/ld+json">
        {`
          {
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "Plumbing Services in West Lubbock",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "", // To be filled if specific address is known
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "", // To be filled if specific address is known
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.5779,
              "longitude": -101.8552
            },
            "url": "https://www.example.com/west-lubbock", // Replace with actual URL
            "telephone": "+18064414110",
            "openingHoursSpecification": [
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": [
                  "Monday",
                  "Tuesday",
                  "Wednesday",
                  "Thursday",
                  "Friday",
                  "Saturday",
                  "Sunday"
                ],
                "opens": "00:00",
                "closes": "23:59"
              }
            ],
            "priceRange": "$$", // Example price range
            "image": "https://www.example.com/images/west-lubbock-hero.jpg", // Replace with actual image
            "description": "Expert plumbing services for the West Lubbock neighborhood, including emergency repairs, water heater installation, and drain cleaning."
          }
        `}
      </script>

      {/* SEO Meta Tags - These would typically be handled in index.html or a Head component */}
      {/* For demonstration, including as comments */}
      {/*
      <title>West Lubbock Plumbing Services - Your Trusted Local Plumbers</title>
      <meta name="description" content="Reliable plumbing solutions in West Lubbock. We offer emergency services, water heater repair, drain cleaning, and more. Contact us today!" />
      <meta name="keywords" content="West Lubbock plumbing, plumber West Lubbock, emergency plumbing Lubbock, water heater West Lubbock, drain cleaning Lubbock" />
      */}

      {/* Hero Section */}
      <section className="hero-section" style={{ backgroundColor: '#000', color: '#fff', padding: '60px 20px', textAlign: 'center' }}>
        <h1 style={{ color: '#e74c3c' }}>Expert Plumbing Services in West Lubbock</h1>
        <p style={{ fontSize: '1.2em' }}>
          Serving the vibrant community of West Lubbock with reliable and professional plumbing solutions.
          From the bustling areas near Texas Tech University to the family-friendly neighborhoods, we're your local plumbing experts.
        </p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us" style={{ padding: '40px 20px', backgroundColor: '#f4f4f4' }}>
        <h2 style={{ textAlign: 'center', color: '#333' }}>Why Choose Us for Your West Lubbock Home?</h2>
        <div style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap', marginTop: '30px' }}>
          <div className="card" style={cardStyle}>
            <h3 style={{ color: '#e74c3c' }}>Local Expertise</h3>
            <p>Deep understanding of West Lubbock's unique plumbing needs and infrastructure.</p>
          </div>
          <div className="card" style={cardStyle}>
            <h3 style={{ color: '#e74c3c' }}>Rapid Response</h3>
            <p>Quick and efficient service to address your plumbing emergencies in West Lubbock.</p>
          </div>
          <div className="card" style={cardStyle}>
            <h3 style={{ color: '#e74c3c' }}>Certified Professionals</h3>
            <p>Our team comprises highly trained and certified plumbers dedicated to quality.</p>
          </div>
          <div className="card" style={cardStyle}>
            <h3 style={{ color: '#e74c3c' }}>Customer Satisfaction</h3>
            <p>Committed to exceeding expectations with every job in the West Lubbock area.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section" style={{ padding: '40px 20px', backgroundColor: '#fff' }}>
        <h2 style={{ textAlign: 'center', color: '#333' }}>Our Plumbing Services in West Lubbock</h2>
        <div style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap', marginTop: '30px' }}>
          <div className="service-card" style={cardStyle}>
            <h3 style={{ color: '#e74c3c' }}>Emergency Plumbing</h3>
            <p>24/7 emergency services for burst pipes, major leaks, and urgent repairs in West Lubbock.</p>
          </div>
          <div className="service-card" style={cardStyle}>
            <h3 style={{ color: '#e74c3c' }}>Water Heater Services</h3>
            <p>Installation, repair, and maintenance of all types of water heaters for West Lubbock homes.</p>
          </div>
          <div className="service-card" style={cardStyle}>
            <h3 style={{ color: '#e74c3c' }}>Drain Cleaning</h3>
            <p>Effective drain cleaning solutions to clear blockages and restore flow in your West Lubbock property.</p>
          </div>
        </div>
      </section>

      {/* About West Lubbock Section */}
      <section className="about-neighborhood" style={{ padding: '40px 20px', backgroundColor: '#f4f4f4' }}>
        <h2 style={{ textAlign: 'center', color: '#333' }}>About West Lubbock</h2>
        <p style={{ textAlign: 'center', lineHeight: '1.6' }}>
          West Lubbock is a dynamic and growing area known for its blend of residential comfort and convenient amenities.
          Home to excellent schools within the Frenship ISD, such as Oak Ridge Elementary, and in close proximity to Texas Tech University,
          it offers a vibrant atmosphere for families and students alike. Residents enjoy easy access to shopping centers, diverse dining options,
          and recreational green spaces. The community's development continues to attract new families, making it a prime location for both living and business.
        </p>
      </section>

      {/* CTA Section */}
      <section className="cta-section" style={{ backgroundColor: '#000', color: '#fff', padding: '60px 20px', textAlign: 'center' }}>
        <h2 style={{ color: '#e74c3c' }}>Need Plumbing Service in West Lubbock?</h2>
        <p style={{ fontSize: '1.5em', margin: '20px 0' }}>Call Us Today: <a href="tel:+18064414110" style={{ color: '#fff', textDecoration: 'none' }}>(806) 441-4110</a></p>
        <button style={buttonStyle}>Book Now with Housecall Pro</button>
      </section>
    </div>
  );
};

const cardStyle: React.CSSProperties = {
  backgroundColor: '#fff',
  border: '1px solid #ddd',
  borderRadius: '8px',
  padding: '20px',
  margin: '10px',
  flex: '1 1 calc(25% - 40px)', // Adjust for 4 cards per row, responsive
  boxShadow: '0 2px 4px rgba(0,0,0,0.1)',
  textAlign: 'center',
  minWidth: '250px'
};

const buttonStyle: React.CSSProperties = {
  backgroundColor: '#e74c3c',
  color: '#fff',
  border: 'none',
  padding: '15px 30px',
  fontSize: '1.2em',
  borderRadius: '5px',
  cursor: 'pointer',
  textDecoration: 'none'
};

export default WestLubbock;
