import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Shield, CheckCircle, Clock, Award, FileText, Phone } from "lucide-react";
import { Button } from "@/components/ui/button";

export default function Warranty() {

  return (
    <Layout>
      <SEO 
        title="Our Warranty & Guarantee | Cotton City Plumbing"
        description="Industry-leading warranties on all plumbing work. 6-10 year warranties on tank water heaters, 15-year warranties on tankless systems. Licensed & insured in Lubbock, TX."
        canonical="/warranty"
      />

      {/* Hero Section */}
      <section className="bg-black text-white py-20">
        <div className="container">
          <div className="max-w-4xl mx-auto text-center space-y-6">
            <div className="inline-flex items-center gap-3 bg-primary/20 border-2 border-primary px-6 py-3 rounded-none">
              <Shield className="h-8 w-8 text-primary" />
              <span className="font-heading font-bold text-2xl uppercase">Our Guarantee</span>
            </div>
            
            <h1 className="font-heading font-extrabold text-5xl md:text-7xl uppercase italic">
              We Stand Behind <span className="text-primary">Our Work</span>
            </h1>
            
            <p className="text-xl text-gray-300 leading-relaxed max-w-3xl mx-auto">
              At Cotton City Plumbing, we don't just fix your plumbing—we guarantee it. Our industry-leading warranties give you peace of mind knowing your investment is protected.
            </p>
          </div>
        </div>
      </section>

      {/* Warranty Terms Section */}
      <section className="py-20 bg-background">
        <div className="container">
          <div className="max-w-5xl mx-auto space-y-12">
            
            <div className="text-center space-y-4 mb-12">
              <h2 className="font-heading font-bold text-4xl md:text-5xl uppercase italic">
                Warranty <span className="text-primary">Coverage</span>
              </h2>
              <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
                We match manufacturer warranties with our labor warranties to ensure complete protection on your plumbing investments.
              </p>
            </div>

            {/* Water Heater Warranties */}
            <div className="grid md:grid-cols-2 gap-8">
              
              {/* Tank Water Heaters */}
              <Card className="border-2 border-border bg-card hover:border-primary transition-colors">
                <CardHeader className="bg-black text-white">
                  <CardTitle className="font-heading text-2xl uppercase flex items-center gap-3">
                    <Shield className="h-6 w-6 text-primary" />
                    Tank Water Heaters
                  </CardTitle>
                </CardHeader>
                <CardContent className="p-6 space-y-4">
                  <div className="space-y-3">
                    <div className="flex items-start gap-3">
                      <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                      <div>
                        <p className="font-bold text-lg">6-Year Warranty</p>
                        <p className="text-muted-foreground">Standard coverage on all tank water heater installations</p>
                      </div>
                    </div>
                    <div className="flex items-start gap-3">
                      <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                      <div>
                        <p className="font-bold text-lg">10-Year Warranty</p>
                        <p className="text-muted-foreground">Extended coverage available on premium tank models</p>
                      </div>
                    </div>
                  </div>
                  <div className="pt-4 border-t border-border">
                    <p className="text-sm text-muted-foreground">
                      Covers both parts and labor for complete peace of mind
                    </p>
                  </div>
                </CardContent>
              </Card>

              {/* Tankless Water Heaters */}
              <Card className="border-2 border-primary bg-card">
                <CardHeader className="bg-primary text-white">
                  <CardTitle className="font-heading text-2xl uppercase flex items-center gap-3">
                    <Award className="h-6 w-6" />
                    Tankless Water Heaters
                  </CardTitle>
                </CardHeader>
                <CardContent className="p-6 space-y-4">
                  <div className="space-y-3">
                    <div className="flex items-start gap-3">
                      <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                      <div>
                        <p className="font-bold text-lg">15-Year Warranty</p>
                        <p className="text-muted-foreground">Industry-leading coverage on all tankless installations</p>
                      </div>
                    </div>
                    <div className="flex items-start gap-3">
                      <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                      <div>
                        <p className="font-bold text-lg">Premium Protection</p>
                        <p className="text-muted-foreground">Extended coverage reflects the superior quality of tankless systems</p>
                      </div>
                    </div>
                  </div>
                  <div className="pt-4 border-t border-white/20">
                    <p className="text-sm text-muted-foreground">
                      Comprehensive parts and labor coverage for maximum value
                    </p>
                  </div>
                </CardContent>
              </Card>

            </div>

            {/* General Plumbing Services */}
            <Card className="border-2 border-border">
              <CardHeader className="bg-black text-white">
                <CardTitle className="font-heading text-2xl uppercase flex items-center gap-3">
                  <FileText className="h-6 w-6 text-primary" />
                  General Plumbing Services
                </CardTitle>
              </CardHeader>
              <CardContent className="p-6">
                <div className="grid md:grid-cols-2 gap-6">
                  <div className="flex items-start gap-3">
                    <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                    <div>
                      <p className="font-bold">1-Year Warranty on Repairs</p>
                      <p className="text-sm text-muted-foreground">All plumbing repairs backed by our workmanship guarantee</p>
                    </div>
                  </div>
                  <div className="flex items-start gap-3">
                    <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                    <div>
                      <p className="font-bold">5-Year Warranty on Repiping</p>
                      <p className="text-sm text-muted-foreground">Extended coverage on whole-home repiping projects</p>
                    </div>
                  </div>
                  <div className="flex items-start gap-3">
                    <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                    <div>
                      <p className="font-bold">2-Year Warranty on Fixtures</p>
                      <p className="text-sm text-muted-foreground">Faucets, toilets, and fixture installations fully covered</p>
                    </div>
                  </div>
                  <div className="flex items-start gap-3">
                    <CheckCircle className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                    <div>
                      <p className="font-bold">Lifetime Warranty on Drain Cleaning</p>
                      <p className="text-sm text-muted-foreground">If the same drain clogs again within 30 days, we'll re-clean it free</p>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>

          </div>
        </div>
      </section>

      {/* What's Covered Section */}
      <section className="py-20 bg-black text-white">
        <div className="container">
          <div className="max-w-4xl mx-auto space-y-12">
            
            <div className="text-center space-y-4">
              <h2 className="font-heading font-bold text-4xl md:text-5xl uppercase italic">
                What's <span className="text-primary">Covered</span>
              </h2>
              <p className="text-xl text-gray-300">
                Our warranties protect you from defects in materials and workmanship
              </p>
            </div>

            <div className="grid md:grid-cols-3 gap-8">
              <div className="text-center space-y-4">
                <div className="inline-flex items-center justify-center w-16 h-16 bg-primary/20 border-2 border-primary rounded-full">
                  <Shield className="h-8 w-8 text-primary" />
                </div>
                <h3 className="font-heading font-bold text-xl uppercase">Parts & Materials</h3>
                <p className="text-gray-400">
                  All parts and materials used in your installation or repair are covered under warranty
                </p>
              </div>

              <div className="text-center space-y-4">
                <div className="inline-flex items-center justify-center w-16 h-16 bg-primary/20 border-2 border-primary rounded-full">
                  <Clock className="h-8 w-8 text-primary" />
                </div>
                <h3 className="font-heading font-bold text-xl uppercase">Labor & Service</h3>
                <p className="text-gray-400">
                  Our skilled technicians' work is guaranteed—if something goes wrong, we'll make it right
                </p>
              </div>

              <div className="text-center space-y-4">
                <div className="inline-flex items-center justify-center w-16 h-16 bg-primary/20 border-2 border-primary rounded-full">
                  <Award className="h-8 w-8 text-primary" />
                </div>
                <h3 className="font-heading font-bold text-xl uppercase">Manufacturer Match</h3>
                <p className="text-gray-400">
                  We match manufacturer warranties to ensure complete protection on your investment
                </p>
              </div>
            </div>

          </div>
        </div>
      </section>

      {/* Trust Badges Section */}
      <section className="py-20 bg-background">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            
            <div className="text-center space-y-4 mb-12">
              <h2 className="font-heading font-bold text-4xl md:text-5xl uppercase italic">
                Licensed, Insured & <span className="text-primary">Certified</span>
              </h2>
              <p className="text-xl text-muted-foreground">
                Your protection goes beyond our warranty
              </p>
            </div>

            <div className="grid md:grid-cols-3 gap-8">
              <Card className="text-center p-6 border-2 border-border hover:border-primary transition-colors">
                <CardContent className="space-y-3 pt-6">
                  <Shield className="h-12 w-12 text-primary mx-auto" />
                  <h3 className="font-heading font-bold text-lg uppercase">Licensed</h3>
                  <p className="text-muted-foreground">Master Plumber License #M-44446</p>
                </CardContent>
              </Card>

              <Card className="text-center p-6 border-2 border-border hover:border-primary transition-colors">
                <CardContent className="space-y-3 pt-6">
                  <Shield className="h-12 w-12 text-primary mx-auto" />
                  <h3 className="font-heading font-bold text-lg uppercase">Insured</h3>
                  <p className="text-muted-foreground">Full liability and workers' compensation coverage</p>
                </CardContent>
              </Card>

              <Card className="text-center p-6 border-2 border-border hover:border-primary transition-colors">
                <CardContent className="space-y-3 pt-6">
                  <Award className="h-12 w-12 text-primary mx-auto" />
                  <h3 className="font-heading font-bold text-lg uppercase">Award-Winning</h3>
                  <p className="text-muted-foreground">2025 Community's Choice & Nextdoor Fave</p>
                </CardContent>
              </Card>
            </div>

          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-primary text-white">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center space-y-8">
            <h2 className="font-heading font-extrabold text-4xl md:text-6xl uppercase italic">
              Ready to Experience the Cotton City Difference?
            </h2>
            <p className="text-xl opacity-90">
              Get industry-leading warranties and exceptional service from Lubbock's most trusted plumbers
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a href="tel:8064414110">
                <Button size="lg" className="bg-white text-primary hover:bg-gray-100 font-heading font-bold text-2xl px-8 py-8 rounded-none uppercase">
                  <Phone className="mr-2 h-6 w-6" /> Call (806) 441-4110
                </Button>
              </a>
            </div>
          </div>
        </div>
      </section>

    </Layout>
  );
}
