import { Helmet } from "react-helmet-async";
import Layout from "../components/Layout";
import { Phone, MapPin, Clock, Wrench, Droplet, Flame, Home } from "lucide-react";
import { Card, CardContent } from "../components/ui/card";

export default function TheRidge() {
  return (
    <Layout>
      <Helmet>
        <title>The Ridge Plumber Lubbock | Family-Friendly Community | Cotton City Plumbing</title>
        <meta name="description" content="Trusted plumber serving The Ridge neighborhood in southwest Lubbock. Expert plumbing services for family homes near Upland Avenue. Same-day service available." />
        <meta name="keywords" content="The Ridge plumber, plumber near The Ridge Lubbock, southwest Lubbock plumber, Upland Avenue plumber, family neighborhood plumbing" />
        <script type="application/ld+json">
          {JSON.stringify({
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "@id": "https://cottoncityplumbing.com/areas/the-ridge",
            "name": "Cotton City Plumbing - The Ridge Service Area",
            "image": "https://cottoncityplumbing.com/images/van.jpg",
            "telephone": "+18064414110",
            "email": "services@cottoncityplumbing.com",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "1306 146th Street",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79423",
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.4619721,
              "longitude": -101.8497587
            },
            "url": "https://cottoncityplumbing.com/areas/the-ridge",
            "priceRange": "$$",
            "openingHoursSpecification": [
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
                "opens": "07:00",
                "closes": "19:00"
              },
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": "Saturday",
                "opens": "08:00",
                "closes": "12:00"
              }
            ],
            "areaServed": [
              {
                "@type": "Place",
                "name": "The Ridge",
                "containedInPlace": {
                  "@type": "City",
                  "name": "Lubbock",
                  "@id": "https://en.wikipedia.org/wiki/Lubbock,_Texas"
                }
              }
            ],
            "hasOfferCatalog": {
              "@type": "OfferCatalog",
              "name": "Plumbing Services",
              "itemListElement": [
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Emergency Plumbing"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Water Heater Installation"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Drain Cleaning"
                  }
                }
              ]
            }
          })}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-black via-gray-900 to-black text-white py-20 relative overflow-hidden">
        <div className="absolute inset-0 opacity-10">
          <div className="absolute inset-0 bg-[url('/images/texture.png')] bg-repeat"></div>
        </div>
        
        <div className="container relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              <span className="text-secondary">The Ridge</span> Neighborhood Plumber
            </h1>
            <p className="text-xl md:text-2xl text-gray-300 mb-8">
              Trusted plumbing services for The Ridge family-friendly community in southwest Lubbock
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE
              </button>
            </div>
          </div>
        </div>
      </section>

      {/* Why Choose Us */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              Why The Ridge Families Choose Us
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Serving The Ridge neighborhood with reliable, family-focused plumbing services
            </p>

            <div className="grid md:grid-cols-2 gap-8">
              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Home className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Family-Friendly Service</h3>
                      <p className="text-muted-foreground">
                        We understand the needs of The Ridge families. Respectful, clean service with attention to your home and children's safety.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Clock className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Same-Day Service</h3>
                      <p className="text-muted-foreground">
                        Plumbing emergencies disrupt family life. We offer same-day service during business hours for The Ridge residents.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <MapPin className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Local to Southwest Lubbock</h3>
                      <p className="text-muted-foreground">
                        Based nearby, we provide fast response times to The Ridge near Upland Avenue and 98th Street.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Wrench className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Faith-Based Values</h3>
                      <p className="text-muted-foreground">
                        Christian values guide our work. We serve The Ridge families with honesty, integrity, and respect.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Services */}
      <section className="py-16">
        <div className="container">
          <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
            Plumbing Services for The Ridge Homes
          </h2>
          <p className="text-center text-muted-foreground mb-12 text-lg max-w-3xl mx-auto">
            From routine maintenance to emergency repairs, we handle all your family's plumbing needs
          </p>

          <div className="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Droplet className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Emergency Plumbing</h3>
                <p className="text-muted-foreground mb-4">
                  Burst pipes, water heater failures, and plumbing emergencies. Fast response for The Ridge families.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Flame className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Water Heaters</h3>
                <p className="text-muted-foreground mb-4">
                  Tank and tankless water heater installation, repair, and maintenance for The Ridge homes.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Wrench className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Drain Cleaning</h3>
                <p className="text-muted-foreground mb-4">
                  Professional drain cleaning and clog removal to keep your The Ridge home flowing smoothly.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>
          </div>

          <div className="text-center mt-12">
            <a
              href="/services"
              className="inline-block bg-primary hover:bg-primary/90 text-white font-bold text-lg px-8 py-4 rounded-lg shadow-lg transition-all"
            >
              View All Services
            </a>
          </div>
        </div>
      </section>

      {/* About The Ridge */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              About The Ridge
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Family-friendly neighborhood in southwest Lubbock
            </p>

            <div className="bg-white p-8 rounded-lg shadow-lg">
              <div className="grid md:grid-cols-2 gap-8">
                <div>
                  <h3 className="font-bold text-xl mb-4 text-primary">Community Features</h3>
                  <ul className="space-y-3 text-muted-foreground">
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Single-family homes</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Community pools and amenities</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Green spaces and parks</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Family-friendly atmosphere</span>
                    </li>
                  </ul>
                </div>
                <div>
                  <h3 className="font-bold text-xl mb-4 text-primary">Location Benefits</h3>
                  <ul className="space-y-3 text-muted-foreground">
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>East of Upland Avenue</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>South of 98th Street</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Southwest Lubbock location</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Close to schools and shopping</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="font-heading font-bold text-3xl md:text-4xl mb-6">
              Need a Plumber in The Ridge?
            </h2>
            <p className="text-xl mb-8 text-gray-100">
              Call Cotton City Plumbing for fast, family-friendly service
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE NOW
              </button>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
