import React from 'react';
import { Helmet } from 'react-helmet-async';

const SpanishOaks: React.FC = () => {
  const neighborhoodName = "Spanish Oaks";
  const phoneNumber = "(806) 441-4110";
  const geoCoordinates = { latitude: 33.5779, longitude: -101.8552 };

  const schemaMarkup = {
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "Plumbing Services in Spanish Oaks, Lubbock, TX",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "", // Specific address can be added if available
      "addressLocality": "Lubbock",
      "addressRegion": "TX",
      "postalCode": "", // Specific postal code can be added if available
      "addressCountry": "US"
    },
    "geo": {
      "@type": "GeoCoordinates",
      "latitude": geoCoordinates.latitude,
      "longitude": geoCoordinates.longitude
    },
    "url": `https://yourwebsite.com/${neighborhoodName.toLowerCase().replace(/ /g, '-')}`,
    "telephone": phoneNumber,
    "openingHoursSpecification": [
      {
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday"
        ],
        "opens": "08:00",
        "closes": "17:00"
      },
      {
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Saturday",
          "Sunday"
        ],
        "opens": "00:00",
        "closes": "23:59" // 24/7 for emergency services
      }
    ],
    "hasMap": `https://www.google.com/maps/search/${neighborhoodName.replace(/ /g, '+')}+Lubbock+TX`,
    "description": `Expert plumbing services in ${neighborhoodName}, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more for the ${neighborhoodName} community.`,
    "areaServed": {
      "@type": "City",
      "name": "Lubbock"
    }
  };

  return (
    <div className="spanish-oaks-landing-page">
      <Helmet>
        <title>Plumbing Services in Spanish Oaks, Lubbock, TX | Your Company Name</title>
        <meta name="description" content={`Expert plumbing services for the ${neighborhoodName} neighborhood in Lubbock, TX. Specializing in emergency repairs, water heaters, and drain cleaning.`} />
        <meta name="keywords" content={`plumbing Spanish Oaks Lubbock, plumber Spanish Oaks, emergency plumbing Spanish Oaks, water heater repair Spanish Oaks, drain cleaning Spanish Oaks, ${neighborhoodName} plumbing`}
        />
        <script type="application/ld+json">
          {JSON.stringify(schemaMarkup)}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <div className="container">
          <h1>Welcome to {neighborhoodName}</h1>
          <p>Your trusted plumbing experts in the heart of Lubbock's {neighborhoodName} neighborhood.</p>
        </div>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <div className="container">
          <h2>Why Choose Us for Your {neighborhoodName} Home?</h2>
          <div className="cards-grid">
            <div className="card">
              <h3>Local Expertise</h3>
              <p>Deep understanding of {neighborhoodName}'s unique plumbing needs and infrastructure.</p>
            </div>
            <div className="card">
              <h3>Rapid Response</h3>
              <p>Quick and efficient service to address your plumbing emergencies in {neighborhoodName}.</p>
            </div>
            <div className="card">
              <h3>Certified Professionals</h3>
              <p>Experienced and licensed plumbers dedicated to quality service in Lubbock.</p>
            </div>
            <div className="card">
              <h3>Customer Satisfaction</h3>
              <p>Committed to exceeding expectations for every client in {neighborhoodName}.</p>
            </div>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <div className="container">
          <h2>Our Plumbing Services in {neighborhoodName}</h2>
          <div className="cards-grid">
            <div className="card">
              <h3>Emergency Plumbing</h3>
              <p>24/7 availability for urgent plumbing issues, from burst pipes to major leaks.</p>
            </div>
            <div className="card">
              <h3>Water Heater Services</h3>
              <p>Installation, repair, and maintenance for all types of water heaters, ensuring hot water for your home.</p>
            </div>
            <div className="card">
              <h3>Drain Cleaning</h3>
              <p>Effective solutions for clogged drains, backed-up sewers, and persistent blockages.</p>
            </div>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <div className="container">
          <h2>About {neighborhoodName}, Lubbock, TX</h2>
          <p>{neighborhoodName} is a vibrant community in Southwest Lubbock, known for its well-maintained properties and family-friendly atmosphere. Residents enjoy convenient access to top-rated schools like Lubbock-Cooper ISD, making it an ideal location for families. The neighborhood boasts beautiful green spaces and is just a short drive from local shopping centers and dining options. Our plumbing services are tailored to support the comfortable and modern living standards of the Spanish Oaks community.</p>
        </div>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <div className="container">
          <h2>Need Plumbing Help in {neighborhoodName}?</h2>
          <p>Call us today for reliable and efficient plumbing services!</p>
          <a href={`tel:${phoneNumber}`} className="phone-button">{phoneNumber}</a>
          <a href="https://www.housecallpro.com/book/your-company-name" target="_blank" rel="noopener noreferrer" className="booking-button">Book Now with Housecall Pro</a>
        </div>
      </section>


    </div>
  );
};

export default SpanishOaks;
