import React from 'react';

const QuakerHeights: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const googleMapsLink = 'https://www.google.com/maps/search/?api=1&query=33.5779,-101.8552';

  return (
    <div className="quaker-heights-landing-page">
      {/* SEO */} 
      <head>
        <title>Quaker Heights Lubbock Plumbing Services | Expert Plumbers in 79424</title>
        <meta name="description" content="Premier plumbing services in Quaker Heights, Lubbock, TX. We offer emergency plumbing, water heater repair, and drain cleaning with local expertise. Contact us today!" />
        <meta name="keywords" content="Quaker Heights plumbing, Lubbock plumbers, emergency plumbing Lubbock, water heater repair Quaker Heights, drain cleaning Lubbock, 79424 plumbing, local plumber Quaker Heights" />
        <script type="application/ld+json">
          {JSON.stringify({
            "@context": "http://schema.org",
            "@type": "LocalBusiness",
            "name": "Cotton City Plumbing",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "1306 146th Street",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79423"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.4619721,
              "longitude": -101.8497587
            },
            "url": "https://cottoncityplumbing.com",
            "telephone": "+18064414110",
            "openingHours": "Mo-Fr 08:00-17:00",
            "priceRange": "$$"
          })}
        </script>
      </head>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Quaker Heights, Lubbock, TX</h1>
        <p>
          Welcome to Quaker Heights, a peaceful and family-friendly neighborhood nestled in South Lubbock. Known for its well-kept homes and close-knit community, Quaker Heights offers the perfect blend of serene living with convenient access to all the amenities Lubbock has to offer. Our expert plumbing services are proud to serve this vibrant community, ensuring comfort and peace of mind for every home.
        </p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Deep Local Knowledge</h3>
            <p>As your neighbors in Lubbock, we understand the unique plumbing needs of Quaker Heights homes, from common issues to specific local regulations.</p>
          </div>
          <div className="card">
            <h3>Fast & Reliable Service</h3>
            <p>Plumbing emergencies don't wait, and neither do we. Our team is ready to provide prompt and efficient service to Quaker Heights residents.</p>
          </div>
          <div className="card">
            <h3>Certified & Experienced</h3>
            <p>Our licensed and insured plumbers bring years of experience and a commitment to quality, ensuring every job in Quaker Heights is done right.</p>
          </div>
          <div className="card">
            <h3>Serving Our Community</h3>
            <p>We're more than just plumbers; we're part of the Quaker Heights community. We pride ourselves on building lasting relationships through honest work and exceptional service.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Services</h2>
        <div className="cards-container">
          <div className="card">
            <h3>24/7 Emergency Plumbing</h3>
            <p>Burst pipe at midnight? Clogged drain on a Sunday? Our emergency plumbing team is available around the clock for Quaker Heights residents, ready to tackle any urgent issue.</p>
          </div>
          <div className="card">
            <h3>Water Heater Repair & Installation</h3>
            <p>From routine maintenance to complex repairs or new installations, we ensure your Quaker Heights home has a reliable supply of hot water. We service all types and brands.</p>
          </div>
          <div className="card">
            <h3>Advanced Drain Cleaning</h3>
            <p>Say goodbye to stubborn clogs and slow drains. Our professional drain cleaning services use the latest technology to clear blockages and restore optimal flow in your Quaker Heights home's plumbing system.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About Quaker Heights</h2>
        <p>
          Quaker Heights is a well-established and desirable neighborhood in South Lubbock, ideally located between Quaker Avenue and Utica Avenue, and from 74th Street to 82nd Street, just south of Loop 289. This prime location offers residents easy access to a variety of amenities including local parks for recreation, diverse dining options, and convenient grocery shopping. The neighborhood is served by excellent schools, including those within the highly-regarded Frenship Independent School District, making it an ideal place for families. With its peaceful atmosphere, well-maintained homes, and strong community spirit, Quaker Heights provides a comfortable and connected living experience.
        </p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Ready for Reliable Plumbing Service?</h2>
        <p>Call us today for expert plumbing solutions in Quaker Heights!</p>
        <a href={`tel:${phoneNumber}`} className="phone-button">{phoneNumber}</a>
        <a href="#" className="housecall-pro-button">Book Now with Housecall Pro</a> {/* Placeholder for actual Housecall Pro booking link */}
      </section>

      {/* Basic Styling (to be replaced with actual site design) */}
      <style>{`
        .quaker-heights-landing-page {
          font-family: Arial, sans-serif;
          color: #333;
          line-height: 1.6;
        }
        .hero-section,
        .why-choose-us-section,
        .services-section,
        .about-neighborhood-section,
        .cta-section {
          padding: 40px 20px;
          margin-bottom: 20px;
          background-color: #f9f9f9;
          border-radius: 8px;
        }
        h1, h2 {
          color: #000;
          text-align: center;
          margin-bottom: 20px;
        }
        h3 {
          color: #cc0000; /* Red accent */
        }
        .cards-container {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
          gap: 20px;
          margin-top: 20px;
        }
        .card {
          background-color: #fff;
          border: 1px solid #ddd;
          border-radius: 8px;
          padding: 20px;
          box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .phone-button,
        .housecall-pro-button {
          display: block;
          width: fit-content;
          margin: 20px auto;
          padding: 15px 30px;
          background-color: #000; /* Black */
          color: #fff;
          text-decoration: none;
          border-radius: 5px;
          font-size: 1.1em;
          text-align: center;
          transition: background-color 0.3s ease;
        }
        .phone-button:hover,
        .housecall-pro-button:hover {
          background-color: #cc0000; /* Red accent on hover */
        }
      `}</style>
    </div>
  );
};

export default QuakerHeights;
