import { Helmet } from "react-helmet-async";
import Layout from "../components/Layout";
import { Phone, MapPin, Clock, Wrench, Droplet, Flame } from "lucide-react";
import { Card, CardContent } from "../components/ui/card";

export default function LubbockCooper() {
  return (
    <Layout>
      <Helmet>
        <title>Lubbock-Cooper Plumber | Same-Day Service | Cotton City Plumbing</title>
        <meta name="description" content="Trusted plumber serving Lubbock-Cooper ISD area including Fox Ridge, Kelsey Park, Vintage Township, and surrounding neighborhoods. Same-day emergency service available." />
        <meta name="keywords" content="Lubbock-Cooper plumber, plumber near Lubbock-Cooper ISD, Fox Ridge plumber, Kelsey Park plumber, south Lubbock plumber" />
        <script type="application/ld+json">
          {JSON.stringify({
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "@id": "https://cottoncityplumbing.com/areas/lubbock-cooper",
            "name": "Cotton City Plumbing - Lubbock-Cooper Service Area",
            "image": "https://cottoncityplumbing.com/images/van.jpg",
            "telephone": "+18064414110",
            "email": "services@cottoncityplumbing.com",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "1306 146th Street",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79423",
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.4619721,
              "longitude": -101.8497587
            },
            "url": "https://cottoncityplumbing.com/areas/lubbock-cooper",
            "priceRange": "$$",
            "openingHoursSpecification": [
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
                "opens": "07:00",
                "closes": "19:00"
              },
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": "Saturday",
                "opens": "08:00",
                "closes": "12:00"
              }
            ],
            "areaServed": [
              {
                "@type": "City",
                "name": "Lubbock-Cooper ISD Area",
                "containedInPlace": {
                  "@type": "City",
                  "name": "Lubbock",
                  "@id": "https://en.wikipedia.org/wiki/Lubbock,_Texas"
                }
              }
            ],
            "hasOfferCatalog": {
              "@type": "OfferCatalog",
              "name": "Plumbing Services",
              "itemListElement": [
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Emergency Plumbing"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Water Heater Installation"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Drain Cleaning"
                  }
                }
              ]
            }
          })}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-black via-gray-900 to-black text-white py-20 relative overflow-hidden">
        <div className="absolute inset-0 opacity-10">
          <div className="absolute inset-0 bg-[url('/images/texture.png')] bg-repeat"></div>
        </div>
        
        <div className="container relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              Your Trusted <span className="text-secondary">Lubbock-Cooper</span> Plumber
            </h1>
            <p className="text-xl md:text-2xl text-gray-300 mb-8">
              Serving Fox Ridge, Kelsey Park, Vintage Township, and all Lubbock-Cooper ISD communities with honest, reliable plumbing services
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE
              </button>
            </div>
          </div>
        </div>
      </section>

      {/* Why Choose Us for Lubbock-Cooper */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              Why Lubbock-Cooper Families Choose Cotton City Plumbing
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Located just minutes from your neighborhood at 1306 146th Street, we understand the unique plumbing needs of Lubbock-Cooper homes
            </p>

            <div className="grid md:grid-cols-2 gap-8">
              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <MapPin className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Local to Your Area</h3>
                      <p className="text-muted-foreground">
                        Based in southeast Lubbock, we serve Lubbock-Cooper ISD communities daily. Fast response times to Fox Ridge, Kelsey Park, Vintage Township, and surrounding neighborhoods.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Clock className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Same-Day Service</h3>
                      <p className="text-muted-foreground">
                        Emergency plumbing problems don't wait. We offer same-day service during business hours for Lubbock-Cooper residents who need immediate help.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Wrench className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Family-Owned & Faith-Based</h3>
                      <p className="text-muted-foreground">
                        We're not a franchise. We're your neighbors, serving Lubbock-Cooper families with Christian values, honesty, and integrity in every job.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Phone className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Upfront Pricing</h3>
                      <p className="text-muted-foreground">
                        No surprise fees or hidden charges. You'll know the exact price before we start any work on your Lubbock-Cooper home.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Services for Lubbock-Cooper */}
      <section className="py-16">
        <div className="container">
          <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
            Plumbing Services for Lubbock-Cooper Homes
          </h2>
          <p className="text-center text-muted-foreground mb-12 text-lg max-w-3xl mx-auto">
            From new construction in Vintage Township to older homes in the Cooper area, we handle all your plumbing needs
          </p>

          <div className="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Droplet className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Emergency Plumbing</h3>
                <p className="text-muted-foreground mb-4">
                  Burst pipes, severe leaks, and backups. Same-day emergency response for Lubbock-Cooper residents.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Flame className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Water Heaters</h3>
                <p className="text-muted-foreground mb-4">
                  Tank and tankless water heater installation and repair. Expert service for all brands and models.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Wrench className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Drain Cleaning</h3>
                <p className="text-muted-foreground mb-4">
                  Professional hydro-jetting and camera inspection to clear stubborn clogs in your Lubbock-Cooper home.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>
          </div>

          <div className="text-center mt-12">
            <a
              href="/services"
              className="inline-block bg-primary hover:bg-primary/90 text-white font-bold text-lg px-8 py-4 rounded-lg shadow-lg transition-all"
            >
              View All Services
            </a>
          </div>
        </div>
      </section>

      {/* Neighborhoods We Serve */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              Lubbock-Cooper Neighborhoods We Serve
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Proudly serving all Lubbock-Cooper ISD communities
            </p>

            <div className="grid md:grid-cols-3 gap-6">
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Fox Ridge</h3>
                <p className="text-muted-foreground text-sm">Master-planned community</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Kelsey Park</h3>
                <p className="text-muted-foreground text-sm">Family-friendly neighborhood</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Vintage Township</h3>
                <p className="text-muted-foreground text-sm">Newer homes & amenities</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Orchard Park</h3>
                <p className="text-muted-foreground text-sm">Established community</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Highland Oaks</h3>
                <p className="text-muted-foreground text-sm">Quality homes</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Meadows South</h3>
                <p className="text-muted-foreground text-sm">Growing neighborhood</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="font-heading font-bold text-3xl md:text-4xl mb-6">
              Need a Plumber in Lubbock-Cooper?
            </h2>
            <p className="text-xl mb-8 text-gray-100">
              Call Cotton City Plumbing for fast, reliable service you can trust
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE NOW
              </button>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
