import React from 'react';

const Lakeridge: React.FC = () => {
  return (
    <div className="lakeridge-landing-page">
      {/* LocalBusiness Schema Markup */}
      <script type="application/ld+json">
        {`
          {
            "@context": "http://schema.org",
            "@type": "LocalBusiness",
            "name": "Lakeridge Plumbing Services | Expert Plumbers in Lubbock, TX",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79424",
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": "33.5779",
              "longitude": "-101.8552"
            },
            "telephone": "+18064414110",
            "openingHours": "Mo-Fr 08:00-17:00",
            "priceRange": "$$"
          }
        `}
      </script>

      {/* SEO Meta Tags - Placeholder, will be added to HTML head */}
      {/* Title: Lakeridge Plumbing Services | Expert Plumbers in Lubbock, TX */}
      {/* Meta Description: Professional plumbing services in Lakeridge, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more. Serving the Lakeridge Country Club Estates and surrounding areas. */}
      {/* Keywords: Lakeridge plumbing, Lubbock plumbers, emergency plumbing Lakeridge, water heater repair Lubbock, drain cleaning Lakeridge, LakeRidge Country Club, Preston Smith Elementary */}

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to Lakeridge, Lubbock</h1>
        <p>Lakeridge is a premier, upscale neighborhood in Lubbock, Texas, known for its beautiful homes, golf course, and country club. Established in 1977, it was Lubbock’s first planned golf course community. It's a friendly community with well-kept yards, mature trees, and a serene lake, making it a desirable place to live.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us for Your Lakeridge Home?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Lakeridge's unique plumbing needs, from classic homes to modern estates near the LakeRidge Country Club.</p>
          </div>
          <div className="card">
            <h3>Prompt Service</h3>
            <p>Rapid response times for emergency plumbing issues in the Lakeridge area, ensuring minimal disruption to your peaceful community.</p>
          </div>
          <div className="card">
            <h3>Quality Workmanship</h3>
            <p>Experienced and certified plumbers delivering lasting solutions for your Lakeridge home, backed by our commitment to excellence.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Dedicated to providing exceptional service to our Lakeridge neighbors, contributing to the well-being of this safe and tranquil community.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Lakeridge</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 emergency services for burst pipes, major leaks, and urgent repairs, protecting your valuable Lakeridge property.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance of water heaters, ensuring comfort and efficiency for Lakeridge residents.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains and sewer lines, keeping your Lakeridge home's plumbing flowing smoothly and hygienically.</p>
          </div>
        </div>
      </section>

      {/* About Lakeridge Section */}
      <section className="about-lakeridge-section">
        <h2>About the Lakeridge Community</h2>
        <p>Lakeridge, located in southwest Lubbock between 82nd and 98th Streets, is a highly sought-after neighborhood. It is home to the prestigious LakeRidge Country Club, offering an 18-hole championship golf course, tennis courts, and swimming facilities. The community is known for its low crime rate and excellent schools, including Preston Smith Elementary, Irons Middle School, and Coronado High School, making it ideal for families and professionals alike.</p>
        <p>With beautifully landscaped streets and spacious properties, Lakeridge provides a serene and upscale living experience. Residents enjoy proximity to local businesses, dining, and shopping along 82nd and 98th, including grocery options like Sprouts Farmers Market. Jan Jennings Park also offers nearby recreational opportunities with volleyball courts and a fishing pond.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Services in Lakeridge?</h2>
        <p>Call us today for reliable and professional plumbing solutions tailored to the Lakeridge community!</p>
        <p>Phone: <a href="tel:+18064414110">(806) 441-4110</a></p>
        <button className="housecall-pro-button">Book Now with Housecall Pro</button>
      </section>
    </div>
  );
};

export default Lakeridge;
