import React from 'react';
import { Helmet } from 'react-helmet-async';

// Assuming a shared styling solution, e.g., a CSS module or a styled-components file
// import styles from './NeighborhoodPage.module.css'; 
// import { Container, Hero, Section, Card, CTAButton } from '../components/UI'; // Example UI components

const JacksonMahon: React.FC = () => {
  const neighborhoodName = 'Jackson-Mahon';
  const description = 'Jackson-Mahon is a vibrant, family-friendly neighborhood in North Lubbock, Texas, known for its strong community roots and convenient access to local amenities. With a rich history and a focus on residential living, it offers a welcoming environment for families.';
  const phone = '(806) 441-4110';
  const bookingLink = 'https://www.housecallpro.com/book/your-company'; // Placeholder

  return (
    <div className="neighborhood-page">
      <Helmet>
        <title>{`Plumbing Services in ${neighborhoodName}, Lubbock TX`}</title>
        <meta name="description" content={`Expert plumbing services for the ${neighborhoodName} neighborhood in Lubbock, Texas. From emergency repairs to water heater installations, we're your local trusted plumbers.`} />
        <meta name="keywords" content={`plumbing ${neighborhoodName}, plumber Lubbock ${neighborhoodName}, emergency plumbing ${neighborhoodName}, water heater ${neighborhoodName}, drain cleaning ${neighborhoodName}`} />
        <script type="application/ld+json">
          {`
            {
              "@context": "http://schema.org",
              "@type": "LocalBusiness",
              "name": "[Your Company Name] Plumbing",
              "address": {
                "@type": "PostalAddress",
                "streetAddress": "[Your Street Address]",
                "addressLocality": "Lubbock",
                "addressRegion": "TX",
                "postalCode": "[Your Postal Code]"
              },
              "geo": {
                "@type": "GeoCoordinates",
                "latitude": "33.5779",
                "longitude": "-101.8552"
              },
              "url": "[Your Website URL]/${neighborhoodName.toLowerCase().replace(/ /g, '-')}",
              "telephone": "+18064414110",
              "openingHours": "Mo-Fr 08:00-17:00",
              "priceRange": "$$"
            }
          `}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to {neighborhoodName}</h1>
        <p>{description}</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in {neighborhoodName}?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of {neighborhoodName}'s unique plumbing needs and infrastructure.</p>
          </div>
          <div className="card">
            <h3>Prompt Service</h3>
            <p>Rapid response times for all your plumbing emergencies in the {neighborhoodName} area.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Certified and experienced plumbers dedicated to serving the {neighborhoodName} community.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Proudly serving {neighborhoodName} residents with integrity and quality workmanship.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in {neighborhoodName}</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 emergency plumbing services for burst pipes, major leaks, and urgent repairs in {neighborhoodName}.</p>
          </div>
          <div className="card">
            <h3>Water Heater Repair & Installation</h3>
            <p>Expert water heater services, from routine maintenance to new installations, for homes in {neighborhoodName}.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Thorough drain cleaning to clear blockages and restore proper flow in your {neighborhoodName} home's plumbing system.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About {neighborhoodName}</h2>
        <p>
          {neighborhoodName} is a historic and close-knit community located in North Lubbock. It is characterized by its predominantly single-family homes and a strong sense of local identity. The neighborhood is served by the Lubbock Independent School District, with local schools being a key attraction for families. Recent developments, including the new elementary school built on the site of the former Mahon Elementary, underscore the community's commitment to education. The area has also seen collaborative efforts with the Texas Tech School of Architecture, aiming to foster unique and affordable development within its bounds. Its roots in the city precede much of Lubbock's recent economic growth, giving it a unique charm and established feel.
        </p>
        <p>
          Residents of {neighborhoodName} enjoy convenient access to various local amenities and a peaceful suburban atmosphere. Its strategic location in North Lubbock provides easy connectivity to the wider city while maintaining a distinct neighborhood character. The community's rich heritage and ongoing revitalization efforts make it a desirable place to live and work.
        </p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Services in {neighborhoodName}?</h2>
        <p>Call us today for reliable and professional plumbing solutions!</p>
        <p className="phone-number">{phone}</p>
        <a href={bookingLink} target="_blank" rel="noopener noreferrer" className="cta-button">
          Book Now with Housecall Pro
        </a>
      </section>
    </div>
  );
};

export default JacksonMahon;
