import React from 'react';

const Harwell: React.FC = () => {
  const neighborhoodName = "Harwell";
  const description = "Harwell is a quiet, residential neighborhood in Lubbock, Texas, known for its affordable housing and family-friendly atmosphere. It features traditional home styles and is conveniently located with easy access to I-27.";
  const keywords = "Harwell Lubbock, Lubbock neighborhoods, Harwell homes, Harwell real estate, family-friendly Lubbock, affordable housing Lubbock";
  const geoCoordinates = "33.5779, -101.8552";
  const phoneNumber = "(806) 441-4110";

  return (
    <>
      {/* SEO */} 
      <title>{`Plumbing Services in ${neighborhoodName}, Lubbock, TX`}</title>
      <meta name="description" content={description} />
      <meta name="keywords" content={keywords} />

      {/* LocalBusiness Schema Markup */}
      <script type="application/ld+json">
        {`
          {
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "[Your Company Name] Plumbing Services - ${neighborhoodName}",
            "address": {
              "@type": "PostalAddress",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79404", // Approximate for Lubbock
              "streetAddress": ""
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": ${geoCoordinates.split(',')[0].trim()},
              "longitude": ${geoCoordinates.split(',')[1].trim()}
            },
            "url": "[Your Company Website URL]/${neighborhoodName.toLowerCase().replace(/ /g, '-')}",
            "telephone": "${phoneNumber}",
            "openingHoursSpecification": [
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": [
                  "Monday",
                  "Tuesday",
                  "Wednesday",
                  "Thursday",
                  "Friday",
                  "Saturday",
                  "Sunday"
                ],
                "opens": "00:00",
                "closes": "23:59"
              }
            ],
            "priceRange": "$$"
          }
        `}
      </script>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>{`Expert Plumbing Services in ${neighborhoodName}, Lubbock, TX`}
        </h1>
        <p>{description}</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in {neighborhoodName}?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of {neighborhoodName} plumbing needs.</p>
          </div>
          <div className="card">
            <h3>Rapid Response</h3>
            <p>Quick and efficient service for {neighborhoodName} residents.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Experienced and certified plumbers serving {neighborhoodName}.</p>
          </div>
          <div className="card">
            <h3>24/7 Availability</h3>
            <p>Emergency plumbing services for {neighborhoodName} around the clock.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in {neighborhoodName}</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>Fast and reliable emergency plumbing solutions for {neighborhoodName} homes.</p>
          </div>
          <div className="card">
            <h3>Water Heaters</h3>
            <p>Installation, repair, and maintenance of water heaters in {neighborhoodName}.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Professional drain cleaning to keep your {neighborhoodName} pipes clear.</p>
          </div>
        </div>
      </section>

      {/* About [Neighborhood] Section */}
      <section className="about-neighborhood-section">
        <h2>About {neighborhoodName}</h2>
        <p>
          The {neighborhoodName} neighborhood in Lubbock, TX, offers a unique blend of affordability and community spirit. 
          Known for its traditional home styles, many residences were built between 1940 and 1969, giving the area a well-established feel. 
          Harwell Elementary School, a public school with a Gifted & Talented program, serves the community. 
          Residents enjoy a short commute to work, with over half of the working population spending less than fifteen minutes traveling. 
          The neighborhood is bordered by I-27, providing easy access to other parts of Lubbock. 
          Harwell is a quiet, residential area, making it an ideal place for families seeking a peaceful environment with convenient amenities.
        </p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Services in {neighborhoodName}?</h2>
        <p>Call us today for reliable and professional plumbing solutions!</p>
        <a href={`tel:${phoneNumber.replace(/[^0-9]/g, '')}`} className="phone-button">{phoneNumber}</a>
        <a href="#" className="booking-button">Book Now with Housecall Pro</a>
      </section>
    </>
  );
};

export default Harwell;
