import React from 'react';

const Guadalupe: React.FC = () => {
  // LocalBusiness Schema Markup
  const schemaMarkup = {
    '@context': 'http://schema.org',
    '@type': 'LocalBusiness',
    'name': 'Housecall Pro Plumbing Services - Guadalupe Lubbock',
    'address': {
      '@type': 'PostalAddress',
      'streetAddress': 'Serving Guadalupe Neighborhood',
      'addressLocality': 'Lubbock',
      'addressRegion': 'TX',
      'postalCode': '79401',
      'addressCountry': 'US'
    },
    'geo': {
      '@type': 'GeoCoordinates',
      'latitude': '33.5779',
      'longitude': '-101.8552'
    },
    'url': 'https://www.housecallpro.com/guadalupe-lubbock-plumbing',
    'telephone': '+18064414110',
    'openingHoursSpecification': [
      {
        '@type': 'OpeningHoursSpecification',
        'dayOfWeek': [
          'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'
        ],
        'opens': '00:00',
        'closes': '23:59'
      }
    ],
    'priceRange': '$$',
    'image': 'URL_TO_HERO_IMAGE_FOR_GUADALUPE',
    'description': 'Expert plumbing services in Guadalupe, Lubbock, TX, including emergency plumbing, water heater repair, and drain cleaning.'
  };

  return (
    <div className="guadalupe-landing-page">
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{ __html: JSON.stringify(schemaMarkup) }}
      />

      {/* SEO Meta Tags (will be dynamically inserted in the actual implementation) */}
      {/* Title: Plumbing Services in Guadalupe, Lubbock TX | [Company Name] */}
      {/* Meta Description: Expert emergency plumbing, water heater repair, and drain cleaning services in Guadalupe, Lubbock, TX. Local and reliable. */}
      {/* Keywords: Guadalupe plumbing, Lubbock plumbing, emergency plumbing Guadalupe, water heater repair Guadalupe, drain cleaning Guadalupe, plumber Guadalupe */}

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Guadalupe Plumbing Services</h1>
        <p>Your trusted local plumbers serving the historic Guadalupe neighborhood in Lubbock, TX. We're here for all your plumbing needs, from routine maintenance to emergency repairs.</p>
        {/* Add image/background specific to Guadalupe */}
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in Guadalupe?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Guadalupe's unique plumbing infrastructure and community needs.</p>
          </div>
          <div className="card">
            <h3>Rapid Response</h3>
            <p>Quick and efficient service to the Guadalupe area, minimizing disruption to your home.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Experienced and certified plumbers dedicated to quality service in your neighborhood.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Proud to serve the resilient and vibrant Guadalupe community, from Aztlan Park to Carmona-Harrison Elementary.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Guadalupe</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 emergency services for burst pipes, severe leaks, and unexpected plumbing failures in Guadalupe.</p>
          </div>
          <div className="card">
            <h3>Water Heaters</h3>
            <p>Installation, repair, and maintenance of all types of water heaters for Guadalupe homes.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains and sewer lines, keeping Guadalupe's plumbing flowing smoothly.</p>
          </div>
        </div>
      </section>

      {/* About Guadalupe Section */}
      <section className="about-neighborhood-section">
        <h2>About Guadalupe, Lubbock TX</h2>
        <p>The Guadalupe neighborhood is a historic and resilient community in Lubbock, Texas, known for its rich Hispanic heritage and strong family ties. Located just a mile north of downtown, Guadalupe offers convenient access to major highways like I-27 and the Marsha Sharpe Freeway. The area is home to notable landmarks such as Aztlan Park, featuring a historical mural, and is bordered by the expansive Mackenzie Park. Educational institutions include the innovative Carmona-Harrison Elementary, Cavazos Middle School, and Lubbock High School. Residents enjoy local culinary delights from La Malinche Tortilla Factory and La Super Economica Meat Market, reflecting the neighborhood's vibrant culture. Despite facing challenges, including the devastating 1970 tornado, Guadalupe has rebuilt into a thriving community that values its past while embracing new opportunities. The annual Vamos a Pescar event at Buddy Holly Lake further highlights the community's spirit and family-oriented activities.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Service in Guadalupe?</h2>
        <p>Call us today for reliable and professional plumbing solutions!</p>
        <p className="phone-number">(806) 441-4110</p>
        <button className="housecall-pro-button">Book Now with Housecall Pro</button>
      </section>
    </div>
  );
};

export default Guadalupe;
