
import React from 'react';
import { Helmet } from 'react-helmet-async';

const Frenship: React.FC = () => {
  const schemaMarkup = {
    '@context': 'http://schema.org',
    '@type': 'LocalBusiness',
    'name': 'Lubbock Plumbing Services',
    'address': {
      '@type': 'PostalAddress',
      'streetAddress': 'Approximate Lubbock Area',
      'addressLocality': 'Lubbock',
      'addressRegion': 'TX',
      'postalCode': '79401', // Approximate postal code for Lubbock
      'addressCountry': 'US'
    },
    'geo': {
      '@type': 'GeoCoordinates',
      'latitude': 33.5779,
      'longitude': -101.8552
    },
    'telephone': '(806) 441-4110',
    'url': 'https://yourwebsite.com/frenship', // Placeholder, update with actual URL
    'openingHours': 'Mo-Fr 08:00-17:00', // Example, adjust as needed
    'priceRange': '$$'
  };

  return (
    <div className="frenship-landing-page">
      <Helmet>
        <title>Frenship Lubbock Plumbing Services | Expert Plumbers for Your Home</title>
        <meta name="description" content="Discover reliable plumbing services in Frenship, Lubbock. From emergency repairs to water heater installations, our expert team serves the family-oriented Frenship community with quality and care." />
        <meta name="keywords" content="Frenship plumbing, Lubbock plumbers, Frenship emergency plumbing, water heater Frenship, drain cleaning Frenship, Frenship ISD, Lubbock home services" />
        <script type="application/ld+json">
          {JSON.stringify(schemaMarkup)}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section bg-black text-white py-20">
        <div className="container mx-auto text-center">
          <h1 className="text-5xl font-bold mb-4">Frenship</h1>
          <p className="text-xl">
            Welcome to Frenship, a vibrant and family-oriented community in Lubbock, Texas, known for its exceptional schools and strong community spirit. Our dedicated plumbing services are proud to support Frenship homes, ensuring comfort and peace of mind for every resident.
          </p>
        </div>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section py-16 bg-gray-100">
        <div className="container mx-auto text-center">
          <h2 className="text-4xl font-bold mb-12">Why Choose Us</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="card p-6 bg-white shadow-lg rounded-lg">
              <h3 className="text-2xl font-semibold mb-4">Local Expertise</h3>
              <p>As part of the Lubbock community, we understand the unique plumbing needs of Frenship homes, offering tailored solutions with a local touch.</p>
            </div>
            <div className="card p-6 bg-white shadow-lg rounded-lg">
              <h3 className="text-2xl font-semibold mb-4">Family-Focused Service</h3>
              <p>We prioritize the safety and comfort of your family, providing reliable and efficient plumbing services that respect your home and schedule.</p>
            </div>
            <div className="card p-6 bg-white shadow-lg rounded-lg">
              <h3 className="text-2xl font-semibold mb-4">Advanced Solutions</h3>
              <p>Utilizing the latest plumbing technology, we deliver effective and lasting solutions for everything from routine maintenance to complex installations.</p>
            </div>
            <div className="card p-6 bg-white shadow-lg rounded-lg">
              <h3 className="text-2xl font-semibold mb-4">Community Commitment</h3>
              <p>We are committed to the well-being of the Frenship community, offering transparent pricing and dependable service you can trust.</p>
            </div>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section py-16 bg-white">
        <div className="container mx-auto text-center">
          <h2 className="text-4xl font-bold mb-12">Our Services</h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="card p-6 bg-gray-100 shadow-lg rounded-lg">
              <h3 className="text-2xl font-semibold mb-4">Emergency Plumbing</h3>
              <p>Available 24/7 for urgent plumbing issues, ensuring rapid response to protect your Frenship home from unexpected leaks or bursts.</p>
            </div>
            <div className="card p-6 bg-gray-100 shadow-lg rounded-lg">
              <h3 className="text-2xl font-semibold mb-4">Water Heater Services</h3>
              <p>Expert installation, repair, and maintenance for all types of water heaters, keeping your family in Frenship supplied with hot water.</p>
            </div>
            <div className="card p-6 bg-gray-100 shadow-lg rounded-lg">
              <h3 className="text-2xl font-semibold mb-4">Drain Cleaning</h3>
              <p>Professional drain cleaning services to clear blockages and restore proper flow, preventing future plumbing problems in your home.</p>
            </div>
          </div>
        </div>
      </section>

      {/* About Frenship Section */}
      <section className="about-frenship-section py-16 bg-gray-100">
        <div className="container mx-auto text-center">
          <h2 className="text-4xl font-bold mb-12">About the Frenship Community</h2>
          <p className="text-lg">
            The Frenship area, centered around the highly-regarded Frenship Independent School District (ISD), offers a unique blend of small-town charm and convenient access to Lubbock city amenities. Known for its tradition of excellence and high expectations, Frenship ISD is a cornerstone of the community, boasting top-ranked schools like Oak Ridge Elementary and the new Frenship Memorial High School. Residents enjoy a family-friendly environment with numerous educational and extracurricular opportunities. Our services are tailored to meet the needs of this thriving community, ensuring that every home benefits from reliable and efficient plumbing.
          </p>
        </div>
      </section>

      {/* CTA Section */}
      <section className="cta-section bg-black text-white py-20">
        <div className="container mx-auto text-center">
          <h2 className="text-4xl font-bold mb-8">Ready for Reliable Plumbing?</h2>
          <p className="text-2xl mb-4">Call Us Today: (806) 441-4110</p>
          <a
            href="https://www.housecallpro.com/book/your-company-name" // Placeholder, update with actual Housecall Pro booking link
            target="_blank"
            rel="noopener noreferrer"
            className="bg-red-600 hover:bg-red-700 text-white font-bold py-4 px-8 rounded-full text-xl transition duration-300"
          >
            Book Now with Housecall Pro
          </a>
        </div>
      </section>
    </div>
  );
};

export default Frenship;
