import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Check, DollarSign, Calendar, CreditCard, HelpCircle, Shield, Clock } from "lucide-react";

export default function Financing() {
  const faqs = [
    {
      question: "Will checking my rate affect my credit score?",
      answer: "No. Pre-qualifying through Acorn Finance uses a soft credit inquiry, which does not impact your credit score. Only when you formally apply with a lender will a hard credit check be performed."
    },
    {
      question: "What can I use financing for?",
      answer: "Our financing can be used for any plumbing service, including emergency repairs, water heater installations, sewer line replacements, whole-home repiping, bathroom remodels, water treatment systems, and more."
    },
    {
      question: "How quickly can I get approved?",
      answer: "Most customers receive personalized offers within minutes of submitting their pre-qualification form. Once you choose a lender and complete the application, funds are typically available within 1-2 business days."
    },
    {
      question: "What credit score do I need?",
      answer: "Acorn Finance works with multiple lenders who have different credit requirements. While higher credit scores typically receive better rates, options are available for a range of credit profiles."
    },
    {
      question: "Are there any prepayment penalties?",
      answer: "Most lenders in the Acorn Finance network do not charge prepayment penalties, but terms vary by lender. You can review all terms before accepting an offer."
    },
    {
      question: "Can I finance if I'm a renter?",
      answer: "Yes. Financing is available to both homeowners and renters. However, if you're renting, we recommend getting approval from your landlord before proceeding with major plumbing work."
    }
  ];

  const commonProjects = [
    { service: "Tank Water Heater Installation", typical: "$1,600", monthly: "$45/mo*" },
    { service: "Tankless Water Heater Installation", typical: "$4,900", monthly: "$137/mo*" },
    { service: "Sewer Line Replacement", typical: "$5,000 - $15,000", monthly: "$140 - $420/mo*" },
    { service: "Whole-Home Repiping", typical: "$4,000 - $12,000", monthly: "$112 - $335/mo*" },
    { service: "Water Treatment System", typical: "$2,000 - $5,000", monthly: "$56 - $140/mo*" },
    { service: "Emergency Plumbing Repair", typical: "$500 - $2,000", monthly: "$14 - $56/mo*" }
  ];

  return (
    <Layout>
      <SEO 
        title="Plumbing Financing in Lubbock | Cotton City Plumbing"
        description="Get the plumbing repairs you need now and pay over time. Cotton City Plumbing offers flexible financing options through Acorn Finance. Check your rates today!"
        canonical="/financing"
      />
      <section className="bg-primary text-white py-16">
        <div className="container text-center">
          <h1 className="font-heading font-extrabold text-4xl md:text-6xl mb-4 uppercase italic">Flexible Financing Options</h1>
          <p className="text-xl text-primary-foreground/90 max-w-2xl mx-auto">
            Get the plumbing services you need today and pay over time with our trusted partner, Acorn Finance.
          </p>
        </div>
      </section>

      <section className="py-16 bg-background">
        <div className="container">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-16">
            <div className="space-y-6">
              <h2 className="font-heading font-bold text-3xl text-primary uppercase italic">Don't Let Budget Hold You Back</h2>
              <p className="text-lg text-muted-foreground leading-relaxed">
                Plumbing emergencies often happen at the worst times. Whether you need a new water heater, a sewer line replacement, or a major bathroom remodel, you shouldn't have to compromise on quality or delay necessary repairs.
              </p>
              <p className="text-lg text-muted-foreground leading-relaxed">
                Cotton City Plumbing partners with <strong>Acorn Finance</strong> to offer a simple, transparent way to check rates from multiple lenders without impacting your credit score. With quick approvals and competitive rates, you can get your home back in working order now and pay over time.
              </p>
              
              <div className="grid grid-cols-1 sm:grid-cols-2 gap-4 pt-4">
                {[
                  "Check Rates Without Impacting Credit",
                  "Compare Offers from Top Lenders",
                  "Loans up to $100,000",
                  "Terms up to 12 Years",
                  "APR as low as 6.99%",
                  "Funds in as little as 1-2 days"
                ].map((item, i) => (
                  <div key={i} className="flex items-center gap-3">
                    <div className="bg-secondary/10 p-1 rounded-full">
                      <Check className="h-4 w-4 text-secondary" />
                    </div>
                    <span className="font-medium">{item}</span>
                  </div>
                ))}
              </div>
            </div>
            
            <div className="bg-muted/30 p-8 rounded-2xl border border-border">
              <h3 className="font-heading font-bold text-2xl text-primary mb-6 text-center uppercase italic">How It Works</h3>
              <div className="space-y-6">
                {[
                  {
                    icon: <Calendar className="h-6 w-6" />,
                    title: "1. Pre-Qualify in Minutes",
                    desc: "Submit a simple online form to see your personalized offers. No impact to your credit score."
                  },
                  {
                    icon: <Check className="h-6 w-6" />,
                    title: "2. Compare Your Options",
                    desc: "Review offers from multiple national lenders to find the best rate and monthly payment for you."
                  },
                  {
                    icon: <DollarSign className="h-6 w-6" />,
                    title: "3. Get Funded",
                    desc: "Complete your application with the lender and receive funds directly, often within 24 hours."
                  },
                  {
                    icon: <CreditCard className="h-6 w-6" />,
                    title: "4. Pay Over Time",
                    desc: "Make fixed monthly payments to the lender while we complete your plumbing project."
                  }
                ].map((step, index) => (
                  <div key={index} className="flex gap-4">
                    <div className="flex-shrink-0 w-12 h-12 rounded-full bg-white border-2 border-primary text-primary flex items-center justify-center shadow-sm">
                      {step.icon}
                    </div>
                    <div>
                      <h4 className="font-bold text-lg text-primary">{step.title}</h4>
                      <p className="text-sm text-muted-foreground">{step.desc}</p>
                    </div>
                  </div>
                ))}
              </div>
            </div>
          </div>

          {/* Payment Examples Section */}
          <div className="mb-16">
            <div className="text-center mb-8">
              <h2 className="font-heading font-bold text-3xl text-primary mb-3 uppercase italic">Estimated Monthly Payments</h2>
              <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
                See what your monthly payment could look like for common plumbing projects. Actual rates and terms vary based on creditworthiness and lender.
              </p>
            </div>

            <Card className="overflow-hidden">
              <CardContent className="p-0">
                <div className="overflow-x-auto">
                  <table className="w-full">
                    <thead>
                      <tr className="bg-primary text-white">
                        <th className="text-left py-4 px-6 font-heading font-bold uppercase">Service</th>
                        <th className="text-left py-4 px-6 font-heading font-bold uppercase">Typical Cost</th>
                        <th className="text-left py-4 px-6 font-heading font-bold uppercase">Est. Monthly Payment</th>
                      </tr>
                    </thead>
                    <tbody>
                      {commonProjects.map((project, index) => (
                        <tr key={index} className={index % 2 === 0 ? "bg-white" : "bg-gray-50"}>
                          <td className="py-4 px-6 font-medium text-gray-900">{project.service}</td>
                          <td className="py-4 px-6 text-gray-700">{project.typical}</td>
                          <td className="py-4 px-6 font-bold text-primary">{project.monthly}</td>
                        </tr>
                      ))}
                    </tbody>
                  </table>
                </div>
                <div className="bg-gray-50 px-6 py-4 border-t border-gray-200">
                  <p className="text-xs text-muted-foreground">
                    *Example based on 36-month term at 9.99% APR. Your actual rate, payment, and terms may vary based on credit approval and lender. Rates as low as 6.99% APR available for qualified borrowers.
                  </p>
                </div>
              </CardContent>
            </Card>
          </div>

          {/* Why Finance Section */}
          <div className="mb-16 bg-yellow-50 p-8 md:p-12 rounded-2xl">
            <h2 className="font-heading font-bold text-3xl text-primary mb-8 text-center uppercase italic">Why Finance Your Plumbing Project?</h2>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              <div className="text-center">
                <div className="bg-white w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4 shadow-md">
                  <Shield className="h-8 w-8 text-primary" />
                </div>
                <h3 className="font-heading font-bold text-xl text-gray-900 mb-3">Protect Your Home</h3>
                <p className="text-gray-700">
                  Don't delay critical repairs that could lead to water damage, mold, or structural issues. Financing lets you act immediately to protect your biggest investment.
                </p>
              </div>
              <div className="text-center">
                <div className="bg-white w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4 shadow-md">
                  <DollarSign className="h-8 w-8 text-primary" />
                </div>
                <h3 className="font-heading font-bold text-xl text-gray-900 mb-3">Preserve Your Savings</h3>
                <p className="text-gray-700">
                  Keep your emergency fund intact for true emergencies. Financing allows you to spread the cost over time while maintaining financial flexibility.
                </p>
              </div>
              <div className="text-center">
                <div className="bg-white w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4 shadow-md">
                  <Clock className="h-8 w-8 text-primary" />
                </div>
                <h3 className="font-heading font-bold text-xl text-gray-900 mb-3">Upgrade Sooner</h3>
                <p className="text-gray-700">
                  Invest in energy-efficient upgrades like tankless water heaters or whole-home water treatment systems that pay for themselves over time through lower utility bills.
                </p>
              </div>
            </div>
          </div>

          {/* FAQ Section */}
          <div className="mb-16">
            <div className="text-center mb-8">
              <h2 className="font-heading font-bold text-3xl text-primary mb-3 uppercase italic">Financing FAQs</h2>
              <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
                Common questions about our financing options
              </p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-5xl mx-auto">
              {faqs.map((faq, index) => (
                <Card key={index} className="bg-white">
                  <CardContent className="p-6">
                    <div className="flex gap-3 mb-3">
                      <HelpCircle className="h-5 w-5 text-primary flex-shrink-0 mt-1" />
                      <h3 className="font-bold text-lg text-gray-900">{faq.question}</h3>
                    </div>
                    <p className="text-gray-700 ml-8">{faq.answer}</p>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>

          {/* CTA Section */}
          <div className="text-center bg-[#006C45]/5 py-12 rounded-3xl border border-[#006C45]/20">
            <div className="flex justify-center mb-6">
               <div className="text-3xl font-bold text-[#006C45] flex items-center gap-2">
                 <span className="bg-[#006C45] text-white px-2 py-1 rounded">Acorn</span> Finance
               </div>
            </div>
            <h2 className="font-heading font-bold text-3xl text-primary mb-4 uppercase italic">Ready to Check Your Rates?</h2>
            <p className="text-lg text-muted-foreground max-w-2xl mx-auto mb-8">
              See what you qualify for in seconds. It's free, secure, and won't affect your credit score.
            </p>
            <div className="flex flex-col items-center justify-center gap-6">
              {/* Acorn Finance Banner */}
              <a 
                href="https://www.acornfinance.com/pre-qualify/?d=55ME9&utm_medium=web_pre_qual_banner" 
                target="_blank" 
                rel="noopener noreferrer"
                className="hover:opacity-95 transition-opacity"
              >
                <img 
                  id="acornBanner" 
                  style={{ margin: '10px', padding: '1px', border: '1px solid black', borderRadius: '5px' }} 
                  src="https://fs.acornfinance.com/banners/acorn-finance-banner-easy-payment-options-vertical-large.png" 
                  alt="Acorn Finance apply and get affordable payment options from multiple lenders" 
                />
              </a>
              
              <a href="tel:8064414110">
                <Button size="lg" variant="outline" className="border-2 border-primary text-primary hover:bg-primary hover:text-white font-bold text-lg px-10 py-6">
                  Call for Details
                </Button>
              </a>
            </div>
            <p className="mt-6 text-xs text-muted-foreground max-w-3xl mx-auto px-4">
              *Acorn Finance is not a lender but a partner that connects borrowers with lenders. Offers are subject to credit approval. Rates and terms vary by lender.
            </p>
          </div>
        </div>
      </section>
    </Layout>
  );
}
