import { Helmet } from "react-helmet-async";
import Layout from "../components/Layout";
import { Phone, MapPin, Clock, Wrench, Droplet, Flame, Home } from "lucide-react";
import { Card, CardContent } from "../components/ui/card";

export default function DavisPark() {
  return (
    <Layout>
      <Helmet>
        <title>Davis Park Plumber Lubbock | Luxury Home Plumbing | Cotton City Plumbing</title>
        <meta name="description" content="Trusted plumber serving Davis Park luxury neighborhood in southwest Lubbock. Expert plumbing services for custom homes on South Slide Road. Same-day service available." />
        <meta name="keywords" content="Davis Park plumber, plumber near Davis Park Lubbock, southwest Lubbock plumber, luxury home plumbing, South Slide Road plumber" />
        <script type="application/ld+json">
          {JSON.stringify({
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "@id": "https://cottoncityplumbing.com/areas/davis-park",
            "name": "Cotton City Plumbing - Davis Park Service Area",
            "image": "https://cottoncityplumbing.com/images/van.jpg",
            "telephone": "+18064414110",
            "email": "services@cottoncityplumbing.com",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "1306 146th Street",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79423",
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.4619721,
              "longitude": -101.8497587
            },
            "url": "https://cottoncityplumbing.com/areas/davis-park",
            "priceRange": "$$",
            "openingHoursSpecification": [
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
                "opens": "07:00",
                "closes": "19:00"
              },
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": "Saturday",
                "opens": "08:00",
                "closes": "12:00"
              }
            ],
            "areaServed": [
              {
                "@type": "Place",
                "name": "Davis Park",
                "containedInPlace": {
                  "@type": "City",
                  "name": "Lubbock",
                  "@id": "https://en.wikipedia.org/wiki/Lubbock,_Texas"
                }
              }
            ],
            "hasOfferCatalog": {
              "@type": "OfferCatalog",
              "name": "Plumbing Services",
              "itemListElement": [
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Emergency Plumbing"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Water Heater Installation"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Luxury Home Plumbing"
                  }
                }
              ]
            }
          })}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-black via-gray-900 to-black text-white py-20 relative overflow-hidden">
        <div className="absolute inset-0 opacity-10">
          <div className="absolute inset-0 bg-[url('/images/texture.png')] bg-repeat"></div>
        </div>
        
        <div className="container relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              <span className="text-secondary">Davis Park</span> Luxury Home Plumber
            </h1>
            <p className="text-xl md:text-2xl text-gray-300 mb-8">
              Expert plumbing services for Davis Park's luxury custom homes in southwest Lubbock
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE
              </button>
            </div>
          </div>
        </div>
      </section>

      {/* Why Choose Us */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              Why Davis Park Homeowners Choose Us
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Serving Davis Park's luxury homes with professional plumbing expertise
            </p>

            <div className="grid md:grid-cols-2 gap-8">
              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Home className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Luxury Home Specialists</h3>
                      <p className="text-muted-foreground">
                        We understand the high-end plumbing systems and fixtures in Davis Park's custom luxury homes built by Lubbock's top builders.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Clock className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Same-Day Emergency Service</h3>
                      <p className="text-muted-foreground">
                        Plumbing emergencies in luxury homes require immediate expert attention. We offer same-day service during business hours.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <MapPin className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Southwest Lubbock Experts</h3>
                      <p className="text-muted-foreground">
                        We serve Davis Park and the surrounding South Slide Road area with fast response times and local expertise.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Wrench className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Licensed & Insured M-44446</h3>
                      <p className="text-muted-foreground">
                        Fully licensed, insured, and bonded. We protect your luxury investment with professional workmanship and accountability.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Services */}
      <section className="py-16">
        <div className="container">
          <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
            Plumbing Services for Davis Park Luxury Homes
          </h2>
          <p className="text-center text-muted-foreground mb-12 text-lg max-w-3xl mx-auto">
            From high-end fixtures to complex systems, we handle all your luxury home plumbing needs
          </p>

          <div className="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Droplet className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Emergency Plumbing</h3>
                <p className="text-muted-foreground mb-4">
                  Fast response for burst pipes, water heater failures, and plumbing emergencies in Davis Park homes.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Flame className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Tankless Water Heaters</h3>
                <p className="text-muted-foreground mb-4">
                  Installation and service of high-efficiency tankless systems perfect for luxury homes.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Wrench className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Luxury Fixture Installation</h3>
                <p className="text-muted-foreground mb-4">
                  Expert installation of high-end faucets, fixtures, and plumbing systems for Davis Park estates.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>
          </div>

          <div className="text-center mt-12">
            <a
              href="/services"
              className="inline-block bg-primary hover:bg-primary/90 text-white font-bold text-lg px-8 py-4 rounded-lg shadow-lg transition-all"
            >
              View All Services
            </a>
          </div>
        </div>
      </section>

      {/* About Davis Park */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              About Davis Park
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Luxury custom home community in southwest Lubbock
            </p>

            <div className="bg-white p-8 rounded-lg shadow-lg">
              <div className="grid md:grid-cols-2 gap-8">
                <div>
                  <h3 className="font-bold text-xl mb-4 text-primary">Community Features</h3>
                  <ul className="space-y-3 text-muted-foreground">
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Luxury custom home lots</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Top builders in Lubbock area</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Unique architectural designs</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>High-end finishes and features</span>
                    </li>
                  </ul>
                </div>
                <div>
                  <h3 className="font-bold text-xl mb-4 text-primary">Location Benefits</h3>
                  <ul className="space-y-3 text-muted-foreground">
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>South Slide Road location</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Southwest Lubbock convenience</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Close to shopping & dining</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Excellent school access</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="font-heading font-bold text-3xl md:text-4xl mb-6">
              Need a Plumber in Davis Park?
            </h2>
            <p className="text-xl mb-8 text-gray-100">
              Call Cotton City Plumbing for expert luxury home plumbing service
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE NOW
              </button>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
