import React from 'react';

const Coronado: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProLink = '#'; // Placeholder for Housecall Pro booking link

  const schemaMarkup = {
    "@context": "http://schema.org",
    "@type": "LocalBusiness",
    "name": "[Your Company Name] Plumbing Services - Coronado Lubbock",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "[Your Street Address]",
      "addressLocality": "Lubbock",
      "addressRegion": "TX",
      "postalCode": "[Your Postal Code]",
      "addressCountry": "US"
    },
    "geo": {
      "@type": "GeoCoordinates",
      "latitude": 33.5779,
      "longitude": -101.8552
    },
    "url": "[Your Website URL for Coronado Page]",
    "telephone": "+18064414110",
    "openingHoursSpecification": [
      {
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday",
          "Saturday",
          "Sunday"
        ],
        "opens": "00:00",
        "closes": "23:59"
      }
    ],
    "hasMap": "[Link to Google Maps for your business]",
    "description": "Expert plumbing services for the Coronado neighborhood in Lubbock, TX, specializing in emergency repairs, water heaters, and drain cleaning.",
    "pricelRange": "$$"
  };

  return (
    <div className="coronado-landing-page" style={styles.container}>
      {/* SEO Meta Tags - In a real application, this would be handled by React Helmet or similar */}
      <Helmet>
        <title>Coronado Neighborhood Lubbock TX - Expert Plumbing Services</title>
        <meta name="description" content="Discover top-rated plumbing services in Coronado, Lubbock, TX. From emergency repairs to water heater installations, we serve the Coronado High School area and surrounding community with reliable and efficient solutions." />
        <meta name="keywords" content="Coronado Lubbock, Coronado TX, Lubbock plumbing, Coronado High School, plumbing services Coronado, emergency plumbing Lubbock, water heater repair Coronado, drain cleaning Lubbock" />
        <script type="application/ld+json">
          {JSON.stringify(schemaMarkup)}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section style={{...styles.section, ...styles.heroSection}}>
        <h1 style={styles.heroTitle}>Coronado</h1>
        <p style={styles.heroDescription}>
          Welcome to Coronado, a vibrant and established neighborhood in Lubbock, Texas, known for its strong community spirit and excellent educational opportunities, particularly around Coronado High School. Located conveniently close to Texas Tech University and downtown Lubbock, Coronado offers a perfect blend of suburban tranquility and urban accessibility. Our plumbing services are proud to support the homes and businesses within this dynamic community.
        </p>
      </section>

      {/* Why Choose Us Section */}
      <section style={styles.section}>
        <h2 style={styles.sectionTitle}>Why Choose Us</h2>
        <div style={styles.cardContainer}>
          <div style={styles.card}>
            <h3 style={styles.cardTitle}>Local Expertise</h3>
            <p style={styles.cardDescription}>As a local business, we understand the unique plumbing needs of the Coronado neighborhood and provide tailored solutions.</p>
          </div>
          <div style={styles.card}>
            <h3 style={styles.cardTitle}>Rapid Response</h3>
            <p style={styles.cardDescription}>We offer prompt and efficient service, ensuring your plumbing issues are resolved quickly to minimize disruption.</p>
          </div>
          <div style={styles.card}>
            <h3 style={styles.cardTitle}>Certified Professionals</h3>
            <p style={styles.cardDescription}>Our team consists of highly trained and certified plumbers dedicated to delivering quality workmanship and lasting results.</p>
          </div>
          <div style={styles.card}>
            <h3 style={styles.cardTitle}>Transparent Pricing</h3>
            <p style={styles.cardDescription}>Enjoy clear, upfront pricing with no hidden fees. We believe in honesty and integrity in every service we provide.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section style={styles.section}>
        <h2 style={styles.sectionTitle}>Our Services</h2>
        <div style={styles.cardContainer}>
          <div style={styles.card}>
            <h3 style={styles.cardTitle}>Emergency Plumbing</h3>
            <p style={styles.cardDescription}>Available 24/7 for urgent plumbing issues, from burst pipes to severe leaks, ensuring peace of mind for Coronado residents.</p>
          </div>
          <div style={styles.card}>
            <h3 style={styles.cardTitle}>Water Heater Services</h3>
            <p style={styles.cardDescription}>Expert installation, repair, and maintenance for all types of water heaters, providing reliable hot water for your home.</p>
          </div>
          <div style={styles.card}>
            <h3 style={styles.cardTitle}>Drain Cleaning</h3>
            <p style={styles.cardDescription}>Professional drain cleaning services to clear stubborn clogs and restore proper drainage throughout your property.</p>
          </div>
        </div>
      </section>

      {/* About Coronado Section */}
      <section style={styles.section}>
        <h2 style={styles.sectionTitle}>About Coronado</h2>
        <p style={styles.paragraph}>
          The Coronado neighborhood is a cornerstone of the Lubbock community, centered around the highly-regarded Coronado High School. Residents benefit from well-maintained streets, a friendly atmosphere, and convenient access to local amenities. Its proximity to Texas Tech University and downtown Lubbock means easy access to cultural events, dining, and employment opportunities. The area boasts a mix of housing styles, from charming older homes to more modern residences, all contributing to its diverse appeal. Families appreciate the strong school system and local parks, while everyone enjoys the sense of belonging that defines Coronado.
        </p>
      </section>

      {/* CTA Section */}
      <section style={{...styles.section, ...styles.ctaSection}}>
        <h2 style={styles.sectionTitle}>Ready for Expert Plumbing Service?</h2>
        <p style={styles.ctaText}>Call us today for reliable and efficient plumbing solutions in Coronado!</p>
        <a href={`tel:${phoneNumber}`} style={styles.ctaButton}>{phoneNumber}</a>
        <a href={housecallProLink} target="_blank" rel="noopener noreferrer" style={styles.ctaButton}>Schedule Service with Housecall Pro</a>
      </section>
    </div>
  );
};

const styles: { [key: string]: React.CSSProperties } = {
  container: {
    fontFamily: 'Arial, sans-serif',
    color: '#333',
    lineHeight: '1.6',
    backgroundColor: '#f8f8f8',
  },
  section: {
    padding: '40px 20px',
    margin: '0 auto',
    maxWidth: '1200px',
  },
  heroSection: {
    backgroundColor: '#000',
    color: '#fff',
    textAlign: 'center',
    padding: '80px 20px',
  },
  heroTitle: {
    fontSize: '3em',
    marginBottom: '10px',
    color: '#e74c3c', // Red accent
  },
  heroDescription: {
    fontSize: '1.2em',
    maxWidth: '800px',
    margin: '0 auto',
  },
  sectionTitle: {
    fontSize: '2.5em',
    textAlign: 'center',
    marginBottom: '40px',
    color: '#000',
  },
  cardContainer: {
    display: 'grid',
    gridTemplateColumns: 'repeat(auto-fit, minmax(280px, 1fr))',
    gap: '20px',
    justifyContent: 'center',
  },
  card: {
    backgroundColor: '#fff',
    padding: '25px',
    borderRadius: '8px',
    boxShadow: '0 4px 8px rgba(0, 0, 0, 0.1)',
    textAlign: 'center',
    borderTop: '5px solid #e74c3c',
  },
  cardTitle: {
    fontSize: '1.5em',
    color: '#000',
    marginBottom: '10px',
  },
  cardDescription: {
    fontSize: '1em',
    color: '#555',
  },
  paragraph: {
    fontSize: '1.1em',
    color: '#333',
    textAlign: 'justify',
  },
  ctaSection: {
    backgroundColor: '#e74c3c',
    color: '#fff',
    textAlign: 'center',
    padding: '60px 20px',
  },
  ctaText: {
    fontSize: '1.5em',
    marginBottom: '20px',
  },
  ctaButton: {
    display: 'inline-block',
    backgroundColor: '#000',
    color: '#fff',
    padding: '15px 30px',
    margin: '10px',
    borderRadius: '5px',
    textDecoration: 'none',
    fontSize: '1.1em',
    fontWeight: 'bold',
    transition: 'background-color 0.3s ease',
  },
  // Add hover effects if needed
  // ctaButton:hover: {
  //   backgroundColor: '#333',
  // },
};

export default Coronado;

// Placeholder for React Helmet. In a real project, you would install and use it:
// import { Helmet } from 'react-helmet-async';
const Helmet = ({ children }: { children: React.ReactNode }) => <>{children}</>;
