import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Card, CardContent } from "@/components/ui/card";
import { Clock, MapPin, Phone, Mail } from "lucide-react";
import { MapView } from "@/components/Map";
import { useEffect } from "react";

declare global {
  interface Window {
    HCPWidget: any;
  }
}

export default function Contact() {
  useEffect(() => {
    // Load Housecall Pro script
    const script = document.createElement("script");
    script.src = "https://online-booking.housecallpro.com/script.js?token=ae9ce9953f0f4e379d45293c0f23cbb8&orgName=Cotton-City-Plumbing";
    script.async = true;
    document.body.appendChild(script);

    return () => {
      document.body.removeChild(script);
    };
  }, []);

  return (
    <Layout>
      <SEO 
        title="Contact Cotton City Plumbing | Same-Day Emergency Plumber Lubbock"
        description="Need a plumber in Lubbock? Contact Cotton City Plumbing for fast, reliable service. Same-day emergency service available Mon-Fri 7am-7pm, Sat 8am-12pm. Call (806) 441-4110 today!"
        canonical="/contact"
      />
      <section className="bg-primary text-white py-16">
        <div className="container text-center">
          <h1 className="font-heading font-extrabold text-4xl md:text-6xl mb-4">Contact Us</h1>
          <p className="text-xl text-primary-foreground/90 max-w-2xl mx-auto">
            We're here to help with all your plumbing needs. Same-day emergency service available during business hours. Call us or book online instantly.
          </p>
        </div>
      </section>

      <section className="py-16 bg-background">
        <div className="container">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12">
            {/* Contact Info */}
            <div className="space-y-8">
              <div>
                <h2 className="font-heading font-bold text-2xl text-primary mb-6">Get In Touch</h2>
                <div className="grid gap-6">
                  <Card className="border-l-4 border-l-secondary">
                    <CardContent className="p-6 flex items-start gap-4">
                      <div className="bg-secondary/10 p-3 rounded-full text-secondary">
                        <Phone className="h-6 w-6" />
                      </div>
                      <div>
                        <h3 className="font-bold text-lg mb-1">Phone</h3>
                        <p className="text-muted-foreground mb-2">Same-Day Emergency Service</p>
                        <p className="text-sm text-muted-foreground">Mon-Fri: 7am-7pm | Sat: 8am-12pm</p>
                        <a href="tel:8064414110" className="text-xl font-bold text-primary hover:text-secondary transition-colors">
                          (806) 441-4110
                        </a>
                      </div>
                    </CardContent>
                  </Card>

                  <Card className="border-l-4 border-l-secondary">
                    <CardContent className="p-6 flex items-start gap-4">
                      <div className="bg-secondary/10 p-3 rounded-full text-secondary">
                        <Mail className="h-6 w-6" />
                      </div>
                      <div>
                        <h3 className="font-bold text-lg mb-1">Email</h3>
                        <p className="text-muted-foreground mb-2">For non-urgent inquiries</p>
                        <a href="mailto:services@cottoncityplumbing.com" className="text-xl font-bold text-primary hover:text-secondary transition-colors">
                          services@cottoncityplumbing.com
                        </a>
                      </div>
                    </CardContent>
                  </Card>

                  <Card className="border-l-4 border-l-secondary">
                    <CardContent className="p-6 flex items-start gap-4">
                      <div className="bg-secondary/10 p-3 rounded-full text-secondary">
                        <MapPin className="h-6 w-6" />
                      </div>
                      <div>
                        <h3 className="font-bold text-lg mb-1">Service Area</h3>
                        <p className="text-muted-foreground">
                          Proudly serving Lubbock, TX and surrounding areas within a 50-mile radius, including Wolfforth, Levelland, Slaton, and Shallowater.
                        </p>
                      </div>
                    </CardContent>
                  </Card>

                  <Card className="border-l-4 border-l-secondary">
                    <CardContent className="p-6 flex items-start gap-4">
                      <div className="bg-secondary/10 p-3 rounded-full text-secondary">
                        <Clock className="h-6 w-6" />
                      </div>
                      <div>
                        <h3 className="font-bold text-lg mb-1">Hours</h3>
                        <div className="grid grid-cols-2 gap-x-8 gap-y-1 text-muted-foreground">
                          <span>Monday - Friday:</span>
                          <span className="font-medium text-foreground">7:00 AM - 7:00 PM</span>
                          <span>Saturday:</span>
                          <span className="font-medium text-foreground">8:00 AM - 12:00 PM</span>
                          <span>Sunday:</span>
                          <span className="font-medium text-foreground">Closed (Emergency Only)</span>
                        </div>
                      </div>
                    </CardContent>
                  </Card>
                </div>
              </div>
            </div>

            {/* Right Column: Van Photo + Booking Widget */}
            <div className="space-y-6">
              {/* Branded Van Photo */}
              <div className="rounded-xl overflow-hidden shadow-xl border border-border">
                <img 
                  src="/images/cotton-city-van.jpg" 
                  alt="Cotton City Plumbing branded service van" 
                  className="w-full h-auto object-cover"
                />
              </div>

              {/* Housecall Pro Booking Widget */}
              <div className="bg-muted/30 p-8 rounded-xl border border-border flex flex-col items-center justify-center text-center">
                <h2 className="font-heading font-bold text-3xl text-primary mb-4">Book Online Instantly</h2>
                <p className="text-muted-foreground mb-8">
                  Schedule your appointment directly with our team. Choose a time that works best for you.
                </p>
                
                {/* Housecall Pro Button */}
                <button
                  data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                  data-orgname="Cotton-City-Plumbing"
                  className="hcp-button bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-6 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 w-full max-w-xs"
                  onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
                >
                  Book Online Now
                </button>
                
                <p className="mt-6 text-sm text-muted-foreground">
                  Powered by Housecall Pro
                </p>
              </div>

              {/* Map */}
              <div>
                <div className="h-[300px] rounded-xl overflow-hidden shadow-lg border border-border">
                  <MapView 
                    className="w-full h-full"
                    onMapReady={(map: google.maps.Map) => {
                      // Center on actual business location
                      const businessLocation = { lat: 33.4619721, lng: -101.8497587 };
                      map.setCenter(businessLocation);
                      map.setZoom(15);
                      
                      // Add marker at business address
                      new google.maps.Marker({
                        position: businessLocation,
                        map: map,
                        title: "Cotton City Plumbing - 1306 146th Street",
                        animation: google.maps.Animation.DROP
                      });
                    }}
                  />
                </div>
                
                {/* Get Directions Button */}
                <a 
                  href="https://www.google.com/maps/dir/?api=1&destination=1308+146th+Street,Lubbock,TX+79423"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="mt-4 flex items-center justify-center gap-2 bg-secondary hover:bg-secondary/90 text-white font-bold py-4 px-6 rounded-lg shadow-lg transition-all transform hover:-translate-y-1"
                >
                  <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                  </svg>
                  Get Directions
                </a>
              </div>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
