import React from 'react';

const ChaparralRidge: React.FC = () => {
  return (
    <div>
      <h1>Welcome to Chaparral Ridge, Lubbock, Texas</h1>
      {/* Schema Markup */}
      <script type="application/ld+json">
        {`
          {
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "Chaparral Ridge Plumbing Services",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "Chaparral Ridge Neighborhood",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79424", // Approximate postal code for Lubbock
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.5779,
              "longitude": -101.8552
            },
            "url": "https://yourwebsite.com/chaparral-ridge", // Placeholder URL
            "telephone": "+18064414110",
            "priceRange": "$$",
            "openingHoursSpecification": [
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": [
                  "Monday",
                  "Tuesday",
                  "Wednesday",
                  "Thursday",
                  "Friday",
                  "Saturday",
                  "Sunday"
                ],
                "opens": "00:00",
                "closes": "23:59"
              }
            ],
            "image": "https://yourwebsite.com/images/chaparral-ridge-hero.jpg", // Placeholder image
            "description": "Expert plumbing services in the Chaparral Ridge neighborhood of Lubbock, Texas."
          }
        `}
      </script>

      {/* SEO Meta Tags (will be handled in index.html or a Head component) */}
      {/* <title>Chaparral Ridge Plumbing Services - Lubbock, TX</title> */}
      {/* <meta name="description" content="Expert plumbing services in Chaparral Ridge, Lubbock, Texas. Emergency plumbing, water heaters, drain cleaning, and more." /> */}
      {/* <meta name="keywords" content="Chaparral Ridge plumbing, Lubbock plumbing, emergency plumbing Lubbock, water heater repair Lubbock, drain cleaning Lubbock" /> */}

      {/* Hero Section */}
      <section className="hero">
        <div className="hero-content">
          <h1>Chaparral Ridge: Your Trusted Local Plumbers</h1>
          <p>Serving the beautiful Chaparral Ridge neighborhood with reliable and efficient plumbing solutions.</p>
        </div>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us">
        <h2>Why Choose Us in Chaparral Ridge?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Chaparral Ridge's unique plumbing needs.</p>
          </div>
          <div className="card">
            <h3>Rapid Response</h3>
            <p>Quick and efficient service for all your plumbing emergencies.</p>
          </div>
          <div className="card">
            <h3>Quality Workmanship</h3>
            <p>Experienced technicians delivering lasting solutions.</p>
          </div>
          <div className="card">
            <h3>Customer Satisfaction</h3>
            <p>Dedicated to providing the best service experience.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services">
        <h2>Our Services in Chaparral Ridge</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 availability for urgent plumbing issues.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance of all water heater types.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains and sewer lines.</p>
          </div>
        </div>
      </section>

      {/* About Chaparral Ridge Section */}
      <section className="about-neighborhood">
        <h2>About Chaparral Ridge, Lubbock</h2>
        <p>Chaparral Ridge is a vibrant and growing community located southwest of Lubbock Christian University, known for its serene environment and access to amenities like the Chaparral Ridge Golf Course and Cross Country Course. With its proximity to Frenship ISD schools and convenient access to major roads, it offers a perfect blend of peaceful living and urban convenience. Residents enjoy a family-friendly atmosphere and the benefits of a well-maintained neighborhood.</p>
        <p>The neighborhood is ideal for those seeking a balance between quiet residential life and easy access to Lubbock's dining, shopping, and educational institutions. Its newer developments often feature modern homes with spacious layouts, catering to diverse family needs.</p>
      </section>

      {/* CTA Section */}
      <section className="cta">
        <h2>Need Plumbing Services in Chaparral Ridge?</h2>
        <p>Call us today for reliable and professional plumbing assistance!</p>
        <p className="phone-number">(806) 441-4110</p>
        <button className="booking-button">Book Now with Housecall Pro</button>
      </section>

      {/* Basic Styling (will be moved to a CSS file or styled-components) */}
      <style>{`
        div {
          font-family: Arial, sans-serif;
          color: #333;
        }
        .hero {
          background-color: #000;
          color: #fff;
          padding: 100px 20px;
          text-align: center;
        }
        .hero-content h1 {
          color: #e30000; /* Red accent */
          font-size: 3em;
          margin-bottom: 10px;
        }
        .hero-content p {
          font-size: 1.2em;
        }
        section {
          padding: 60px 20px;
          max-width: 1200px;
          margin: 0 auto;
        }
        h2 {
          text-align: center;
          color: #000;
          margin-bottom: 40px;
          font-size: 2.5em;
        }
        .why-choose-us .cards-container,
        .services .cards-container {
          display: flex;
          justify-content: space-around;
          flex-wrap: wrap;
          gap: 20px;
        }
        .card {
          background-color: #f4f4f4;
          border: 1px solid #ddd;
          border-radius: 8px;
          padding: 30px;
          text-align: center;
          flex: 1 1 calc(33% - 40px); /* For 3 cards */
          box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .why-choose-us .card {
          flex: 1 1 calc(25% - 40px); /* For 4 cards */
        }
        .card h3 {
          color: #e30000;
          margin-bottom: 15px;
        }
        .about-neighborhood p {
          line-height: 1.6;
          margin-bottom: 20px;
          text-align: justify;
        }
        .cta {
          background-color: #000;
          color: #fff;
          text-align: center;
          padding: 80px 20px;
        }
        .cta h2 {
          color: #fff;
        }
        .cta .phone-number {
          font-size: 2.5em;
          color: #e30000;
          margin: 20px 0;
        }
        .booking-button {
          background-color: #e30000;
          color: #fff;
          border: none;
          padding: 15px 30px;
          font-size: 1.2em;
          border-radius: 5px;
          cursor: pointer;
          transition: background-color 0.3s ease;
        }
        .booking-button:hover {
          background-color: #c00000;
        }
        @media (max-width: 768px) {
          .why-choose-us .card,
          .services .card {
            flex: 1 1 calc(50% - 20px);
          }
        }
        @media (max-width: 480px) {
          .why-choose-us .card,
          .services .card {
            flex: 1 1 100%;
          }
          .hero-content h1 {
            font-size: 2em;
          }
          .cta .phone-number {
            font-size: 1.8em;
          }
        }
      `}</style>
    </div>
  );
};

export default ChaparralRidge;
