
import React from 'react';
import { Helmet } from 'react-helmet-async';

const BuffaloSprings: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProBookingLink = 'https://www.housecallpro.com/book/your-company-name'; // Placeholder, replace with actual link

  return (
    <div className="buffalo-springs-page">
      <Helmet>
        <title>Plumbing Services in Buffalo Springs, Lubbock, TX | Your Company Name</title>
        <meta name="description" content="Expert plumbing services in Buffalo Springs, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more for this peaceful, rural community near Buffalo Springs Lake." />
        <meta name="keywords" content="Buffalo Springs plumbing, Lubbock plumbing, emergency plumbing Buffalo Springs, water heater Buffalo Springs, drain cleaning Buffalo Springs, Buffalo Springs Lake, Roosevelt ISD, Frenship ISD" />
        <script type="application/ld+json">
          {`
            {
              "@context": "http://schema.org",
              "@type": "LocalBusiness",
              "name": "Your Company Name Plumbing",
              "address": {
                "@type": "PostalAddress",
                "streetAddress": "[Your Street Address]", // Placeholder
                "addressLocality": "Lubbock",
                "addressRegion": "TX",
                "postalCode": "[Your Postal Code]" // Placeholder
              },
              "geo": {
                "@type": "GeoCoordinates",
                "latitude": 33.5779,
                "longitude": -101.8552
              },
              "telephone": "${phoneNumber}",
              "openingHours": "Mo-Fr 08:00-17:00", // Placeholder
              "priceRange": "$$"
            }
          `}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to Buffalo Springs, Lubbock, TX</h1>
        <p>Experience reliable and professional plumbing services in the serene and spacious community of Buffalo Springs. Nestled in Lubbock County, Buffalo Springs offers a peaceful, rural lifestyle, and we're here to ensure your home's plumbing runs smoothly.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in Buffalo Springs?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Understanding the unique plumbing needs of Buffalo Springs homes, from rural water systems to specific community requirements.</p>
          </div>
          <div className="card">
            <h3>Prompt Service</h3>
            <p>Quick response times to address your plumbing emergencies, minimizing disruption to your peaceful Buffalo Springs life.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Our certified technicians provide courteous, efficient, and high-quality service you can rely on.</p>
          </div>
          <div className="card">
            <h3>Transparent Pricing</h3>
            <p>Clear, upfront pricing with no hidden fees, so you know exactly what to expect before any work begins.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Buffalo Springs</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 rapid response for burst pipes, severe leaks, and other urgent plumbing issues in Buffalo Springs.</p>
          </div>
          <div className="card">
            <h3>Water Heater Repair & Installation</h3>
            <p>Expert service for all types of water heaters, ensuring you have consistent hot water in your home.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains, from minor blockages to major sewer line issues, keeping your systems clear.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About Buffalo Springs, Lubbock, TX</h2>
        <p>Buffalo Springs is a charming village in Lubbock County, offering residents a unique blend of rural tranquility and community spirit. Known for its spacious lots and relaxed atmosphere, it's an ideal place for those seeking a peaceful lifestyle away from the city bustle. A prominent feature of the area is the beautiful **Buffalo Springs Lake**, providing opportunities for boating, fishing, camping, and hiking, making it a beloved local landmark and recreational hub. The community is served by excellent educational institutions, including the **Roosevelt Independent School District** and nearby **Frenship ISD**, ensuring quality education for families. With its scenic landscapes and friendly environment, Buffalo Springs truly offers a wonderful place to call home.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Service in Buffalo Springs?</h2>
        <p>Call us today for reliable plumbing solutions!</p>
        <a href={`tel:${phoneNumber}`} className="phone-button">Call {phoneNumber}</a>
        <a href={housecallProBookingLink} target="_blank" rel="noopener noreferrer" className="booking-button">Book Now with Housecall Pro</a>
      </section>

      {/* Basic Styling (to be replaced by actual site design) */}
      <style>{`
        .buffalo-springs-page {
          font-family: Arial, sans-serif;
          line-height: 1.6;
          color: #333;
          max-width: 1200px;
          margin: 0 auto;
          padding: 20px;
        }
        .hero-section {
          background-color: #000;
          color: #fff;
          padding: 60px 20px;
          text-align: center;
        }
        .hero-section h1 {
          color: #e50000; /* Red */
          margin-bottom: 15px;
        }
        .why-choose-us-section, .services-section, .about-neighborhood-section, .cta-section {
          padding: 40px 20px;
          text-align: center;
        }
        .why-choose-us-section h2, .services-section h2, .about-neighborhood-section h2, .cta-section h2 {
          color: #e50000; /* Red */
          margin-bottom: 30px;
        }
        .cards-container {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
          gap: 20px;
          margin-top: 30px;
        }
        .card {
          background-color: #f4f4f4;
          border: 1px solid #ddd;
          padding: 25px;
          border-radius: 8px;
          text-align: left;
          box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .card h3 {
          color: #000;
          margin-top: 0;
          margin-bottom: 15px;
        }
        .cta-section {
          background-color: #000;
          color: #fff;
          padding: 50px 20px;
        }
        .cta-section p {
          margin-bottom: 25px;
        }
        .phone-button, .booking-button {
          display: inline-block;
          background-color: #e50000; /* Red */
          color: #fff;
          padding: 12px 25px;
          border-radius: 5px;
          text-decoration: none;
          margin: 10px;
          font-weight: bold;
          transition: background-color 0.3s ease;
        }
        .phone-button:hover, .booking-button:hover {
          background-color: #cc0000;
        }
      `}</style>
    </div>
  );
};

export default BuffaloSprings;
