import React from 'react';

const Bowie: React.FC = () => {
  const seo = {
    title: 'Bowie Neighborhood Lubbock TX - Expert Plumbing Services',
    metaDescription: 'Discover top-rated plumbing services in Bowie, Lubbock, TX. We offer emergency repairs, water heater installation, and drain cleaning for this family-friendly residential area near Lubbock Christian University.',
    keywords: 'Bowie Lubbock TX, Bowie neighborhood plumbing, Lubbock plumbing services, emergency plumbing Bowie, water heater repair Lubbock, drain cleaning Bowie, residential plumbing Lubbock, Greenlawn area plumbing',
  };

  const neighborhoodName = 'Bowie';
  const heroDescription = 'Welcome to Bowie, a charming and family-friendly residential neighborhood nestled in the heart of Lubbock, Texas. Known for its spacious lots, mature oak trees, and traditional homes, Bowie offers a serene living experience with convenient access to city amenities and the vibrant campus of Lubbock Christian University.';

  const whyChooseUsCards = [
    {
      title: 'Local Expertise',
      description: "Deep understanding of Bowie's unique plumbing needs, from historic homes to modern residences.",
    },
    {
      title: 'Rapid Response',
      description: 'Fast and reliable emergency plumbing services for the Bowie and Greenlawn areas, ensuring minimal disruption.',
    },
    {
      title: 'Quality Workmanship',
      description: 'Certified technicians delivering lasting solutions with attention to detail and superior materials.',
    },
    {
      title: 'Community Focused',
      description: 'Proudly serving the Bowie community, committed to customer satisfaction and building lasting relationships.',
    },
  ];

  const serviceCards = [
    {
      title: 'Emergency Plumbing',
      description: '24/7 rapid response for burst pipes, major leaks, and urgent plumbing issues in Bowie.',
    },
    {
      title: 'Water Heater Services',
      description: 'Installation, repair, and maintenance of all water heater types, ensuring hot water comfort for Bowie homes.',
    },
    {
      title: 'Drain Cleaning & Repair',
      description: "Advanced solutions for clogged drains and sewer line issues, keeping Bowie's plumbing flowing smoothly.",
    },
  ];

  const aboutBowieContent = {
    title: 'About Bowie: A Welcoming Lubbock Community',
    content: 'The Bowie neighborhood, also affectionately known as the Greenlawn area, is a highly sought-after residential enclave just six miles from downtown Lubbock. Residents enjoy the tranquility of suburban living on spacious lots adorned with mature oak and flowering magnolia trees, contributing to the area\'s picturesque charm. The community is predominantly residential, featuring a mix of traditional homes and rental properties, making it diverse and welcoming. Bowie is particularly favored by families due to its safe streets where children frequently play, and its excellent school district, which includes the highly-rated Bowie Elementary School and Hardwick Elementary School. Its close proximity to Lubbock Christian University adds to its appeal, offering educational and cultural opportunities. For daily conveniences, residents have easy access to a variety of shopping and dining options along Highway 289, ensuring everything you need is just a short drive away. Bowie truly embodies a blend of peaceful living with urban accessibility.',
  };

  const cta = {
    phoneNumber: '(806) 441-4110',
    bookingButton: 'Housecall Pro booking button (placeholder for integration)',
  };

  const geoCoordinates = { latitude: 33.5779, longitude: -101.8552 };

  // Basic styling for demonstration. In a real application, this would be imported from a shared stylesheet.
  const styles: { [key: string]: React.CSSProperties } = {
    container: {
      fontFamily: 'Arial, sans-serif',
      color: '#333',
      lineHeight: '1.6',
      maxWidth: '1200px',
      margin: '0 auto',
      padding: '20px',
      backgroundColor: '#fff',
    },
    header: {
      backgroundColor: '#000',
      color: '#fff',
      padding: '40px 20px',
      textAlign: 'center',
    },
    h1: {
      fontSize: '3em',
      marginBottom: '10px',
    },
    h2: {
      fontSize: '2em',
      color: '#cc0000',
      textAlign: 'center',
      margin: '40px 0 20px',
    },
    section: {
      padding: '20px 0',
      borderBottom: '1px solid #eee',
    },
    cardContainer: {
      display: 'grid',
      gridTemplateColumns: 'repeat(auto-fit, minmax(250px, 1fr))',
      gap: '20px',
      marginTop: '20px',
    },
    card: {
      backgroundColor: '#f9f9f9',
      border: '1px solid #ddd',
      borderRadius: '8px',
      padding: '20px',
      textAlign: 'center',
      boxShadow: '0 2px 4px rgba(0,0,0,0.1)',
    },
    cardTitle: {
      color: '#000',
      fontSize: '1.2em',
      marginBottom: '10px',
    },
    ctaSection: {
      backgroundColor: '#cc0000',
      color: '#fff',
      padding: '40px 20px',
      textAlign: 'center',
      marginTop: '40px',
    },
    ctaButton: {
      backgroundColor: '#000',
      color: '#fff',
      padding: '15px 30px',
      fontSize: '1.2em',
      textDecoration: 'none',
      borderRadius: '5px',
      display: 'inline-block',
      marginTop: '20px',
    },
    aboutContent: {
      textAlign: 'justify',
      margin: '0 auto',
      maxWidth: '800px',
    },
  };

  return (
    <div style={styles.container}>
      {/* SEO Schema Markup */}
      <script type="application/ld+json">
        {`
          {
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "Plumbing Services in ${neighborhoodName}, Lubbock TX",
            "address": {
              "@type": "PostalAddress",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": ${geoCoordinates.latitude},
              "longitude": ${geoCoordinates.longitude}
            },
            "url": "https://yourwebsite.com/${neighborhoodName.toLowerCase().replace(/ /g, '-')}",
            "telephone": "${cta.phoneNumber}",
            "description": "${seo.metaDescription}",
            "hasMap": "https://www.google.com/maps/search/?api=1&query=${geoCoordinates.latitude},${geoCoordinates.longitude}"
          }
        `}
      </script>

      {/* SEO Meta Tags (would typically be handled by a Helmet component or similar in a real app) */}
      <title>{seo.title}</title>
      <meta name="description" content={seo.metaDescription} />
      <meta name="keywords" content={seo.keywords} />

      {/* Hero Section */}
      <header style={styles.header}>
        <h1 style={styles.h1}>{neighborhoodName} Neighborhood</h1>
        <p>{heroDescription}</p>
      </header>

      {/* Why Choose Us Section */}
      <section style={styles.section}>
        <h2 style={styles.h2}>Why Choose Us</h2>
        <div style={styles.cardContainer}>
          {whyChooseUsCards.map((card, index) => (
            <div key={index} style={styles.card}>
              <h3 style={styles.cardTitle}>{card.title}</h3>
              <p>{card.description}</p>
            </div>
          ))}
        </div>
      </section>

      {/* Services Section */}
      <section style={styles.section}>
        <h2 style={styles.h2}>Our Services</h2>
        <div style={styles.cardContainer}>
          {serviceCards.map((card, index) => (
            <div key={index} style={styles.card}>
              <h3 style={styles.cardTitle}>{card.title}</h3>
              <p>{card.description}</p>
            </div>
          ))}
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section style={styles.section}>
        <h2 style={styles.h2}>{aboutBowieContent.title}</h2>
        <p style={styles.aboutContent}>{aboutBowieContent.content}</p>
      </section>

      {/* CTA Section */}
      <section style={styles.ctaSection}>
        <h2 style={{ ...styles.h2, color: '#fff' }}>Ready for Expert Plumbing Services?</h2>
        <p>Call us today for reliable service in the {neighborhoodName} neighborhood!</p>
        <p style={{ fontSize: '1.5em', fontWeight: 'bold' }}>{cta.phoneNumber}</p>
        <a href="#" style={styles.ctaButton} onClick={(e) => e.preventDefault()}>
          Book Now with Housecall Pro
        </a>
        {/* In a real application, the href would link to the Housecall Pro booking page */}
      </section>
    </div>
  );
};

export default Bowie;
