import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { blogPosts } from "@/data/blogPosts";
import { Calendar, User } from "lucide-react";
import { Link } from "wouter";

export default function Blog() {
  return (
    <Layout>
      <SEO 
        title="Plumbing Tips & News | Cotton City Plumbing Blog"
        description="Read the latest plumbing tips, news, and advice from Cotton City Plumbing. Expert articles on maintenance, repairs, and upgrades for Lubbock homeowners."
        keywords="plumbing blog, lubbock plumbing tips, water heater advice, drain cleaning tips"
      />
      
      <div className="bg-zinc-900 py-12 md:py-20">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <h1 className="text-4xl md:text-6xl font-league-gothic text-white mb-6 uppercase tracking-wide">
              Plumbing <span className="text-red-600">News & Tips</span>
            </h1>
            <p className="text-xl text-gray-300 max-w-2xl mx-auto">
              Expert advice, local insights, and helpful guides to keep your home's plumbing running smoothly.
            </p>
          </div>
        </div>
      </div>

      <div className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {blogPosts.map((post) => (
              <article key={post.id} className="bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow duration-300 flex flex-col h-full">
                <div className="p-6 flex flex-col flex-grow">
                  <div className="flex items-center text-sm text-gray-500 mb-4 space-x-4">
                    <div className="flex items-center">
                      <Calendar className="w-4 h-4 mr-1" />
                      {new Date(post.date).toLocaleDateString()}
                    </div>
                    <div className="flex items-center">
                      <User className="w-4 h-4 mr-1" />
                      {post.author}
                    </div>
                  </div>
                  
                  <h2 className="text-2xl font-bold text-gray-900 mb-3 font-league-gothic uppercase tracking-wide leading-tight">
                    <Link href={`/blog/${post.slug}`} className="hover:text-red-600 transition-colors">
                      {post.title}
                    </Link>
                  </h2>
                  
                  <p className="text-gray-600 mb-6 flex-grow line-clamp-3">
                    {post.excerpt}
                  </p>
                  
                  <Link href={`/blog/${post.slug}`}>
                    <span className="inline-block text-red-600 font-bold uppercase tracking-wider text-sm hover:text-red-700 transition-colors cursor-pointer">
                      Read Article &rarr;
                    </span>
                  </Link>
                </div>
              </article>
            ))}
          </div>
        </div>
      </div>
    </Layout>
  );
}
