import React from 'react';

const Ballenger: React.FC = () => {
  const neighborhoodName = "Ballenger";
  const geoCoordinates = { latitude: 33.5779, longitude: -101.8552 };
  const phoneNumber = "(806) 441-4110";

  return (
    <div className="ballenger-landing-page">
      {/* SEO Meta Tags and Schema Markup */}
      <head>
        <title>{`Plumbing Services in ${neighborhoodName}, Lubbock, TX`}</title>
        <meta name="description" content={`Expert plumbing services in ${neighborhoodName}, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more.`} />
        <meta name="keywords" content={`plumbing ${neighborhoodName}, plumber Lubbock, emergency plumbing ${neighborhoodName}, water heater repair ${neighborhoodName}, drain cleaning ${neighborhoodName}`} />
        <script type="application/ld+json">
          {`
            {
              "@context": "http://schema.org",
              "@type": "LocalBusiness",
              "name": "[Your Company Name] Plumbing",
              "address": {
                "@type": "PostalAddress",
                "streetAddress": "[Your Street Address]",
                "addressLocality": "Lubbock",
                "addressRegion": "TX",
                "postalCode": "[Your Postal Code]"
              },
              "geo": {
                "@type": "GeoCoordinates",
                "latitude": ${geoCoordinates.latitude},
                "longitude": ${geoCoordinates.longitude}
              },
              "url": "[Your Website URL]",
              "telephone": "${phoneNumber}",
              "priceRange": "$$",
              "openingHoursSpecification": [
                {
                  "@type": "OpeningHoursSpecification",
                  "dayOfWeek": [
                    "Monday",
                    "Tuesday",
                    "Wednesday",
                    "Thursday",
                    "Friday",
                    "Saturday",
                    "Sunday"
                  ],
                  "opens": "00:00",
                  "closes": "23:59"
                }
              ]
            }
          `}
        </script>
      </head>

      {/* Hero Section */}
      <section className="hero-section" style={{ backgroundColor: 'black', color: 'white', padding: '60px 20px', textAlign: 'center' }}>
        <h1>{`Expert Plumbing Services in ${neighborhoodName}, Lubbock, TX`}
        </h1>
        <p>Ballenger is a residential area in Lubbock, Texas, offering comparatively lower-cost homes with access to major roads and restaurants. It is known for its family-friendly atmosphere and a mix of older, well-maintained homes. It sits on the outskirts of downtown, providing quick access to nearby job opportunities.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section" style={{ padding: '40px 20px', textAlign: 'center', backgroundColor: 'white', color: 'black' }}>
        <h2>Why Choose Us</h2>
        <div className="cards-container" style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap' }}>
          <div className="card" style={{ width: '23%', margin: '10px', padding: '20px', border: '1px solid #eee', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
            <h3>24/7 Emergency Service</h3>
            <p>We're here for you around the clock, ensuring your plumbing emergencies are handled promptly.</p>
          </div>
          <div className="card" style={{ width: '23%', margin: '10px', padding: '20px', border: '1px solid #eee', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
            <h3>Experienced Technicians</h3>
            <p>Our team consists of highly trained and certified professionals dedicated to quality service.</p>
          </div>
          <div className="card" style={{ width: '23%', margin: '10px', padding: '20px', border: '1px solid #eee', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
            <h3>Local to Lubbock</h3>
            <p>Proudly serving the Ballenger neighborhood and surrounding Lubbock areas with reliable plumbing solutions.</p>
          </div>
          <div className="card" style={{ width: '23%', margin: '10px', padding: '20px', border: '1px solid #eee', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
            <h3>Customer Satisfaction</h3>
            <p>Your satisfaction is our top priority. We strive for excellence in every job we undertake.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section" style={{ padding: '40px 20px', textAlign: 'center', backgroundColor: '#f4f4f4', color: 'black' }}>
        <h2>Our Services</h2>
        <div className="cards-container" style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap' }}>
          <div className="card" style={{ width: '30%', margin: '10px', padding: '20px', border: '1px solid #eee', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
            <h3>Emergency Plumbing</h3>
            <p>Fast and reliable service for all your urgent plumbing needs, 24/7.</p>
          </div>
          <div className="card" style={{ width: '30%', margin: '10px', padding: '20px', border: '1px solid #eee', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
            <h3>Water Heater Repair & Installation</h3>
            <p>Expert service for tankless, electric, and gas water heaters.</p>
          </div>
          <div className="card" style={{ width: '30%', margin: '10px', padding: '20px', border: '1px solid #eee', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
            <h3>Drain Cleaning</h3>
            <p>Thorough cleaning to clear stubborn clogs and prevent future blockages.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section" style={{ padding: '40px 20px', backgroundColor: 'black', color: 'white' }}>
        <h2>{`About ${neighborhoodName}`}</h2>
        <p>Ballenger is a quiet, residential neighborhood in Lubbock, Texas. It's known for its family-friendly atmosphere and a mix of older, well-maintained homes. The neighborhood is part of the Lubbock Independent School District, with schools like Bean Elementary, Slaton Middle, and Monterey High serving the community. Monterey High is particularly noted for its successful athletics program. The South Plains College Career and Technical Center is also located nearby on Avenue Q, and Texas Tech University is just 3 miles north, renowned for its athletics programs.</p>
        <p>A unique aspect of Lubbock, and by extension, neighborhoods like Ballenger, is its connection to music history. Lubbock is the birthplace of rock 'n' roll legend Buddy Holly, and there's a museum dedicated to him that showcases the history of rock and roll.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section" style={{ padding: '40px 20px', textAlign: 'center', backgroundColor: 'white', color: 'black' }}>
        <h2>Ready for Reliable Plumbing Service?</h2>
        <p>Call us today for immediate assistance or book online!</p>
        <p style={{ fontSize: '1.5em', fontWeight: 'bold', color: 'red' }}>{phoneNumber}</p>
        <button style={{ backgroundColor: 'red', color: 'white', padding: '15px 30px', border: 'none', borderRadius: '5px', fontSize: '1.2em', cursor: 'pointer', marginTop: '20px' }}>
          Book Now with Housecall Pro
        </button>
      </section>
    </div>
  );
};

export default Ballenger;
