import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Check, Heart, Shield, Star, Users } from "lucide-react";
import { Link } from "wouter";

export default function About() {
  return (
    <Layout>
      <SEO 
        title="About Us | Faith-Based Plumbers in Lubbock"
        description="Learn about Cotton City Plumbing's mission to serve Lubbock with honesty and integrity. Founded on Christian principles, we treat your home like our own."
        canonical="/about"
      />
      {/* Hero Section */}
      <section className="relative py-20 bg-primary text-white overflow-hidden">
        <div className="absolute inset-0 z-0">
          <div className="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')] opacity-10"></div>
          <div className="absolute right-0 top-0 w-1/2 h-full bg-white/5 skew-x-12 transform origin-top-right"></div>
        </div>
        <div className="container relative z-10">
          <div className="max-w-3xl">
            <h1 className="font-heading font-extrabold text-4xl md:text-6xl mb-6">Our Story & Mission</h1>
            <p className="text-xl text-primary-foreground/90 leading-relaxed">
              Founded on faith, built on integrity, and dedicated to serving the Lubbock community with excellence.
            </p>
          </div>
        </div>
      </section>

      {/* Founder & Story Section */}
      <section className="py-20 bg-background">
        <div className="container">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div className="relative">
              <div className="rounded-none overflow-hidden shadow-2xl">
                <img 
                  src="/images/team-photo-new.png" 
                  alt="Cotton City Plumbing Team - Professional Plumbers in Lubbock TX" 
                  className="w-full h-auto object-cover"
                />
              </div>
            </div>
            
            <div className="space-y-6">
              <h2 className="font-heading font-bold text-3xl text-primary">From F3 to Cotton City</h2>
              <p className="text-lg text-muted-foreground leading-relaxed">
                Our journey began in 2022 as F3 Plumbing, born from a divine calling to serve our community with a different kind of trade service—one rooted in faith and integrity. As we grew and deepened our connection to Lubbock, we evolved into **Cotton City Plumbing**, a name that honors the rich agricultural heritage of our home on the South Plains.
              </p>
              <p className="text-lg text-muted-foreground leading-relaxed">
                While our name changed, our mission remained the same: to provide honest, high-quality plumbing services while being a light in our community. We believe that inviting a tradesperson into your home requires trust, and we work hard every day to earn that trust.
              </p>
              <div className="pt-4">
                <h3 className="font-bold text-xl text-primary mb-4">Our Core Values</h3>
                <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
                  {[
                    { icon: <Heart className="h-5 w-5" />, text: "Faith-Based Service" },
                    { icon: <Shield className="h-5 w-5" />, text: "Uncompromising Integrity" },
                    { icon: <Star className="h-5 w-5" />, text: "Excellence in Craftsmanship" },
                    { icon: <Users className="h-5 w-5" />, text: "Community Focused" }
                  ].map((val, i) => (
                    <div key={i} className="flex items-center gap-3 bg-muted/30 p-3 rounded-lg">
                      <div className="text-secondary">{val.icon}</div>
                      <span className="font-medium">{val.text}</span>
                    </div>
                  ))}
                </div>
              </div>
            </div>
          </div>

          {/* Branded Van Photo */}
          <div className="mt-16">
            <div className="rounded-none overflow-hidden shadow-2xl">
              <img 
                src="/images/cotton-city-van.jpg" 
                alt="Cotton City Plumbing branded service van - Professional plumbing services in Lubbock TX" 
                className="w-full h-auto object-cover"
              />
            </div>
            <p className="text-center text-muted-foreground mt-4 text-lg">
              Our professional fleet is ready to serve Lubbock and surrounding areas
            </p>
          </div>
        </div>
      </section>

      {/* Values in Action - Universal Improvement */}
      <section className="py-20 bg-muted/30">
        <div className="container">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-primary mb-4">Our Values in Action</h2>
            <p className="text-lg text-muted-foreground">
              At Cotton City Plumbing, our faith isn't just something we talk about—it guides everything we do. Here's what that means for you:
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            {[
              {
                title: "Honesty First",
                desc: "We'll never recommend a service you don't need. If a repair is a better option than a replacement, we'll tell you. We treat your budget with respect.",
                icon: <Shield className="h-10 w-10" />
              },
              {
                title: "Transparent Pricing",
                desc: "No hidden fees, no surprise charges. We provide upfront pricing before we start any work, so you're never caught off guard.",
                icon: <Check className="h-10 w-10" />
              },
              {
                title: "Respect for Home",
                desc: "We treat your home like our own sanctuary. We use shoe covers, drop cloths, and clean up thoroughly after every job.",
                icon: <Heart className="h-10 w-10" />
              }
            ].map((item, index) => (
              <Card key={index} className="bg-white border-none shadow-md hover:shadow-xl transition-all duration-300 hover:-translate-y-1">
                <CardContent className="p-8 text-center">
                  <div className="bg-primary/5 text-primary p-4 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6">
                    {item.icon}
                  </div>
                  <h3 className="font-heading font-bold text-xl text-primary mb-4">{item.title}</h3>
                  <p className="text-muted-foreground leading-relaxed">{item.desc}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Community Involvement */}
      <section className="py-20 bg-background">
        <div className="container">
          <div className="bg-primary rounded-3xl overflow-hidden shadow-2xl">
            <div className="grid grid-cols-1 lg:grid-cols-2">
              <div className="p-12 flex flex-col justify-center text-white">
                <h2 className="font-heading font-bold text-3xl md:text-4xl mb-6">Serving Our Lubbock Community</h2>
                <p className="text-lg text-primary-foreground/90 mb-8 leading-relaxed">
                  As a locally owned and operated business, we're proud to be part of the Lubbock community. We actively support local churches, schools, and charities because we believe in giving back to the neighbors who support us.
                </p>
                <p className="text-lg text-primary-foreground/90 mb-8 leading-relaxed">
                  When you choose Cotton City Plumbing, you're not just hiring a plumber—you're supporting a local business that invests right back into the Hub City.
                </p>
                
                <div className="bg-white/10 backdrop-blur-sm rounded-xl p-6 mb-8">
                  <a href="https://foreverlychanged.com" target="_blank" rel="noopener noreferrer" className="flex items-center gap-4 mb-4 hover:opacity-80 transition-opacity">
                    <img src="/images/foreverly-changed-logo.webp" alt="ForEverly Changed" className="h-12 w-auto" />
                  </a>
                  <h3 className="font-heading font-bold text-xl mb-3">
                    Proud Sponsor of <a href="https://foreverlychanged.com" target="_blank" rel="noopener noreferrer" className="hover:underline">ForEverly Changed</a>
                  </h3>
                  <p className="text-primary-foreground/90 leading-relaxed">
                    We're honored to support <a href="https://foreverlychanged.com" target="_blank" rel="noopener noreferrer" className="hover:underline">ForEverly Changed</a>, a West Texas nonprofit that provides infant funeral assistance to families experiencing the unimaginable loss of a baby. Their compassionate mission aligns with our values of serving our community with love and integrity during life's most difficult moments.
                  </p>
                </div>
                <Link href="/contact">
                  <Button size="lg" className="bg-white text-primary hover:bg-gray-100 font-bold w-fit">
                    Contact Us Today
                  </Button>
                </Link>
              </div>
              <div className="relative h-64 lg:h-auto">
                <img 
                  src="/images/lubbock-community.png" 
                  alt="Cotton City Plumbing serving Lubbock Texas community" 
                  className="absolute inset-0 w-full h-full object-cover"
                />
                <div className="absolute inset-0 bg-primary/20 mix-blend-multiply"></div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
