export interface BlogPost {
  id: string;
  slug: string;
  title: string;
  excerpt: string;
  content: string;
  date: string;
  author: string;
  image: string;
}

export const blogPosts: BlogPost[] = [
  {
    id: "13",
    slug: "top-plumbing-issues-lubbock",
    title: "Top 5 Plumbing Issues in Lubbock, TX",
    excerpt: "Learn about the most common plumbing problems Lubbock homeowners face, from hard water damage to slab leaks. Expert advice from Cotton City Plumbing.",
    date: "2026-01-31",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: ""
  },
  {
    id: "12",
    slug: "west-texas-winter-pipes",
    title: "How to Prepare Your Pipes for West Texas Winters",
    excerpt: "Protect your Lubbock home from frozen and burst pipes this winter. Expert winterization tips from Cotton City Plumbing to prevent costly water damage.",
    date: "2026-01-31",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: ""
  },
  {
    id: "11",
    slug: "hard-water-plumbing-damage",
    title: "What Hard Water Does to Your Plumbing",
    excerpt: "Lubbock's hard water can damage your pipes, appliances, and fixtures. Learn how hard water affects your plumbing and what you can do to protect your home.",
    date: "2026-01-31",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: ""
  },
  {
    id: "10",
    slug: "slab-leak-detection-lubbock",
    title: "Slab Leak Detection: Protecting Your Lubbock Home's Foundation",
    excerpt: "Slab leaks can cause catastrophic damage to your foundation. Learn the warning signs, detection methods, and why early intervention is critical for Lubbock homeowners.",
    date: "2025-01-20",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: `
      <p>A slab leak occurs when water pipes running beneath your home's concrete foundation develop a leak. Because these pipes are buried under several inches of concrete, slab leaks often go undetected until significant damage has occurred. In Lubbock's clay-heavy soil, foundation shifts can put extra stress on pipes, making slab leaks a real concern for homeowners.</p>

      <h3>Warning Signs of a Slab Leak</h3>
      <ul>
        <li><strong>Unexplained increase in water bills:</strong> A sudden spike in your water usage without a clear reason often indicates a hidden leak.</li>
        <li><strong>Sound of running water:</strong> If you hear water running when all fixtures are off, water may be escaping beneath your slab.</li>
        <li><strong>Warm or cold spots on the floor:</strong> Hot water line leaks create warm spots, while cold water leaks may cause damp, cool areas.</li>
        <li><strong>Cracks in walls or flooring:</strong> As water erodes the soil beneath the slab, the foundation can shift and crack.</li>
        <li><strong>Mold or mildew smell:</strong> Persistent moisture under the slab creates ideal conditions for mold growth.</li>
      </ul>

      <h3>How We Detect Slab Leaks</h3>
      <p>At Cotton City Plumbing, we use advanced electronic leak detection equipment and pressure testing to pinpoint the exact location of the leak without unnecessary demolition. Our camera inspection technology allows us to see inside your pipes and identify the problem quickly and accurately.</p>

      <h3>Repair Options</h3>
      <p>Depending on the severity and location of the leak, we may recommend:</p>
      <ul>
        <li><strong>Spot repair:</strong> Accessing the pipe through the slab to fix the specific leak point.</li>
        <li><strong>Rerouting:</strong> Running new pipes through walls or attic spaces to bypass the damaged section.</li>
        <li><strong>Repiping:</strong> In cases of widespread corrosion or multiple leaks, replacing the entire system may be the most cost-effective long-term solution.</li>
      </ul>

      <p><strong>Don't ignore the signs.</strong> If you suspect a slab leak, contact Cotton City Plumbing immediately. Early detection can save you thousands in foundation and water damage repairs.</p>
    `
  },
  {
    id: "9",
    slug: "gas-line-safety-lubbock",
    title: "Gas Line Safety: What Every Lubbock Homeowner Should Know",
    excerpt: "Natural gas is efficient and affordable, but gas line leaks are extremely dangerous. Learn how to recognize a gas leak, what to do in an emergency, and why professional installation matters.",
    date: "2025-01-18",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: `
      <p>Natural gas is a popular energy source for heating, cooking, and water heating in Lubbock homes. While it's safe when properly installed and maintained, gas line leaks can pose serious risks including fire, explosion, and carbon monoxide poisoning. Understanding gas line safety is essential for every homeowner.</p>

      <h3>How to Recognize a Gas Leak</h3>
      <ul>
        <li><strong>Smell:</strong> Natural gas has a distinctive "rotten egg" odor (added for safety). If you smell it, take it seriously.</li>
        <li><strong>Sound:</strong> A hissing or whistling sound near a gas line or appliance indicates escaping gas.</li>
        <li><strong>Sight:</strong> Dead vegetation near gas lines, bubbles in standing water, or a white cloud or dust near a pipeline can signal a leak.</li>
        <li><strong>Physical symptoms:</strong> Headaches, dizziness, nausea, or fatigue can indicate carbon monoxide exposure from incomplete combustion.</li>
      </ul>

      <h3>What to Do If You Suspect a Gas Leak</h3>
      <ol>
        <li><strong>Evacuate immediately:</strong> Get everyone out of the house, including pets.</li>
        <li><strong>Don't use electronics or flames:</strong> Do not turn lights on or off, use phones, or create any spark that could ignite the gas.</li>
        <li><strong>Leave the door open:</strong> Allow gas to dissipate as you leave.</li>
        <li><strong>Call 911 and your gas company:</strong> Report the leak from a safe distance outside your home.</li>
        <li><strong>Call Cotton City Plumbing:</strong> Once the area is safe, we can inspect and repair the gas line professionally.</li>
      </ol>

      <h3>Professional Gas Line Services</h3>
      <p>Gas line work is not a DIY project. Texas law requires licensed plumbers to install, repair, and inspect gas lines. At Cotton City Plumbing, our Master Plumber has decades of experience with gas line installation for appliances, outdoor kitchens, fire pits, and whole-home systems.</p>

      <h3>Regular Inspections Save Lives</h3>
      <p>We recommend annual gas line inspections, especially if your home is over 20 years old or if you're installing new gas appliances. A small investment in preventative maintenance can prevent catastrophic damage and keep your family safe.</p>

      <p><strong>Need gas line installation or repair?</strong> Trust the licensed experts at Cotton City Plumbing. Call us today at (806) 441-4110.</p>
    `
  },
  {
    id: "8",
    slug: "water-heater-maintenance-tips",
    title: "Water Heater Maintenance: Extend the Life of Your Unit",
    excerpt: "Regular maintenance can add years to your water heater's lifespan and improve efficiency. Learn the simple tasks you can do yourself and when to call a professional.",
    date: "2025-01-16",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: `
      <p>Your water heater works hard every day to provide hot showers, clean dishes, and warm laundry. With proper maintenance, a traditional tank water heater can last 10-12 years, and a tankless unit can last 20+ years. Neglect it, and you'll face costly repairs or premature replacement. Here's how to keep your water heater running efficiently.</p>

      <h3>Annual Maintenance Tasks</h3>
      
      <h4>1. Flush the Tank (Tank Water Heaters)</h4>
      <p>Sediment from Lubbock's hard water settles at the bottom of your tank, reducing efficiency and causing premature wear. Flushing the tank once a year removes this buildup. Here's how:</p>
      <ul>
        <li>Turn off the power (electric) or set the gas valve to "pilot"</li>
        <li>Attach a garden hose to the drain valve and run it outside or to a floor drain</li>
        <li>Open the drain valve and let the water run until it's clear</li>
        <li>Close the valve, refill the tank, and restore power</li>
      </ul>
      <p><em>If you're not comfortable doing this yourself, Cotton City Plumbing offers professional water heater flushing services.</em></p>

      <h4>2. Test the Pressure Relief Valve</h4>
      <p>The temperature and pressure relief (TPR) valve is a critical safety feature that prevents your tank from exploding if pressure builds up. Test it annually by lifting the lever and letting it snap back. You should see a burst of water into the overflow tube. If nothing happens or the valve leaks afterward, it needs replacement.</p>

      <h4>3. Check the Anode Rod (Tank Water Heaters)</h4>
      <p>The anode rod attracts corrosive elements in the water, protecting the steel tank from rust. In Lubbock's hard water, this rod can deteriorate quickly. We recommend having it inspected every 3-5 years and replaced when it's heavily corroded.</p>

      <h4>4. Insulate Older Units</h4>
      <p>If your water heater is warm to the touch, it's losing heat (and money). Adding an insulation blanket can improve efficiency by up to 10%. Just be careful not to cover the thermostat, burner, or top of a gas unit.</p>

      <h3>Tankless Water Heater Maintenance</h3>
      <p>Tankless units also require annual maintenance, primarily descaling to remove mineral buildup from the heat exchanger. This is especially important in Lubbock due to hard water. We recommend professional descaling to avoid damaging the unit.</p>

      <h3>When to Call a Professional</h3>
      <p>If you notice any of these signs, don't wait—call Cotton City Plumbing:</p>
      <ul>
        <li>Rusty or discolored water</li>
        <li>Strange noises (popping, banging, rumbling)</li>
        <li>Leaks around the tank or connections</li>
        <li>Inconsistent water temperature</li>
        <li>Your unit is over 10 years old</li>
      </ul>

      <p><strong>Keep your water heater running strong.</strong> Schedule annual maintenance with Cotton City Plumbing and enjoy reliable hot water for years to come.</p>
    `
  },
  {
    id: "7",
    slug: "repiping-your-lubbock-home",
    title: "Is It Time to Repipe Your Lubbock Home? Signs and Solutions",
    excerpt: "Old, corroded pipes can cause low water pressure, leaks, and contaminated water. Learn when repiping makes sense and what to expect from the process.",
    date: "2025-01-14",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: `
      <p>If your Lubbock home was built before 1990, there's a good chance it has galvanized steel or polybutylene pipes—both of which are prone to failure. Repiping your home may sound like a major undertaking, but it's often the most cost-effective solution when you're facing repeated leaks, low water pressure, or water quality issues.</p>

      <h3>Signs You Need Repiping</h3>
      <ul>
        <li><strong>Frequent leaks:</strong> If you're calling a plumber multiple times a year for pipe leaks, the entire system may be corroding.</li>
        <li><strong>Discolored water:</strong> Rusty or brown water indicates corroded pipes that are contaminating your water supply.</li>
        <li><strong>Low water pressure:</strong> Mineral buildup and corrosion narrow the pipe diameter, reducing flow throughout your home.</li>
        <li><strong>Visible corrosion:</strong> If exposed pipes show rust, flaking, or discoloration, the hidden pipes are likely in the same condition.</li>
        <li><strong>Old pipe materials:</strong> Galvanized steel (common before 1960) and polybutylene (used 1970s-1990s) are known to fail prematurely.</li>
      </ul>

      <h3>What is Repiping?</h3>
      <p>Repiping involves replacing the old water supply pipes throughout your home with modern materials like PEX (cross-linked polyethylene) or copper. PEX is flexible, resistant to corrosion and scale buildup, and can be installed with minimal wall cutting. Copper is durable and has a proven track record, though it's more expensive.</p>

      <h3>The Repiping Process</h3>
      <p>Here's what to expect when you repipe with Cotton City Plumbing:</p>
      <ol>
        <li><strong>Inspection and estimate:</strong> We assess your current plumbing and provide a detailed quote.</li>
        <li><strong>Planning:</strong> We map out the new pipe routes to minimize disruption.</li>
        <li><strong>Installation:</strong> Our team carefully removes old pipes and installs new ones, typically completing the job in 2-5 days depending on home size.</li>
        <li><strong>Testing:</strong> We pressure-test the system to ensure there are no leaks.</li>
        <li><strong>Restoration:</strong> We patch and paint any access holes, leaving your home clean and functional.</li>
      </ol>

      <h3>Benefits of Repiping</h3>
      <ul>
        <li>Improved water pressure throughout your home</li>
        <li>Cleaner, better-tasting water</li>
        <li>Elimination of recurring leaks and water damage</li>
        <li>Increased home value and buyer confidence</li>
        <li>Peace of mind knowing your plumbing is reliable for decades</li>
      </ul>

      <h3>Is Repiping Worth It?</h3>
      <p>If you're facing multiple plumbing issues and your home is over 30 years old, repiping is often the smartest investment. It eliminates the constant cycle of repairs and protects your home from water damage. Plus, modern materials like PEX are designed to last 50+ years with minimal maintenance.</p>

      <p><strong>Concerned about your pipes?</strong> Contact Cotton City Plumbing for a free inspection and honest assessment. We'll help you decide if repiping is the right solution for your Lubbock home.</p>
    `
  },
  {
    id: "4",
    slug: "tank-vs-tankless-water-heaters",
    title: "Tank vs. Tankless Water Heaters: The Complete Guide for Lubbock Homeowners",
    excerpt: "Choosing the right water heater for your Lubbock home? This comprehensive guide breaks down costs ($1,600 vs $4,900), performance, hard water considerations, and which system is right for your family.",
    date: "2025-01-12",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: "" // Content is in dedicated page component
  },
  {
    id: "5",
    slug: "emergency-plumbing-signs",
    title: "5 Signs You Need Emergency Plumbing in Lubbock",
    excerpt: "Learn the critical warning signs that require immediate plumbing attention in Lubbock. From burst pipes to sewage backups, know when to call for emergency service.",
    date: "2025-01-10",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: "" // Content is in dedicated page component
  },
  {
    id: "6",
    slug: "frozen-pipes-prevention",
    title: "How to Prevent Frozen Pipes in West Texas Winters",
    excerpt: "Protect your Lubbock home from costly frozen pipe damage. Learn proven prevention strategies for West Texas winters, what to do if pipes freeze, and when to call for help.",
    date: "2025-01-08",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: "" // Content is in dedicated page component
  },
  {
    id: "1",
    slug: "signs-you-need-water-heater-repair",
    title: "5 Signs You Need Water Heater Repair Immediately",
    excerpt: "Is your water heater making strange noises or failing to provide hot water? Learn the top 5 warning signs that indicate you need professional repair before it's too late.",
    date: "2025-01-06",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: `
      <p>Your water heater is one of the most hardworking appliances in your home, but it's easy to take for granted until something goes wrong. Ignoring early warning signs can lead to cold showers, water damage, or even a burst tank. Here are the top 5 signs that you need to call Cotton City Plumbing for water heater repair immediately.</p>

      <h3>1. Strange Noises</h3>
      <p>If you hear popping, banging, or rumbling sounds coming from your water heater, it's likely due to sediment buildup at the bottom of the tank. As the sediment is heated, it hardens and bangs against the tank walls. This not only reduces efficiency but can also cause the tank to crack.</p>

      <h3>2. Rusty or Discolored Water</h3>
      <p>If your hot water comes out brown, rusty, or with a metallic smell, it could indicate that the inside of your tank is rusting. If left unchecked, the rust will eat through the steel tank, leading to a major leak. Note: If both hot and cold water are rusty, the issue might be with your pipes instead.</p>

      <h3>3. Lack of Hot Water</h3>
      <p>This is the most obvious sign. If your water never gets hot enough, or if you run out of hot water much faster than usual, a heating element or the thermostat may have failed. In gas units, it could be a pilot light or burner issue.</p>

      <h3>4. Leaking Around the Tank</h3>
      <p>Puddles of water around the base of your water heater are a serious red flag. While it could be a loose connection or a faulty relief valve, it often indicates a crack in the tank itself. A leaking tank cannot be repaired and must be replaced immediately to prevent flooding.</p>

      <h3>5. Age of the Unit</h3>
      <p>Most traditional tank water heaters last between 8 to 12 years. If your unit is nearing the end of its lifespan and starts acting up, it's often more cost-effective to replace it with a new, energy-efficient model rather than paying for repeated repairs.</p>

      <p><strong>Don't wait for a cold shower!</strong> If you notice any of these signs, contact Cotton City Plumbing today. Our expert technicians can diagnose the issue and recommend the best solution for your home.</p>
    `
  },
  {
    id: "2",
    slug: "hard-water-solutions-lubbock",
    title: "Dealing with Hard Water in Lubbock: Why You Need a Water Softener",
    excerpt: "Lubbock is known for its hard water, which can damage your pipes, appliances, and skin. Discover how a water softener can protect your home and improve your quality of life.",
    date: "2025-01-04",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: `
      <p>If you live in Lubbock, you're likely familiar with the effects of hard water. From crusty white buildup on your faucets to dry, itchy skin after a shower, hard water is a common nuisance in West Texas. But did you know it can also cause serious damage to your home's plumbing?</p>

      <h3>What is Hard Water?</h3>
      <p>Hard water contains high levels of dissolved minerals, primarily calcium and magnesium. While not harmful to drink, these minerals wreak havoc on your plumbing system over time.</p>

      <h3>The Hidden Costs of Hard Water</h3>
      <ul>
        <li><strong>Scale Buildup:</strong> Minerals accumulate inside your pipes, reducing water flow and increasing pressure, which can lead to leaks.</li>
        <li><strong>Appliance Damage:</strong> Water heaters, dishwashers, and washing machines have to work harder to heat and process hard water, shortening their lifespan and increasing energy bills.</li>
        <li><strong>Faded Laundry:</strong> Hard water traps detergent in fabric fibers, leaving clothes stiff, dingy, and wearing out faster.</li>
      </ul>

      <h3>The Solution: Whole-Home Water Softeners</h3>
      <p>A water softener removes the calcium and magnesium ions from your water supply, replacing them with sodium ions. The result is "soft" water that is gentle on your pipes, appliances, and body.</p>

      <h3>Benefits of Installing a Water Softener</h3>
      <p>With a Navien or similar high-quality water softener installed by Cotton City Plumbing, you'll enjoy:</p>
      <ul>
        <li>Cleaner, spot-free dishes and glassware</li>
        <li>Softer, healthier skin and hair</li>
        <li>Brighter, softer laundry</li>
        <li>Longer-lasting appliances and plumbing fixtures</li>
        <li>Lower energy bills due to improved water heater efficiency</li>
      </ul>

      <p>Ready to banish hard water from your home? Contact us today to discuss our water treatment options tailored for Lubbock's water quality.</p>
    `
  },
  {
    id: "3",
    slug: "prevent-clogged-drains",
    title: "Simple Tips to Prevent Clogged Drains in Your Kitchen and Bathroom",
    excerpt: "Clogged drains are a major inconvenience. Learn simple, proactive steps you can take to keep your pipes flowing freely and avoid costly plumbing visits.",
    date: "2025-01-02",
    author: "Cotton City Team",
    image: "/images/hero-truck.png",
    content: `
      <p>A clogged drain can disrupt your entire day, leading to slow drainage, foul odors, and even sewage backups. While some clogs are inevitable, many can be prevented with a few simple changes to your daily habits.</p>

      <h3>In the Kitchen</h3>
      <p><strong>Grease is the Enemy:</strong> Never pour cooking oil, bacon grease, or fat down the drain. As it cools, it solidifies and traps other debris, creating stubborn blockages. Instead, pour grease into a container and throw it in the trash.</p>
      <p><strong>Watch What Your Garbage Disposal Eats:</strong> Avoid putting fibrous foods (celery, corn husks), starchy foods (pasta, rice, potato peels), or coffee grounds down the disposal. These can tangle blades or expand in pipes to cause clogs.</p>

      <h3>In the Bathroom</h3>
      <p><strong>Catch the Hair:</strong> Hair is the #1 cause of bathroom drain clogs. Install a simple hair catcher or mesh screen over your shower and tub drains, and clean it out regularly.</p>
      <p><strong>Flush Only Toilet Paper:</strong> "Flushable" wipes are a marketing myth. They do not break down like toilet paper and are a leading cause of major sewer line blockages. Stick to the 3 Ps: Pee, Poo, and (Toilet) Paper.</p>

      <h3>Routine Maintenance</h3>
      <p>Once a month, pour a kettle of boiling water down your drains to melt away soap scum and minor grease buildup. You can also use a mixture of baking soda and vinegar followed by hot water for a natural, fizzy cleaner that helps keep pipes fresh.</p>

      <p>If you've tried these tips and still have a slow drain, don't reach for harsh chemical drain cleaners—they can damage your pipes. Call the pros at Cotton City Plumbing for safe, effective drain cleaning services.</p>
    `
  }
];
