import { useEffect } from "react";

export default function LocalBusinessSchema() {
  useEffect(() => {
    // Create JSON-LD structured data for LocalBusiness
    const schemaData = {
      "@context": "https://schema.org",
      "@type": "Plumber",
      "@id": "https://cottoncityplumbing.com",
      "name": "Cotton City Plumbing",
      "image": "https://cottoncityplumbing.com/images/cotton-city-logo.png",
      "logo": "https://cottoncityplumbing.com/images/cotton-city-logo.png",
      "url": "https://cottoncityplumbing.com",
      "telephone": "+18064414110",
      "email": "services@cottoncityplumbing.com",
      "priceRange": "$$",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "1306 146th Street",
        "addressLocality": "Lubbock",
        "addressRegion": "TX",
        "postalCode": "79423",
        "addressCountry": "US"
      },
      "geo": {
        "@type": "GeoCoordinates",
        "latitude": 33.4619721,
        "longitude": -101.8497587
      },
      "areaServed": [
        {
          "@type": "City",
          "name": "Lubbock",
          "sameAs": "https://en.wikipedia.org/wiki/Lubbock,_Texas"
        },
        {
          "@type": "City",
          "name": "Wolfforth"
        },
        {
          "@type": "City",
          "name": "Shallowater"
        },
        {
          "@type": "City",
          "name": "Slaton"
        },
        {
          "@type": "City",
          "name": "Idalou"
        }
      ],
      "openingHoursSpecification": [
        {
          "@type": "OpeningHoursSpecification",
          "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
          "opens": "07:00",
          "closes": "19:00"
        },
        {
          "@type": "OpeningHoursSpecification",
          "dayOfWeek": "Saturday",
          "opens": "08:00",
          "closes": "12:00"
        }
      ],
      "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "4.9",
        "reviewCount": "302",
        "bestRating": "5",
        "worstRating": "1"
      },
      "hasOfferCatalog": {
        "@type": "OfferCatalog",
        "name": "Plumbing Services",
        "itemListElement": [
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Emergency Plumbing",
              "description": "Same-day emergency plumbing services for burst pipes, severe clogs, and urgent repairs"
            }
          },
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Water Heater Installation & Repair",
              "description": "Expert installation and repair of tank and tankless water heaters"
            }
          },
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Drain Cleaning",
              "description": "Professional drain cleaning and clog removal services"
            }
          },
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Leak Detection",
              "description": "Advanced leak detection using camera inspection technology"
            }
          },
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Gas Line Services",
              "description": "Gas line installation, repair, and safety inspections"
            }
          },
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Water Treatment",
              "description": "Water softener and filtration system installation"
            }
          },
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Slab Leak Repair",
              "description": "Expert detection and repair of slab leaks"
            }
          },
          {
            "@type": "Offer",
            "itemOffered": {
              "@type": "Service",
              "name": "Commercial Plumbing",
              "description": "Comprehensive plumbing services for commercial properties"
            }
          }
        ]
      },
      "sameAs": [
        "https://www.facebook.com/cottoncityplumbing",
        "https://www.instagram.com/cottoncityplumbing"
      ],
      "additionalType": "http://www.productontology.org/id/Plumber",
      "slogan": "We Make Sure Everything Runs Through Lubbock",
      "description": "Lubbock's trusted, faith-based plumbing experts. From emergency repairs to new installations, we serve our neighbors with honesty, integrity, and excellence.",
      "foundingDate": "2022",
      "founder": {
        "@type": "Person",
        "name": "Cotton City Plumbing Team"
      },
      "knowsAbout": [
        "Plumbing",
        "Water Heater Installation",
        "Drain Cleaning",
        "Leak Detection",
        "Gas Line Services",
        "Emergency Plumbing",
        "Commercial Plumbing",
        "Residential Plumbing"
      ],
      "paymentAccepted": "Cash, Credit Card, Check, Financing Available",
      "currenciesAccepted": "USD"
    };

    // Create script element
    const script = document.createElement("script");
    script.type = "application/ld+json";
    script.text = JSON.stringify(schemaData);
    script.id = "local-business-schema";

    // Remove existing LocalBusiness schema if present
    const existingSchema = document.getElementById("local-business-schema");
    if (existingSchema) {
      existingSchema.remove();
    }

    // Add to document head
    document.head.appendChild(script);

    // Cleanup on unmount
    return () => {
      const schemaToRemove = document.getElementById("local-business-schema");
      if (schemaToRemove) {
        schemaToRemove.remove();
      }
    };
  }, []);

  return null; // This component doesn't render anything visible
}
