import { useEffect } from "react";

interface FAQ {
  question: string;
  answer: string;
}

interface FAQSchemaProps {
  faqs: FAQ[];
}

export default function FAQSchema({ faqs }: FAQSchemaProps) {
  useEffect(() => {
    // Create JSON-LD structured data for FAQPage
    const schemaData = {
      "@context": "https://schema.org",
      "@type": "FAQPage",
      "mainEntity": faqs.map(faq => ({
        "@type": "Question",
        "name": faq.question,
        "acceptedAnswer": {
          "@type": "Answer",
          "text": faq.answer
        }
      }))
    };

    // Create script element
    const script = document.createElement("script");
    script.type = "application/ld+json";
    script.text = JSON.stringify(schemaData);
    script.id = "faq-schema";

    // Remove existing FAQ schema if present
    const existingSchema = document.getElementById("faq-schema");
    if (existingSchema) {
      existingSchema.remove();
    }

    // Add to document head
    document.head.appendChild(script);

    // Cleanup on unmount
    return () => {
      const schemaToRemove = document.getElementById("faq-schema");
      if (schemaToRemove) {
        schemaToRemove.remove();
      }
    };
  }, [faqs]);

  return null; // This component doesn't render anything visible
}
