import { Toaster } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/NotFound";
import { Route, Switch, useLocation } from "wouter";
import { Toaster as SonnerToaster } from "sonner";
import ErrorBoundary from "./components/ErrorBoundary";
import { ThemeProvider } from "./contexts/ThemeContext";
import { useEffect } from "react";
import Home from "./pages/Home";
import About from "./pages/About";
import Gallery from "./pages/Gallery";
import RecentJobs from "./pages/RecentJobs";
import Financing from "./pages/Financing";
import Warranty from "./pages/Warranty";
import Contact from "./pages/Contact";
import PrivacyPolicy from "./pages/PrivacyPolicy";
import Services from "./pages/Services";
import WaterHeaters from "./pages/services/WaterHeaters";
import DrainCleaning from "./pages/services/DrainCleaning";
import EmergencyPlumbing from "./pages/services/EmergencyPlumbing";
import LeakDetection from "./pages/services/LeakDetection";
import GasLines from "./pages/services/GasLines";
import WaterTreatment from "@/pages/services/WaterTreatment";
import SewerRepair from "@/pages/services/SewerRepair";
import Repiping from "@/pages/services/Repiping";
import CommercialPlumbing from "@/pages/services/CommercialPlumbing";
import Fixtures from "@/pages/services/Fixtures";
import Appliances from "@/pages/services/Appliances";
import Valves from "@/pages/services/Valves";
import SlabLeaks from "./pages/services/SlabLeaks";
import Wolfforth from "@/pages/areas/Wolfforth";
import Slaton from "@/pages/areas/Slaton";
import Shallowater from "@/pages/areas/Shallowater";
import Levelland from "@/pages/areas/Levelland";
import Idalou from "@/pages/areas/Idalou";
import Abernathy from "@/pages/areas/Abernathy";
import Woodrow from "@/pages/Woodrow";
import NewHome from "@/pages/NewHome";
import LubbockCooper from "@/pages/LubbockCooper";
import SouthFork from "@/pages/SouthFork";
import DavisPark from "@/pages/DavisPark";
import TheRidge from "@/pages/TheRidge";
import TechTerrace from "@/pages/TechTerrace";
import MaxeyPark from "@/pages/MaxeyPark";
import HeartOfLubbock from "@/pages/HeartOfLubbock";
import NorthOverton from "@/pages/NorthOverton";
import SouthOverton from "@/pages/SouthOverton";
import WheelockAndMonterey from "@/pages/WheelockAndMonterey";
import MaedgenArea from "@/pages/MaedgenArea";
import ClappPark from "@/pages/ClappPark";
import ArnettBenson from "@/pages/ArnettBenson";
import Guadalupe from "@/pages/Guadalupe";
import MeloniePark from "@/pages/MeloniePark";
import Lakeridge from "@/pages/Lakeridge";
import Raintree from "@/pages/Raintree";
import RemingtonPark from "@/pages/RemingtonPark";
import QuakerHeights from "@/pages/QuakerHeights";
import VintageTownship from "@/pages/VintageTownship";
import StubbsStewart from "@/pages/StubbsStewart";
import PrestonSmith from "@/pages/PrestonSmith";
import KingsPark from "@/pages/KingsPark";
import KelseyPark from "@/pages/KelseyPark";
import FoxRidge from "@/pages/FoxRidge";
import ShadowHills from "@/pages/ShadowHills";
import Westwind from "@/pages/Westwind";
import WestLubbock from "@/pages/WestLubbock";
import Coronado from "@/pages/Coronado";
import Frenship from "@/pages/Frenship";
import Westchester from "@/pages/Westchester";
import NorthWestLubbock from "@/pages/NorthWestLubbock";
import Monterey from "@/pages/Monterey";
import GreenAcres from "@/pages/GreenAcres";
import Carlisle from "@/pages/Carlisle";
import Chatman from "@/pages/Chatman";
import EastLubbock from "@/pages/EastLubbock";
import Ballenger from "@/pages/Ballenger";
import BaylessAtkins from "@/pages/BaylessAtkins";
import Bowie from "@/pages/Bowie";
import BrookeHeights from "@/pages/BrookeHeights";
import BuffaloSprings from "@/pages/BuffaloSprings";
import ChaparralRidge from "@/pages/ChaparralRidge";
import CedarCreek from "@/pages/CedarCreek";
import Cimarron from "@/pages/Cimarron";
import DunbarManhattanHeights from "@/pages/DunbarManhattanHeights";
import Harwell from "@/pages/Harwell";
import HighlandOaks from "@/pages/HighlandOaks";
import JacksonMahon from "@/pages/JacksonMahon";
import LubbockCountryClub from "@/pages/LubbockCountryClub";
import MeadowsSouth from "@/pages/MeadowsSouth";
import Northridge from "@/pages/Northridge";
import OrchardPark from "@/pages/OrchardPark";
import Parkway from "@/pages/Parkway";
import SlatonBean from "@/pages/SlatonBean";
import SpanishOaks from "@/pages/SpanishOaks";
import NewDeal from "@/pages/areas/NewDeal";
import Smyer from "@/pages/areas/Smyer";
import Ropesville from "@/pages/areas/Ropesville";
import TermsOfUse from "@/pages/TermsOfUse";
import AdminJobPins from "@/pages/AdminJobPins";
import JobPinDetail from "@/pages/JobPinDetail";
import Blog from "@/pages/Blog";
import TankVsTanklessBlog from "@/pages/blog/TankVsTankless";
import EmergencyPlumbingSignsBlog from "@/pages/blog/EmergencyPlumbingSigns";
import FrozenPipesPrevention from "@/pages/blog/FrozenPipesPrevention";
import WaterHeaterRepair from "@/pages/blog/WaterHeaterRepair";
import HardWaterSolutions from "@/pages/blog/HardWaterSolutions";
import PreventCloggedDrains from "@/pages/blog/PreventCloggedDrains";
import TopPlumbingIssuesLubbock from "@/pages/blog/TopPlumbingIssuesLubbock";
import WestTexasWinterPipes from "@/pages/blog/WestTexasWinterPipes";
import HardWaterPlumbingDamage from "@/pages/blog/HardWaterPlumbingDamage";


// Placeholder for other service pages to prevent 404s during demo
const ServicePlaceholder = () => (
  <div className="min-h-screen flex items-center justify-center bg-background">
    <div className="text-center p-8">
      <h1 className="text-4xl font-bold text-primary mb-4">Service Page Coming Soon</h1>
      <p className="text-muted-foreground mb-8">We are currently building this detailed service page.</p>
      <a href="/" className="text-secondary font-bold hover:underline">Return Home</a>
    </div>
  </div>
);
function Router() {
  // make sure to consider if you need authentication for certain routes
  const [location] = useLocation();
  
  // Scroll to top on route change
  useEffect(() => {
    window.scrollTo(0, 0);
  }, [location]);
  
  return (
    <Switch>
      <Route path="/" component={Home} />
      <Route path="/about" component={About} />
      <Route path="/gallery" component={Gallery} />
      <Route path="/recent-jobs" component={RecentJobs} />
      <Route path="/recent-jobs/:id" component={JobPinDetail} />
      <Route path="/financing" component={Financing} />
      <Route path="/warranty" component={Warranty} />
      <Route path="/contact" component={Contact} />
      <Route path="/privacy-policy" component={PrivacyPolicy} />
      
      {/* Service Routes */}
      <Route path="/services" component={Services} />
      <Route path="/services/water-heaters" component={WaterHeaters} />
      <Route path="/services/drain-cleaning" component={DrainCleaning} />
      <Route path="/services/emergency-plumbing" component={EmergencyPlumbing} />
      <Route path="/services/leak-detection" component={LeakDetection} />
      <Route path="/services/gas-lines" component={GasLines} />
      <Route path="/services/water-treatment" component={WaterTreatment} />
      <Route path="/services/sewer-repair" component={SewerRepair} />
      <Route path="/services/repiping" component={Repiping} />
      <Route path="/services/commercial" component={CommercialPlumbing} />
      <Route path="/services/fixtures" component={Fixtures} />
      <Route path="/services/appliances" component={Appliances} />
      <Route path="/services/valves" component={Valves} />
      <Route path="/services/slab-leaks" component={SlabLeaks} />
      <Route path="/areas/wolfforth" component={Wolfforth} />
      <Route path="/areas/slaton" component={Slaton} />
      <Route path="/areas/shallowater" component={Shallowater} />
      <Route path="/areas/levelland" component={Levelland} />
      <Route path="/areas/idalou" component={Idalou} />
      <Route path="/areas/abernathy" component={Abernathy} />
      <Route path="/areas/woodrow" component={Woodrow} />
      <Route path="/areas/new-home" component={NewHome} />
      <Route path="/areas/lubbock-cooper" component={LubbockCooper} />
      <Route path="/areas/south-fork" component={SouthFork} />
      <Route path="/areas/davis-park" component={DavisPark} />
      <Route path="/areas/the-ridge" component={TheRidge} />
      <Route path="/areas/tech-terrace" component={TechTerrace} />
      <Route path="/areas/maxey-park" component={MaxeyPark} />
      <Route path="/areas/heart-of-lubbock" component={HeartOfLubbock} />
      <Route path="/areas/north-overton" component={NorthOverton} />
      <Route path="/areas/south-overton" component={SouthOverton} />
      <Route path="/areas/wheelock-and-monterey" component={WheelockAndMonterey} />
      <Route path="/areas/maedgen-area" component={MaedgenArea} />
      <Route path="/areas/clapp-park" component={ClappPark} />
      <Route path="/areas/arnett-benson" component={ArnettBenson} />
      <Route path="/areas/guadalupe" component={Guadalupe} />
      <Route path="/areas/melonie-park" component={MeloniePark} />
      <Route path="/areas/lakeridge" component={Lakeridge} />
      <Route path="/areas/raintree-lubbock" component={Raintree} />
      <Route path="/areas/remington-park" component={RemingtonPark} />
      <Route path="/areas/quaker-heights" component={QuakerHeights} />
      <Route path="/areas/vintage-township" component={VintageTownship} />
      <Route path="/areas/stubbs-stewart" component={StubbsStewart} />
      <Route path="/areas/preston-smith" component={PrestonSmith} />
      <Route path="/areas/kings-park" component={KingsPark} />
      <Route path="/areas/kelsey-park" component={KelseyPark} />
      <Route path="/areas/fox-ridge" component={FoxRidge} />
      <Route path="/areas/shadow-hills" component={ShadowHills} />
      <Route path="/areas/westwind" component={Westwind} />
      <Route path="/areas/west-lubbock" component={WestLubbock} />
      <Route path="/areas/coronado" component={Coronado} />
      <Route path="/areas/frenship" component={Frenship} />
      <Route path="/areas/westchester" component={Westchester} />
      <Route path="/areas/north-west-lubbock" component={NorthWestLubbock} />
      <Route path="/areas/monterey" component={Monterey} />
      <Route path="/areas/green-acres" component={GreenAcres} />
      <Route path="/areas/carlisle" component={Carlisle} />
      <Route path="/areas/chatman" component={Chatman} />
      <Route path="/areas/east-lubbock" component={EastLubbock} />
      <Route path="/areas/ballenger" component={Ballenger} />
      <Route path="/areas/bayless-atkins" component={BaylessAtkins} />
      <Route path="/areas/bowie" component={Bowie} />
      <Route path="/areas/brooke-heights" component={BrookeHeights} />
      <Route path="/areas/buffalo-springs" component={BuffaloSprings} />
      <Route path="/areas/chaparral-ridge" component={ChaparralRidge} />
      <Route path="/areas/cedar-creek" component={CedarCreek} />
      <Route path="/areas/cimarron" component={Cimarron} />
      <Route path="/areas/dunbar-manhattan-heights" component={DunbarManhattanHeights} />
      <Route path="/areas/harwell" component={Harwell} />
      <Route path="/areas/highland-oaks" component={HighlandOaks} />
      <Route path="/areas/jackson-mahon" component={JacksonMahon} />
      <Route path="/areas/lubbock-country-club" component={LubbockCountryClub} />
      <Route path="/areas/meadows-south" component={MeadowsSouth} />
      <Route path="/areas/northridge" component={Northridge} />
      <Route path="/areas/orchard-park" component={OrchardPark} />
      <Route path="/areas/parkway" component={Parkway} />
      <Route path="/areas/slaton-bean" component={SlatonBean} />
      <Route path="/areas/spanish-oaks" component={SpanishOaks} />
      <Route path="/areas/new-deal" component={NewDeal} />
      <Route path="/areas/smyer" component={Smyer} />
      <Route path="/areas/ropesville" component={Ropesville} />
      <Route path="/terms-of-use" component={TermsOfUse} />
      
      {/* Blog Routes */}
      <Route path="/blog" component={Blog} />
      <Route path="/blog/tank-vs-tankless-water-heaters" component={TankVsTanklessBlog} />
      <Route path="/blog/emergency-plumbing-signs" component={EmergencyPlumbingSignsBlog} />
         <Route path="/blog/frozen-pipes-prevention" component={FrozenPipesPrevention} />
        <Route path="/blog/signs-you-need-water-heater-repair" component={WaterHeaterRepair} />
        <Route path="/blog/hard-water-solutions-lubbock" component={HardWaterSolutions} />
        <Route path="/blog/prevent-clogged-drains" component={PreventCloggedDrains} />
        <Route path="/blog/top-plumbing-issues-lubbock" component={TopPlumbingIssuesLubbock} />
        <Route path="/blog/west-texas-winter-pipes" component={WestTexasWinterPipes} />
        <Route path="/blog/hard-water-plumbing-damage" component={HardWaterPlumbingDamage} />
      
      {/* Admin Routes */}
      <Route path="/admin/job-pins" component={AdminJobPins} />

      



      <Route path="/404" component={NotFound} />
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <ErrorBoundary>
      <ThemeProvider defaultTheme="light">
        <TooltipProvider>
          <Toaster />
          <SonnerToaster position="top-right" richColors />
          <Router />
        </TooltipProvider>
      </ThemeProvider>
    </ErrorBoundary>
  );
}

export default App;
