# Post-Launch Checklist
## Cotton City Plumbing Website - Complete Setup Guide

Congratulations on launching your new Cotton City Plumbing website! This checklist will guide you through the essential post-launch tasks to maximize your SEO, local visibility, and lead generation.

---

## 🚀 Launch Day (Day 1)

### Immediate Actions

- [ ] **Publish the website** via Manus dashboard (click "Publish" button)
- [ ] **Verify website is live** at www.cottoncityplumbing.com
- [ ] **Test all pages load correctly** (homepage, services, contact, recent jobs)
- [ ] **Test contact form** sends emails to services@cottoncityplumbing.com
- [ ] **Test phone numbers** are clickable and dial (806) 441-4110
- [ ] **Test Housecall Pro booking widget** opens correctly
- [ ] **Verify Cotton Pins integration** shows job pins on Recent Jobs page

### Quick SEO Checks

- [ ] **Test sitemap** loads at www.cottoncityplumbing.com/sitemap.xml
- [ ] **Verify robots.txt** loads at www.cottoncityplumbing.com/robots.txt
- [ ] **Check meta tags** on homepage (right-click → View Page Source → search for "meta")
- [ ] **Verify Google Analytics** is tracking (if installed)

---

## 📊 Week 1: Google Search Console Setup

**Goal:** Get your website indexed by Google as fast as possible.

### Step 1: Create Account & Add Property

- [ ] Go to [https://search.google.com/search-console](https://search.google.com/search-console)
- [ ] Sign in with your Google account
- [ ] Click **"Add Property"**
- [ ] Choose **"Domain"** and enter: `cottoncityplumbing.com`
- [ ] Click **"Continue"**

### Step 2: Verify Ownership

- [ ] Google will show you a verification meta tag
- [ ] Copy the entire `<meta name="google-site-verification" content="...">` tag
- [ ] Send the tag to Manus AI to add to your website
- [ ] Wait for confirmation that tag is added
- [ ] Return to Google Search Console and click **"Verify"**

### Step 3: Submit Sitemap

- [ ] In Google Search Console, click **"Sitemaps"** in left sidebar
- [ ] Under "Add a new sitemap", enter: `sitemap.xml`
- [ ] Click **"Submit"**
- [ ] Wait 24-48 hours for Google to process

### Step 4: Enable Notifications

- [ ] Click **Settings** icon (gear) in top-right
- [ ] Click **"Users and permissions"**
- [ ] Verify your email is listed
- [ ] Enable email notifications for critical errors

**📖 Full Guide:** See `GOOGLE_SEARCH_CONSOLE_GUIDE.md` for detailed instructions and troubleshooting.

---

## 🗺️ Week 1: Google My Business Update

**Goal:** Update your GMB listing to point to your new website.

### Step 1: Access GMB Dashboard

- [ ] Go to [https://business.google.com](https://business.google.com)
- [ ] Sign in with the Google account that manages your business
- [ ] Click on **"Cotton City Plumbing"**

**Don't have access?**
- [ ] Request access from Aligned by Design (if they currently manage it)
- [ ] Follow ownership transfer process in the guide

### Step 2: Update Website URL

- [ ] Click **"Info"** in left sidebar
- [ ] Find **"Website"** section
- [ ] Click the pencil icon (✏️)
- [ ] Delete old URL
- [ ] Enter new URL: `https://www.cottoncityplumbing.com`
- [ ] Click **"Apply"**

### Step 3: Verify Change

- [ ] Wait 24-48 hours for change to propagate
- [ ] Search "Cotton City Plumbing Lubbock" on Google
- [ ] Click **"Website"** button in Knowledge Panel
- [ ] Confirm it opens your new Manus website

### Step 4: Optimize GMB Listing (Recommended)

- [ ] Update business description with keywords
- [ ] Add all services (water heaters, drain cleaning, emergency, etc.)
- [ ] Confirm business hours are accurate
- [ ] Upload 10+ high-quality photos
- [ ] Enable messaging feature
- [ ] Respond to all existing reviews

**📖 Full Guide:** See `GOOGLE_MY_BUSINESS_GUIDE.md` for detailed instructions and optimization tips.

---

## 🔄 Week 1-2: Cotton Pins Monitoring Setup

**Goal:** Ensure job pins from technicians sync correctly to website.

### Daily Health Check (2 minutes)

- [ ] Visit [www.cottoncityplumbing.com/recent-jobs](https://www.cottoncityplumbing.com/recent-jobs)
- [ ] Verify job pins appear on map
- [ ] Verify job cards display below map
- [ ] Check that latest job uploaded by technicians is visible

### Weekly Monitoring

- [ ] Count total job pins (baseline: 26 pins)
- [ ] Verify photos are loading correctly
- [ ] Spot-check 3-5 jobs for accurate addresses and GPS
- [ ] Delete any test data or low-quality uploads

### Technician Training

- [ ] Share Cotton Pins upload best practices with team
- [ ] Emphasize photo quality (well-lit, clear, professional)
- [ ] Require GPS enabled for accurate location
- [ ] Encourage uploads immediately after completing jobs

**📖 Full Guide:** See `COTTON_PINS_MONITORING_GUIDE.md` for troubleshooting and advanced monitoring.

---

## 📱 Week 2: Social Media & Directory Updates

**Goal:** Update all online listings to point to your new website.

### Update Social Media Profiles

- [ ] **Facebook:** Update website URL in "About" section
- [ ] **Instagram:** Update website link in bio
- [ ] **LinkedIn:** Update company website URL
- [ ] **Nextdoor:** Update business profile website
- [ ] **Yelp:** Update website URL (if you have a listing)

### Update Business Directories

- [ ] **BBB (Better Business Bureau):** Update website URL
- [ ] **Angi (formerly Angie's List):** Update profile if listed
- [ ] **HomeAdvisor:** Update profile if listed
- [ ] **Thumbtack:** Update profile if listed
- [ ] **Yellow Pages:** Update or claim listing

### Update Marketing Materials

- [ ] **Business cards:** Verify they show correct website
- [ ] **Truck wraps:** Check if website URL is visible and correct
- [ ] **Yard signs:** Update if they include website URL
- [ ] **Invoices/receipts:** Update footer with new website
- [ ] **Email signatures:** Update all team members' signatures

---

## 📧 Week 2-3: Email & Communication Setup

**Goal:** Ensure all customer communications reference the new website.

### Email Setup

- [ ] Verify services@cottoncityplumbing.com is receiving contact form submissions
- [ ] Set up auto-reply for contact form submissions
- [ ] Update email signature for all team members
- [ ] Test that emails aren't going to spam

### Phone System

- [ ] Update voicemail to mention website: "Visit us online at cottoncityplumbing.com"
- [ ] Train office staff to mention website when booking appointments
- [ ] Add website to hold music/messages

### Customer Follow-Up

- [ ] Create email template for post-job follow-up (include website link)
- [ ] Create SMS template for review requests (include website link)
- [ ] Update invoice footer with website URL

---

## 🎯 Month 1: Marketing & Promotion

**Goal:** Drive traffic to your new website and build awareness.

### Content Marketing

- [ ] Share blog posts on social media (3 posts per week)
- [ ] Create Google My Business posts linking to website (1 per week)
- [ ] Email existing customers announcing new website
- [ ] Add website URL to all outgoing invoices

### Paid Advertising (Optional)

- [ ] Set up Google Ads campaign targeting local keywords
- [ ] Create Facebook/Instagram ads promoting services
- [ ] Use website URL as landing page for all ads

### Offline Marketing

- [ ] Print new business cards with website URL
- [ ] Add website to truck wraps/magnets
- [ ] Include website on all printed materials (flyers, mailers, etc.)

---

## 📈 Month 1: Analytics & Tracking Setup

**Goal:** Measure website performance and lead generation.

### Google Analytics (Recommended)

- [ ] Create Google Analytics 4 account
- [ ] Add tracking code to website (contact Manus AI for help)
- [ ] Set up conversion goals (contact form submissions, phone clicks)
- [ ] Link Google Analytics to Google Search Console

### Call Tracking (Optional)

- [ ] Sign up for call tracking service (CallRail, CallTrackingMetrics, etc.)
- [ ] Get unique phone number for website
- [ ] Update website with tracking number
- [ ] Monitor which pages drive the most calls

### Lead Tracking

- [ ] Create spreadsheet to track lead sources
- [ ] Ask new customers "How did you find us?"
- [ ] Track conversions from website vs. other sources

---

## 🔍 Month 2-3: SEO Monitoring & Optimization

**Goal:** Monitor search rankings and optimize for better visibility.

### Google Search Console Monitoring

- [ ] Check **"Performance"** report weekly
- [ ] Identify top-performing pages and keywords
- [ ] Monitor **"Coverage"** report for indexing errors
- [ ] Track impressions and clicks over time

### Keyword Ranking

- [ ] Track rankings for key terms:
  - "plumber Lubbock"
  - "water heater installation Lubbock"
  - "emergency plumber Lubbock"
  - "drain cleaning Lubbock"
  - "Cotton City Plumbing"

### Content Optimization

- [ ] Identify low-performing pages
- [ ] Add more content to thin pages (< 300 words)
- [ ] Optimize meta titles and descriptions
- [ ] Add internal links between related pages

### Local SEO

- [ ] Ensure NAP (Name, Address, Phone) is consistent across all listings
- [ ] Build citations on local directories
- [ ] Encourage customer reviews on Google, Facebook, Yelp
- [ ] Create location-specific content (neighborhood guides, service area pages)

---

## 🎓 Ongoing: Training & Maintenance

**Goal:** Keep website updated and team trained on best practices.

### Monthly Tasks

- [ ] Review Google Search Console performance
- [ ] Respond to all new Google reviews
- [ ] Upload 5-10 new photos to GMB listing
- [ ] Create 1-2 new blog posts
- [ ] Check for broken links or errors
- [ ] Monitor Cotton Pins sync (count job pins)
- [ ] Update service pages with new products/pricing (if applicable)

### Quarterly Tasks

- [ ] Analyze SEO performance (rankings, traffic, leads)
- [ ] Update team photos if staff changes
- [ ] Refresh homepage content/offers
- [ ] Review and update service descriptions
- [ ] Clean up old/low-quality job pins
- [ ] Test website speed and mobile responsiveness

### Annual Tasks

- [ ] Renew domain name (cottoncityplumbing.com)
- [ ] Review and update all service pages
- [ ] Refresh blog content (update old posts)
- [ ] Update awards/certifications
- [ ] Conduct competitor analysis
- [ ] Plan website improvements for next year

---

## 🚨 Troubleshooting Quick Reference

### Website Issues

| Problem | Solution |
|---------|----------|
| Website is down | Check Manus dashboard for server status |
| Contact form not working | Verify email address in settings |
| Phone number not clickable | Check `tel:` link format in code |
| Slow page load | Compress images, check hosting status |

### SEO Issues

| Problem | Solution |
|---------|----------|
| Not showing up in Google | Submit sitemap, wait 30 days for indexing |
| Dropped rankings | Check Google Search Console for errors |
| Low traffic | Increase content, build backlinks, optimize GMB |
| High bounce rate | Improve page speed, enhance content quality |

### Cotton Pins Issues

| Problem | Solution |
|---------|----------|
| Jobs not syncing | Check Cotton Pins API status, refresh page |
| Photos not loading | Verify image URLs, check Cotton Pins storage |
| GPS coordinates wrong | Edit job pin, update coordinates manually |
| Duplicate jobs | Delete duplicates via admin dashboard |

---

## 📞 Support Contacts

### Manus AI (Website Platform)
- **For:** Website issues, technical support, feature requests
- **Contact:** Via Manus dashboard chat

### Cotton Pins (Job Documentation App)
- **For:** iPad app issues, API problems, data sync
- **Website:** cottonpins-3rqvafpp.manus.space

### Google Support
- **Search Console:** [https://support.google.com/webmasters](https://support.google.com/webmasters)
- **My Business:** [https://support.google.com/business](https://support.google.com/business)

---

## ✅ Success Metrics

### Month 1 Goals:
- [ ] Website indexed by Google (check Search Console)
- [ ] GMB listing updated with new website URL
- [ ] 10+ contact form submissions or phone calls from website
- [ ] 30+ job pins syncing from Cotton Pins

### Month 3 Goals:
- [ ] 100+ organic visitors per month
- [ ] Ranking on page 1 for "Cotton City Plumbing"
- [ ] 50+ contact form submissions or calls from website
- [ ] 75+ job pins syncing from Cotton Pins
- [ ] 10+ job pin pages indexed by Google

### Month 6 Goals:
- [ ] 500+ organic visitors per month
- [ ] Ranking on page 1 for 5+ service keywords
- [ ] 100+ leads from website
- [ ] 150+ job pins syncing from Cotton Pins
- [ ] 50+ job pin pages indexed by Google

---

## 🎉 You're All Set!

Your Cotton City Plumbing website is now live and optimized for success. Follow this checklist to ensure you're getting maximum value from your investment.

**Priority order:**
1. **Week 1:** Google Search Console + GMB update (critical for SEO)
2. **Week 2:** Cotton Pins monitoring + social media updates
3. **Month 1:** Analytics setup + marketing promotion
4. **Ongoing:** Monthly monitoring and optimization

**Questions?** Refer to the detailed guides:
- `GOOGLE_SEARCH_CONSOLE_GUIDE.md`
- `GOOGLE_MY_BUSINESS_GUIDE.md`
- `COTTON_PINS_MONITORING_GUIDE.md`

**Need help?** Contact Manus AI via the dashboard chat anytime.

Good luck with your new website! 🚀
