# Cotton City Plumbing Website Launch Checklist

This checklist covers all steps needed when switching from your existing website to this new Manus-hosted site.

## Pre-Launch Preparation (1-2 Weeks Before)

### Domain Setup
- [ ] Decide on final domain (cottoncityplumbing.com or callccp.com)
- [ ] Access domain DNS settings through Aligned By Design or domain registrar
- [ ] Backup existing website completely (files, database, content)
- [ ] Document all existing URLs for redirect mapping

### Content Verification
- [ ] Review all 58 neighborhood pages for accuracy
- [ ] Verify business information (address, phone, email, hours)
- [ ] Test all service pages and blog posts
- [ ] Check all images load correctly
- [ ] Verify booking widget (Housecall Pro) integration works

### Technical Setup
- [ ] Set up Google Search Console for new domain
- [ ] Set up Google Analytics 4 for new domain
- [ ] Create XML sitemap (see instructions below)
- [ ] Prepare 301 redirect list from old site URLs to new site URLs

## Launch Day

### DNS & Domain Configuration
- [ ] In Manus Dashboard → Settings → Domains, add your custom domain
- [ ] Follow Manus instructions to update DNS records (A record, CNAME, etc.)
- [ ] Wait for DNS propagation (typically 1-24 hours)
- [ ] Verify SSL certificate is active on new domain

### SEO & Search Engine Setup
- [ ] Submit XML sitemap to Google Search Console (instructions below)
- [ ] Submit sitemap to Bing Webmaster Tools
- [ ] Implement 301 redirects from old site to new site
- [ ] Update robots.txt if needed
- [ ] Verify structured data (schema markup) with Google Rich Results Test

### Business Listings Updates
- [ ] Update Google Business Profile with new website URL
- [ ] Update Yelp business listing
- [ ] Update Facebook business page
- [ ] Update Nextdoor business profile
- [ ] Update any directory listings (Angi, HomeAdvisor, etc.)

### Marketing Materials
- [ ] Update business cards with new domain (if changed)
- [ ] Update truck wraps/vehicle signage if domain changed
- [ ] Update email signatures
- [ ] Update social media bios with new URL
- [ ] Send announcement email to existing customers

## Post-Launch Monitoring (First 30 Days)

### Week 1
- [ ] Monitor Google Search Console for crawl errors
- [ ] Check Google Analytics for traffic patterns
- [ ] Test all forms and booking submissions
- [ ] Monitor email inbox for form submissions
- [ ] Check mobile responsiveness on multiple devices
- [ ] Test page load speeds with Google PageSpeed Insights

### Week 2-4
- [ ] Monitor search rankings for key terms
- [ ] Track neighborhood page performance in Analytics
- [ ] Review and respond to any user feedback
- [ ] Check for broken links using Manus Code panel or external tool
- [ ] Monitor conversion rates (calls, bookings, form submissions)

### Month 2-3
- [ ] Analyze which neighborhood pages drive most traffic
- [ ] Review blog content performance
- [ ] Optimize underperforming pages
- [ ] Consider paid ads to boost specific neighborhood pages
- [ ] Request reviews from satisfied customers to build social proof

---

## XML Sitemap Creation & Submission Instructions

### Step 1: Generate XML Sitemap

Create a file at `/home/ubuntu/cotton-city-plumbing/public/sitemap.xml` with all your URLs:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <!-- Homepage -->
  <url>
    <loc>https://cottoncityplumbing.com/</loc>
    <changefreq>weekly</changefreq>
    <priority>1.0</priority>
  </url>
  
  <!-- Main Pages -->
  <url>
    <loc>https://cottoncityplumbing.com/about</loc>
    <changefreq>monthly</changefreq>
    <priority>0.8</priority>
  </url>
  <url>
    <loc>https://cottoncityplumbing.com/services</loc>
    <changefreq>monthly</changefreq>
    <priority>0.9</priority>
  </url>
  <url>
    <loc>https://cottoncityplumbing.com/contact</loc>
    <changefreq>monthly</changefreq>
    <priority>0.9</priority>
  </url>
  
  <!-- Service Pages (add all 13 service pages) -->
  <url>
    <loc>https://cottoncityplumbing.com/services/water-heaters</loc>
    <changefreq>monthly</changefreq>
    <priority>0.8</priority>
  </url>
  <!-- ... repeat for all service pages ... -->
  
  <!-- Neighborhood Pages (add all 58 neighborhood pages) -->
  <url>
    <loc>https://cottoncityplumbing.com/areas/tech-terrace</loc>
    <changefreq>monthly</changefreq>
    <priority>0.7</priority>
  </url>
  <url>
    <loc>https://cottoncityplumbing.com/areas/lakeridge</loc>
    <changefreq>monthly</changefreq>
    <priority>0.7</priority>
  </url>
  <!-- ... repeat for all 58 neighborhood pages ... -->
  
  <!-- Blog Posts -->
  <url>
    <loc>https://cottoncityplumbing.com/blog</loc>
    <changefreq>weekly</changefreq>
    <priority>0.7</priority>
  </url>
  <!-- Add individual blog post URLs -->
  
</urlset>
```

### Step 2: Submit to Google Search Console

1. Go to [Google Search Console](https://search.google.com/search-console)
2. Add your property (domain: cottoncityplumbing.com)
3. Verify ownership using DNS verification or HTML tag method
4. Once verified, go to **Sitemaps** in left sidebar
5. Enter sitemap URL: `https://cottoncityplumbing.com/sitemap.xml`
6. Click **Submit**
7. Monitor indexing status over next 2-4 weeks

### Step 3: Submit to Bing Webmaster Tools

1. Go to [Bing Webmaster Tools](https://www.bing.com/webmasters)
2. Add your site
3. Verify ownership
4. Go to **Sitemaps** section
5. Submit: `https://cottoncityplumbing.com/sitemap.xml`

---

## 301 Redirect Planning

Map all old URLs to new URLs to preserve SEO value:

**Example redirects:**
- `old-site.com/about-us` → `cottoncityplumbing.com/about`
- `old-site.com/services.html` → `cottoncityplumbing.com/services`
- `old-site.com/contact-us` → `cottoncityplumbing.com/contact`

**Implementation:**
- If old site is on same hosting, add redirects via `.htaccess` (Apache) or Nginx config
- If different hosting, work with old host to implement redirects
- Keep old domain active with redirects for at least 6-12 months

---

## Support Contacts

- **Manus Support**: https://help.manus.im
- **Domain/DNS Issues**: Contact Aligned By Design
- **Google Business Profile**: https://business.google.com
- **Housecall Pro Support**: For booking widget issues

---

## Success Metrics to Track

After launch, monitor these KPIs:

1. **Organic Traffic**: Should stabilize within 2-4 weeks
2. **Keyword Rankings**: Track "plumber lubbock" and neighborhood-specific terms
3. **Conversion Rate**: Calls, bookings, form submissions
4. **Bounce Rate**: Should be under 60% for neighborhood pages
5. **Page Load Speed**: Target under 3 seconds
6. **Mobile Traffic**: Should be 60-70% of total traffic

---

*Last Updated: January 2026*
