# Google Search Console Setup Guide

**Cotton City Plumbing Website**

This guide walks you through setting up Google Search Console (GSC) for your Cotton City Plumbing website. Google Search Console is a free tool that helps you monitor and optimize your website's presence in Google Search results.

---

## Why Google Search Console Matters

Google Search Console provides critical insights into how Google views and indexes your website. For a local service business like Cotton City Plumbing, GSC helps you understand which keywords bring customers to your site, identify technical issues that might hurt your rankings, and track your visibility in Google Maps and local search results.

**Key benefits for your plumbing business:**

- **Faster indexing** of new job pins and service pages (days instead of weeks)
- **Performance data** showing which searches lead customers to your site
- **Mobile usability reports** ensuring your site works perfectly on phones
- **Security alerts** if Google detects malware or hacking attempts
- **Rich results tracking** for your job pin Schema.org markup

---

## Prerequisites

Before you begin, ensure you have:

- A Google account (Gmail) - use your business email if possible
- Access to edit your website's HTML (already done - verification meta tag is in place)
- Your published website URL (e.g., `https://cottoncityplumbing.com`)

---

## Step 1: Access Google Search Console

Navigate to [Google Search Console](https://search.google.com/search-console) and sign in with your Google account.

Click **"Start now"** if this is your first time, or **"Add property"** if you already have other websites in GSC.

---

## Step 2: Add Your Website Property

You'll see two options for adding your property:

### Option A: Domain Property (Recommended)

This option verifies your entire domain including all subdomains and protocols (http, https, www, non-www).

1. Select **"Domain"** on the left
2. Enter your domain: `cottoncityplumbing.com`
3. Click **"Continue"**

**Note:** This method requires DNS verification through your domain registrar (GoDaddy, Namecheap, etc.). If you're not comfortable editing DNS records, use Option B instead.

### Option B: URL Prefix Property (Easier)

This option verifies a specific URL (e.g., `https://cottoncityplumbing.com`).

1. Select **"URL prefix"** on the right
2. Enter your full website URL: `https://cottoncityplumbing.com`
3. Click **"Continue"**

**We recommend Option B for simplicity** - the HTML meta tag verification is already set up for you.

---

## Step 3: Verify Ownership (HTML Tag Method)

Since your website already has the verification meta tag placeholder, follow these steps:

### 3.1 Get Your Verification Code from Google

After clicking "Continue" in Step 2, Google will show you several verification methods. Select **"HTML tag"**.

Google will display a meta tag that looks like this:

```html
<meta name="google-site-verification" content="abc123XYZ456..." />
```

**Copy only the content value** (the part inside the quotes after `content=`). For example: `abc123XYZ456...`

### 3.2 Update Your Website

1. Open the Manus Management UI for your Cotton City Plumbing project
2. Go to **Code** → Navigate to `client/index.html`
3. Find this line (around line 11):
   ```html
   <meta name="google-site-verification" content="REPLACE_WITH_YOUR_VERIFICATION_CODE" />
   ```
4. Replace `REPLACE_WITH_YOUR_VERIFICATION_CODE` with your actual verification code from Google
5. Save the file
6. Create a new checkpoint to publish the changes

### 3.3 Verify in Google Search Console

1. Return to the Google Search Console verification page
2. Click **"Verify"**
3. Google will check your website for the meta tag
4. If successful, you'll see a confirmation message: **"Ownership verified"**

**Troubleshooting:** If verification fails, wait 1-2 minutes for your changes to deploy, then try clicking "Verify" again.

---

## Step 4: Submit Your Sitemap

Your website automatically generates an XML sitemap at `/sitemap.xml` that includes all your pages and job pins. Submitting this to Google helps ensure all your content gets indexed quickly.

### 4.1 Submit the Sitemap

1. In Google Search Console, click **"Sitemaps"** in the left sidebar
2. Under "Add a new sitemap," enter: `sitemap.xml`
3. Click **"Submit"**

Google will confirm the sitemap was submitted and begin processing it.

### 4.2 Monitor Sitemap Status

Within 24-48 hours, return to the Sitemaps page to check the status:

- **Discovered URLs:** Should show 35+ pages (all your services, areas, job pins, etc.)
- **Status:** Should show "Success" with a green checkmark
- **Last read:** Shows when Google last checked your sitemap

**Note:** Google automatically checks your sitemap regularly. Every time you add a new job pin, it will appear in the sitemap within minutes and Google will discover it on the next crawl.

---

## Step 5: Explore Key Reports

Once verified and your sitemap is submitted, explore these essential reports:

### Performance Report

Shows which search queries bring visitors to your site.

**Location:** Search Console → Performance

**What to look for:**
- **Top queries:** Which plumbing services people search for (e.g., "water heater repair Lubbock")
- **Top pages:** Which pages get the most clicks
- **Position:** Your average ranking for each query
- **CTR (Click-through rate):** Percentage of people who click your result

**Action:** Identify high-impression, low-CTR queries and improve those pages' titles and descriptions.

### URL Inspection Tool

Check if specific pages are indexed and identify issues.

**Location:** Search Console → URL Inspection (top search bar)

**How to use:**
1. Paste any page URL from your site (e.g., `https://cottoncityplumbing.com/recent-jobs/123`)
2. Press Enter
3. Google shows if the page is indexed, when it was last crawled, and any errors

**Action:** If a new job pin isn't indexed after a week, use "Request Indexing" to prioritize it.

### Coverage Report

Shows which pages are indexed and which have errors.

**Location:** Search Console → Coverage

**What to look for:**
- **Valid:** Pages successfully indexed (should be 35+)
- **Excluded:** Pages intentionally not indexed (e.g., `/admin/` pages)
- **Error:** Pages with problems preventing indexing
- **Valid with warnings:** Pages indexed but with minor issues

**Action:** Fix any errors immediately - they prevent pages from appearing in search results.

### Mobile Usability Report

Ensures your site works perfectly on mobile devices.

**Location:** Search Console → Mobile Usability

**What to look for:**
- **Valid pages:** Should match your total page count
- **Errors:** Issues like "Text too small" or "Clickable elements too close"

**Action:** Your site is already mobile-responsive, so this should show all valid. If errors appear, report them to your developer.

---

## Step 6: Set Up Email Notifications

Get alerts when Google detects issues with your site.

1. In Google Search Console, click the **Settings** icon (gear) in the top right
2. Select **"Users and permissions"**
3. Ensure your email is listed and notifications are enabled
4. Google will email you about:
   - Critical indexing errors
   - Security issues (malware, hacking)
   - Manual actions (penalties)
   - New messages in Search Console

---

## Ongoing Maintenance

### Weekly Tasks

- Check the **Performance** report to see which keywords are growing
- Review new job pins to ensure they're being indexed

### Monthly Tasks

- Review the **Coverage** report for new errors
- Check **Mobile Usability** to ensure no new issues
- Analyze top-performing pages and create similar content

### As Needed

- Use **URL Inspection** to request indexing for important new pages
- Check **Security Issues** if you receive an alert email

---

## Common Questions

### How long until my pages appear in Google?

After submitting your sitemap, Google typically indexes new pages within 3-7 days. High-quality pages with good content may appear faster. Use the URL Inspection tool to request priority indexing for important pages.

### Why aren't my job pins showing up in search yet?

New websites can take 2-4 weeks to gain traction in search results. Focus on:
- Adding more job pins (aim for 50-100 total)
- Getting customer reviews on Google Business Profile
- Building local citations (Yelp, Yellow Pages, etc.)

### What's a good click-through rate (CTR)?

For local service businesses, a CTR of 3-5% is average. Pages ranking in positions 1-3 often see 10-20% CTR. Improve CTR by writing compelling meta titles and descriptions.

### Should I use Domain or URL Prefix property?

For most small businesses, **URL Prefix** is simpler and sufficient. Domain properties require DNS verification and are mainly useful if you have multiple subdomains (e.g., `blog.cottoncityplumbing.com`, `shop.cottoncityplumbing.com`).

---

## Additional Resources

- [Google Search Console Help Center](https://support.google.com/webmasters)
- [Google's SEO Starter Guide](https://developers.google.com/search/docs/fundamentals/seo-starter-guide)
- [Local Business Schema Markup Guide](https://developers.google.com/search/docs/appearance/structured-data/local-business)

---

## Need Help?

If you encounter issues during setup or have questions about interpreting your Search Console data, contact your web developer or SEO consultant for assistance.

---

**Document prepared by Manus AI**  
**Last updated:** December 8, 2025
